/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao;

import java.util.UUID;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.sql.BusinessEntityDto;
import org.thingsboard.trendz.dao.sql.BusinessEntityFieldDto;

@Repository
public interface BusinessEntityRepository
extends CrudRepository<BusinessEntityDto, String> {
    public Iterable<BusinessEntityDto> findAllByTenantId(UUID var1);

    public BusinessEntityDto findByIdAndTenantId(UUID var1, UUID var2);

    @Query(value="select beF from BusinessEntityFieldDto beF where beF.id = :id")
    public BusinessEntityFieldDto findFieldById(@Param(value="id") UUID var1);

    @Query(value="select be.id from business_entity be where be.name = :entityName and be.tenantId = :tenantId")
    public UUID findIdByNameAndTenantId(@Param(value="entityName") String var1, @Param(value="tenantId") UUID var2);

    @Query(value="select beF from BusinessEntityFieldDto beF where beF.name = :fieldName and  beF.businessEntityId in (select be.id from business_entity be where be.name = :entityName and be.tenantId = :tenantId)")
    public BusinessEntityFieldDto findEntityFieldByNameAndEntityName(@Param(value="fieldName") String var1, @Param(value="entityName") String var2, @Param(value="tenantId") UUID var3);

    public void deleteByIdAndTenantId(UUID var1, UUID var2);
}

