/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.runtime.ViewTask;
import org.thingsboard.trendz.service.view.ViewService;
import org.thingsboard.trendz.service.view.ViewTaskCache;

@RestController
@RequestMapping(value={"/apiTrendz/view/runtime/"})
public class ViewController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ViewController.class);
    @Autowired
    private ViewService viewService;
    @Autowired
    private ViewTaskCache viewTaskCache;

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/run"}, method={RequestMethod.POST})
    @ResponseBody
    public ViewTask buildReportAsync(@RequestBody ViewConfig viewConfig) {
        if (!this.subscriptionService.getSubscriptionState().isValid()) {
            log.warn("Trendz License not valid. Skip visualization build for tenant {}", (Object)this.getTenantId());
            return new ViewTask(true, "Trendz License not valid. Skip visualization build");
        }
        return this.viewService.buildViewAsync(viewConfig, this.getTenantId(), this.getJwtToken());
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/get/{taskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ViewTask getTask(@PathVariable(value="taskId") UUID taskId) {
        if (!this.subscriptionService.getSubscriptionState().isValid()) {
            log.warn("Trendz License not valid. Skip visualization build for tenant {}", (Object)this.getTenantId());
            return new ViewTask(true, "Trendz License not valid. Skip visualization build");
        }
        Optional task = this.viewTaskCache.getTask(taskId);
        if (task.isPresent()) {
            return (ViewTask)task.get();
        }
        throw new IllegalStateException("Task " + taskId + " Expired. Contact Administrator");
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/cancel/{taskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean cancelTask(@PathVariable(value="taskId") UUID taskId) {
        log.debug("User cancel task {}", (Object)taskId);
        this.viewTaskCache.cancelTask(taskId, "user cancel");
        return true;
    }
}

