/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.service.ViewConfigService;
import org.thingsboard.trendz.service.cache.CachedTelemetryService;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTaskHistoryRecord;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTaskHistoryRecordService;

@RestController
@RequestMapping(value={"/apiTrendz/view/config"})
public class ViewConfigController
extends BaseController {
    @Autowired
    private ViewConfigService viewConfigService;
    @Autowired
    private ScheduledTaskHistoryRecordService recordService;
    @Autowired
    private CachedTelemetryService cachedTelemetryService;

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ViewConfig> getAllConfigs() {
        return this.viewConfigService.getAll(this.getTenantId());
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{configId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ViewConfig findById(@PathVariable(value="configId") String strConfigId) {
        UUID configId = UUID.fromString(strConfigId);
        ViewConfig config = this.viewConfigService.findConfigById(this.getTenantId(), configId);
        if (config != null) {
            return config;
        }
        throw new IllegalStateException("View Config not found by ID " + strConfigId);
    }

    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public ViewConfig save(@RequestBody ViewConfig viewConfig) {
        return this.viewConfigService.save(this.getTenantId(), viewConfig);
    }

    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/delete/{configId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public boolean delete(@PathVariable(value="configId") String strConfigId) {
        ViewConfig config = this.findById(strConfigId);
        return this.viewConfigService.delete(this.getTenantId(), config.getId());
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/schedulingRecords/{configId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ScheduledTaskHistoryRecord> getScheduledTaskRecords(@PathVariable(value="configId") String strConfigId) {
        UUID configId = UUID.fromString(strConfigId);
        return this.recordService.getHistoryRecordsForViewConfig(this.getTenantId(), configId);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/caches/remove"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean removeCaches() {
        this.cachedTelemetryService.removeAllCacheByTenantId(this.getTenantId()).toProcessor().block();
        return true;
    }
}

