/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.task.Task;
import org.thingsboard.trendz.task.TaskService;

@RestController
@RequestMapping(value={"/apiTrendz/task"})
public class TaskController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(TaskController.class);
    @Autowired
    private TaskService taskService;

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{taskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Task getTask(@PathVariable(value="taskId") UUID taskId) {
        Task task = this.taskService.getTask(taskId);
        if (task != null) {
            return task;
        }
        throw new IllegalStateException("Task " + taskId + " Does not exist");
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/cancel/{taskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean cancelTask(@PathVariable(value="taskId") UUID taskId) {
        log.info("User cancel task {}", (Object)taskId);
        this.taskService.cancelTask(taskId);
        return true;
    }
}

