/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.async.DeferredResult;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.simple.BuildViewByReferenceTask;
import org.thingsboard.trendz.domain.simple.SimpleApiTask;
import org.thingsboard.trendz.domain.simple.SimpleViewReport;
import org.thingsboard.trendz.domain.simple.ViewConfigReference;
import org.thingsboard.trendz.service.simple.SimpleApiServiceRateLimiter;

@Controller
@RequestMapping(value={"/apiTrendz/publicApi"})
public class SimpleApiController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(SimpleApiController.class);
    @Autowired
    private SimpleApiServiceRateLimiter simpleApiServiceRateLimiter;

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/buildReport"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public DeferredResult<ResponseEntity<SimpleViewReport>> buildViewByReference(@RequestBody ViewConfigReference viewConfigReference) {
        BuildViewByReferenceTask task = BuildViewByReferenceTask.builder().reference(viewConfigReference).tenantId(this.getTenantId()).jwtToken(this.getJwtToken()).build();
        DeferredResult result = new DeferredResult();
        ListenableFuture simpleApiTaskListenableFuture = this.simpleApiServiceRateLimiter.submitTask((SimpleApiTask)task);
        Futures.addCallback((ListenableFuture)simpleApiTaskListenableFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)MoreExecutors.directExecutor());
        return result;
    }
}

