/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.ml.ModelService;
import org.thingsboard.trendz.ml.domain.Model;
import org.thingsboard.trendz.ml.domain.ModelProperties;
import org.thingsboard.trendz.ml.util.ClusterTool;
import org.thingsboard.trendz.task.Task;
import org.thingsboard.trendz.task.TaskService;

@RestController
@RequestMapping(value={"/apiTrendz/model"})
public class ModelController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ModelController.class);
    @Autowired
    private ModelService modelService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ClusterTool clusterTool;

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/getAll"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Model> getAllModels() {
        return this.modelService.getAllModels(this.getTenantId());
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/get/{modelId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Model getModel(@PathVariable(value="modelId") UUID modelId) {
        return this.modelService.getModelById(modelId);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    @ResponseBody
    public Task createModel(@RequestBody ModelProperties props) {
        props.getDatasetConfig().setTenantId(this.getTenantId());
        props.getDatasetConfig().setJwtToken(this.getJwtToken());
        return this.modelService.buildModelAsync(props);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/delete/{modelId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public boolean deleteModel(@PathVariable(value="modelId") UUID modelId) {
        return this.modelService.deleteModel(modelId);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/tasks/{modelId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Task> getModelTasks(@PathVariable(value="modelId") UUID modelId) {
        return this.taskService.findAnomalyTasksForModel(modelId);
    }
}

