/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.definition.dto.MigrationDto;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.service.ViewConfigService;
import org.thingsboard.trendz.service.definition.BusinessEntityService;

@Controller
@RequestMapping(value={"/apiTrendz/migration"})
public class MigrationController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(MigrationController.class);
    @Autowired
    private ViewConfigService viewConfigService;
    @Autowired
    private BusinessEntityService businessEntityService;

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/export"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public MigrationDto exportMigrationData() {
        List exportedViewConfigs = this.viewConfigService.getAll(this.getTenantId());
        List exportedBusinessEntities = this.businessEntityService.getAllEntities(this.getTenantId());
        log.info("Export action was done: {} view configs, {} business entities were exported.", (Object)exportedViewConfigs.size(), (Object)exportedBusinessEntities.size());
        return new MigrationDto(exportedViewConfigs, exportedBusinessEntities);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/import"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public MigrationDto importMigrationData(@RequestBody MigrationDto importData) {
        List importedViewConfigs = importData.getViewConfigs();
        List importedBusinessEntities = importData.getBusinessEntities();
        Set currentViewConfigIds = this.viewConfigService.getAll(this.getTenantId()).stream().map(ViewConfig::getId).collect(Collectors.toSet());
        List savedViewConfigs = importedViewConfigs.stream().filter(viewConfig -> !currentViewConfigIds.contains(viewConfig.getId())).peek(viewConfig -> this.viewConfigService.save(this.getTenantId(), viewConfig)).collect(Collectors.toList());
        List savedBusinessEntities = importedBusinessEntities.stream().peek(businessEntity -> this.businessEntityService.save(this.getTenantId(), businessEntity)).collect(Collectors.toList());
        log.info("Import action was done: {} view configs, {} business entities were provided; {} view configs, {} business entities were imported.", new Object[]{importedViewConfigs.size(), importedBusinessEntities.size(), savedViewConfigs.size(), savedBusinessEntities.size()});
        return new MigrationDto(savedViewConfigs, savedBusinessEntities);
    }
}

