/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.InitStatus;
import org.thingsboard.trendz.service.definition.DiscoverConfig;
import org.thingsboard.trendz.service.definition.InitializationService;

@RestController
@RequestMapping(value={"/apiTrendz/init"})
public class InitializationController
extends BaseController {
    @Autowired
    private InitializationService initializationService;

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/status"}, method={RequestMethod.GET})
    @ResponseBody
    public InitStatus getInitStatus() {
        return this.initializationService.getInitStatus(this.getTenantId());
    }

    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/refresh"}, method={RequestMethod.POST})
    @ResponseBody
    public InitStatus refreshTopologyAsync(@RequestBody DiscoverConfig discoverConfig) {
        return this.initializationService.initTopology(this.getTenantId(), discoverConfig, this.getJwtToken());
    }
}

