/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.ml.ClusterTaskCache;
import org.thingsboard.trendz.ml.MLService;
import org.thingsboard.trendz.ml.domain.ClusterTask;
import org.thingsboard.trendz.ml.util.FakeUtil;

@RestController
@RequestMapping(value={"/apiTrendz/cluster"})
public class ClusterController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ClusterController.class);
    @Autowired
    private MLService mlService;
    @Autowired
    private ClusterTaskCache clusterTaskCache;
    @Autowired
    private FakeUtil fakeUtil;

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/build"}, method={RequestMethod.POST})
    @ResponseBody
    public ClusterTask buildClusters(@RequestBody String body) {
        return this.mlService.runAsyncClusterTask(this.getTenantId(), this.getJwtToken());
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/get/{taskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ClusterTask getTask(@PathVariable(value="taskId") UUID taskId) {
        Optional task = this.clusterTaskCache.getTask(taskId);
        if (task.isPresent()) {
            return (ClusterTask)task.get();
        }
        throw new IllegalStateException("Task " + taskId + " Expired. Contact Administrator");
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/cancel/{taskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean cancelTask(@PathVariable(value="taskId") UUID taskId) {
        log.debug("User cancel task {}", (Object)taskId);
        this.clusterTaskCache.cancelTask(taskId, "user cancel");
        return true;
    }
}

