/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.service.definition.BusinessEntityService;

@RestController
@RequestMapping(value={"/apiTrendz/businessEntity"})
public class BusinessEntityController
extends BaseController {
    @Autowired
    private BusinessEntityService businessEntityService;

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    @ResponseBody
    public List<BusinessEntity> getBusinessEntities() {
        return this.businessEntityService.getAllEntities(this.getTenantId());
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public BusinessEntity findById(@PathVariable(value="id") String strEntityId) {
        UUID configId = UUID.fromString(strEntityId);
        BusinessEntity entity = this.businessEntityService.findEntityById(this.getTenantId(), configId);
        if (entity != null) {
            return entity;
        }
        throw new IllegalStateException("Business Entity not found by ID " + strEntityId);
    }

    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public BusinessEntity save(@RequestBody BusinessEntity businessEntity) {
        return this.businessEntityService.save(this.getTenantId(), businessEntity);
    }

    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/delete/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public boolean delete(@PathVariable(value="id") String strEntityId) {
        BusinessEntity entity = this.findById(strEntityId);
        return this.businessEntityService.deleteEntity(this.getTenantId(), entity.getId());
    }
}

