/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.security.entity.SecurityUser;
import org.thingsboard.trendz.subscription.SubscriptionService;

public abstract class BaseController {
    @Autowired
    protected SubscriptionService subscriptionService;

    protected String getJwtToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.getPrincipal() instanceof SecurityUser) {
            String token = ((SecurityUser)authentication.getPrincipal()).getAuthToken().getToken();
            this.subscriptionService.triggerCheck(token);
            return token;
        }
        throw new IllegalStateException("You aren't authorized to perform this operation!");
    }

    protected TenantId getTenantId() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.getPrincipal() instanceof SecurityUser) {
            UUID tenantId = ((SecurityUser)authentication.getPrincipal()).getTenantId();
            return new TenantId(tenantId);
        }
        throw new IllegalStateException("You aren't authorized to perform this operation!");
    }
}

