/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.ml.AnomalyService;
import org.thingsboard.trendz.ml.ModelService;
import org.thingsboard.trendz.ml.anomaly.AnomalyFilter;
import org.thingsboard.trendz.ml.domain.Anomaly;
import org.thingsboard.trendz.ml.domain.DatasetConfig;
import org.thingsboard.trendz.ml.domain.ItemDataFilter;
import org.thingsboard.trendz.ml.domain.Model;
import org.thingsboard.trendz.ml.domain.SimpleTsPoint;
import org.thingsboard.trendz.task.Task;
import org.thingsboard.trendz.task.TaskService;

@RestController
@RequestMapping(value={"/apiTrendz/anomaly"})
public class AnomalyController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(AnomalyController.class);
    @Autowired
    private AnomalyService anomalyService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private TaskService taskService;

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/discover/{modelId}"}, method={RequestMethod.POST})
    @ResponseBody
    public Task<List<Anomaly>> discoverAnomalies(@PathVariable(value="modelId") UUID modelId, @RequestBody DatasetConfig datasetConfig) {
        datasetConfig.setTenantId(this.getTenantId());
        datasetConfig.setJwtToken(this.getJwtToken());
        return this.anomalyService.discoverAnomaliesAsync(modelId, datasetConfig);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/get"}, method={RequestMethod.POST})
    @ResponseBody
    public List<Anomaly> getAnomalies(@RequestBody AnomalyFilter filter) {
        long start = System.currentTimeMillis();
        List anomalies = this.anomalyService.getAnomalies(filter);
        log.info("get {} anomalies took {} ms", (Object)anomalies.size(), (Object)(System.currentTimeMillis() - start));
        return anomalies;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/removeForModel/{modelId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public boolean removeByModelId(@PathVariable(value="modelId") UUID modelId) {
        List tasks = this.taskService.findAnomalyTasksForModel(modelId);
        tasks.forEach(t -> this.taskService.removeTaskById(t.getId()));
        return this.anomalyService.removeByModelId(modelId);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/removeForTask/{taskId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public boolean removeByTaskId(@PathVariable(value="taskId") UUID taskId) {
        return this.anomalyService.removeByTaskId(taskId);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/itemPoints"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<UUID, List<SimpleTsPoint>> getItemFieldValues(@RequestBody ItemDataFilter filter) {
        Model model = this.modelService.getModelById(filter.getModelId());
        DatasetConfig datasetConfig = model.getDatasetConfig();
        datasetConfig.setTenantId(this.getTenantId());
        datasetConfig.setJwtToken(this.getJwtToken());
        return this.anomalyService.getItemFieldValues(datasetConfig, filter.getViewFieldId(), filter.getItemName(), filter.getStartTs(), filter.getEndTs());
    }
}

