/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.config;

import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.thingsboard.trendz.security.JwtAuthenticationProvider;
import org.thingsboard.trendz.security.JwtTokenAuthenticationProcessingFilter;
import org.thingsboard.trendz.security.RefreshTokenAuthenticationProvider;
import org.thingsboard.trendz.security.RefreshTokenProcessingFilter;
import org.thingsboard.trendz.security.RestLoginProcessingFilter;
import org.thingsboard.trendz.security.SkipPathRequestMatcher;
import org.thingsboard.trendz.security.TbAuthenticationProvider;
import org.thingsboard.trendz.security.TokenExtractor;
import org.thingsboard.trendz.security.TrendzErrorResponseHandler;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    public static final String FORM_BASED_LOGIN_ENTRY_POINT = "/apiTrendz/auth/login";
    public static final String TOKEN_REFRESH_ENTRY_POINT = "/apiTrendz/auth/refreshToken";
    protected static final String[] NON_TOKEN_BASED_AUTH_ENTRY_POINTS = new String[]{"/index.html", "/static/**", "/apiTrendz/noauth/**", "/webjars/**"};
    public static final String TOKEN_BASED_AUTH_ENTRY_POINT = "/apiTrendz/**";
    public static final String WEBJARS_ENTRY_POINT = "/webjars/**";
    @Autowired
    private TbAuthenticationProvider tbAuthenticationProvider;
    @Autowired
    private JwtAuthenticationProvider jwtAuthenticationProvider;
    @Autowired
    private RefreshTokenAuthenticationProvider refreshTokenAuthenticationProvider;
    @Autowired
    private TokenExtractor tokenExtractor;
    @Autowired
    private AuthenticationSuccessHandler successHandler;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private TrendzErrorResponseHandler restAccessDeniedHandler;

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.headers().cacheControl().and().frameOptions().disable().and()).cors().and()).csrf().disable()).exceptionHandling().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(new String[]{WEBJARS_ENTRY_POINT})).permitAll().antMatchers(new String[]{FORM_BASED_LOGIN_ENTRY_POINT})).permitAll().antMatchers(new String[]{TOKEN_REFRESH_ENTRY_POINT})).permitAll().antMatchers(NON_TOKEN_BASED_AUTH_ENTRY_POINTS)).permitAll().and()).authorizeRequests().antMatchers(new String[]{TOKEN_BASED_AUTH_ENTRY_POINT})).authenticated().and()).exceptionHandling().accessDeniedHandler((AccessDeniedHandler)this.restAccessDeniedHandler).and()).addFilterBefore((Filter)this.buildRestLoginProcessingFilter(), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)this.buildJwtTokenAuthenticationProcessingFilter(), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)this.buildRefreshTokenProcessingFilter(), UsernamePasswordAuthenticationFilter.class);
    }

    @Bean
    CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(Arrays.asList("*"));
        configuration.setAllowedMethods(Arrays.asList("GET", "POST", "OPTIONS", "DELETE", "PUT", "PATCH"));
        configuration.setAllowedHeaders(Arrays.asList("*"));
        configuration.setAllowCredentials(Boolean.valueOf(true));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }

    @Bean
    protected RestLoginProcessingFilter buildRestLoginProcessingFilter() throws Exception {
        RestLoginProcessingFilter filter = new RestLoginProcessingFilter(FORM_BASED_LOGIN_ENTRY_POINT, this.successHandler, (AuthenticationFailureHandler)this.restAccessDeniedHandler);
        filter.setAuthenticationManager(this.authenticationManager);
        return filter;
    }

    @Bean
    protected JwtTokenAuthenticationProcessingFilter buildJwtTokenAuthenticationProcessingFilter() throws Exception {
        ArrayList<String> pathsToSkip = new ArrayList<String>(Arrays.asList(NON_TOKEN_BASED_AUTH_ENTRY_POINTS));
        pathsToSkip.addAll(Arrays.asList(FORM_BASED_LOGIN_ENTRY_POINT, WEBJARS_ENTRY_POINT, TOKEN_REFRESH_ENTRY_POINT));
        SkipPathRequestMatcher matcher = new SkipPathRequestMatcher(pathsToSkip, TOKEN_BASED_AUTH_ENTRY_POINT);
        JwtTokenAuthenticationProcessingFilter filter = new JwtTokenAuthenticationProcessingFilter((AuthenticationFailureHandler)this.restAccessDeniedHandler, this.tokenExtractor, (RequestMatcher)matcher);
        filter.setAuthenticationManager(this.authenticationManager);
        return filter;
    }

    @Bean
    protected RefreshTokenProcessingFilter buildRefreshTokenProcessingFilter() throws Exception {
        RefreshTokenProcessingFilter filter = new RefreshTokenProcessingFilter(TOKEN_REFRESH_ENTRY_POINT, this.successHandler, (AuthenticationFailureHandler)this.restAccessDeniedHandler);
        filter.setAuthenticationManager(this.authenticationManager);
        return filter;
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    protected void configure(AuthenticationManagerBuilder auth) {
        auth.authenticationProvider((AuthenticationProvider)this.tbAuthenticationProvider);
        auth.authenticationProvider((AuthenticationProvider)this.jwtAuthenticationProvider);
        auth.authenticationProvider((AuthenticationProvider)this.refreshTokenAuthenticationProvider);
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/static/**"});
    }
}

