@ECHO OFF
setlocal ENABLEEXTENSIONS

::
:: Copyright © 2016-2026 The Thingsboard Authors
::
:: Licensed under the Apache License, Version 2.0 (the "License");
:: you may not use this file except in compliance with the License.
:: You may obtain a copy of the License at
::
::     http://www.apache.org/licenses/LICENSE-2.0
::
:: Unless required by applicable law or agreed to in writing, software
:: distributed under the License is distributed on an "AS IS" BASIS,
:: WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
:: See the License for the specific language governing permissions and
:: limitations under the License.
::

:CHECK_JAVA
for /f "tokens=3" %%g in ('java -version 2^>^&1 ^| findstr /i "version"') do (
    set "jver_str=%%g"
)
set "jver_str=%jver_str:"=%"
for /f "delims=." %%v in ("%jver_str%") do (
    set /a "jver=%%v"
)

if %jver% LSS 17 (
    @ECHO Error: Java 17 or higher is required.
    PAUSE
    GOTO END
)

:RESET_SYNC
@ECHO Starting Trendz Sync Reset Entrypoint...

SET BASE=%~dp0
SET JAR_FILE=%BASE%\lib\trendz.jar
SET INSTALL_DIR=%BASE%\data
SET LOGBACK_CONFIG=%BASE%\install\logback.xml

PUSHD "%BASE%\conf"

java -cp "%JAR_FILE%" -Dloader.main=org.thingsboard.trendz.SyncResetEntrypoint^
                    -Dinstall.data_dir="%INSTALL_DIR%"^
                    -Dspring.jpa.hibernate.ddl-auto=none^
                    -Dlogging.config="%LOGBACK_CONFIG%"^
                    org.springframework.boot.loader.launch.PropertiesLauncher

if errorlevel 1 (
   @ECHO Execution failed with error code %errorlevel%
   POPD
   PAUSE
   exit /b %errorlevel%
)
POPD

@ECHO Task completed successfully.
PAUSE

:END