@ECHO OFF
setlocal ENABLEEXTENSIONS

::
:: Copyright © 2016-2026 The Thingsboard Authors
::
:: Licensed under the Apache License, Version 2.0 (the "License");
:: you may not use this file except in compliance with the License.
:: You may obtain a copy of the License at
::
::     http://www.apache.org/licenses/LICENSE-2.0
::
:: Unless required by applicable law or agreed to in writing, software
:: distributed under the License is distributed on an "AS IS" BASIS,
:: WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
:: See the License for the specific language governing permissions and
:: limitations under the License.
::

:CHECK_ADMIN
net session >nul 2>&1
if %errorLevel% NEQ 0 (
    @ECHO -----------------------------------------------------------------------
    @ECHO ERROR: Administrative privileges are required!
    @ECHO Please right-click on this script and select "Run as administrator".
    @ECHO -----------------------------------------------------------------------
    PAUSE
    GOTO END
)

:CHECK_JAVA
for /f "tokens=3" %%g in ('java -version 2^>^&1 ^| findstr /i "version"') do (
    set "jver_str=%%g"
)
set "jver_str=%jver_str:"=%"
for /f "delims=." %%v in ("%jver_str%") do (
    set /a "jver=%%v"
)

@ECHO Current Java version detected: %jver%

if %jver% LSS 17 GOTO JAVA_INCOMPATIBLE

@ECHO Java %jver% found!
GOTO INSTALL_TRENDZ

:INSTALL_TRENDZ
@ECHO Installing Trendz ...

SET loadDemo=false
if "%1" == "--loadDemo" (
    SET loadDemo=true
)

SET BASE=%~dp0
SET LOADER_PATH=%BASE%\conf,%BASE%\extensions
SET jarfile=%BASE%\lib\trendz.jar
SET installDir=%BASE%\data

PUSHD "%BASE%\conf"

java -cp "%jarfile%" -Dloader.main=org.thingsboard.trendz.TrendzInstall^
                    -Dinstall.data_dir="%installDir%"^
                    -Dinstall.load_demo=%loadDemo%^
                    -Dspring.jpa.hibernate.ddl-auto=none^
                    -Dinstall.upgrade=false^
                    -Dlogging.config="%BASE%\install\logback.xml"^
                    org.springframework.boot.loader.launch.PropertiesLauncher

if errorlevel 1 (
   @echo Trendz installation failed!
   POPD
   exit /b %errorlevel%
)
POPD

"%BASE%"trendz.exe install

@ECHO Trendz installed successfully!
GOTO END

:JAVA_INCOMPATIBLE
@ECHO -----------------------------------------------------------------------
@ECHO ERROR: Java %jver% is detected, but Java 17 or higher is required.
@ECHO Please install Java 17 or newer and try again.
@ECHO -----------------------------------------------------------------------
PAUSE
GOTO END

:END