/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.tools;

import java.util.Arrays;
import java.util.Locale;
import java.util.TimeZone;
import lombok.Generated;

public final class EntrypointUtils {
    private static final String SPRING_CONFIG_NAME_KEY = "--spring.config.name";
    private static final String DEFAULT_SPRING_CONFIG_PARAM = "--spring.config.name=trendz";

    public static String[] updateArguments(String[] args) {
        if (Arrays.stream(args).noneMatch(arg -> arg.startsWith(SPRING_CONFIG_NAME_KEY))) {
            String[] modifiedArgs = new String[args.length + 1];
            System.arraycopy(args, 0, modifiedArgs, 0, args.length);
            modifiedArgs[args.length] = DEFAULT_SPRING_CONFIG_PARAM;
            return modifiedArgs;
        }
        return args;
    }

    public static String[] updateArgumentsDisableWeb(String[] args) {
        if (Arrays.stream(args).noneMatch(arg -> arg.startsWith(SPRING_CONFIG_NAME_KEY))) {
            String[] modifiedArgs = new String[args.length + 3];
            System.arraycopy(args, 0, modifiedArgs, 0, args.length);
            modifiedArgs[args.length] = DEFAULT_SPRING_CONFIG_PARAM;
            modifiedArgs[args.length + 1] = "--spring.main.web-application-type=none";
            modifiedArgs[args.length + 2] = "--spring.jpa.hibernate.ddl-auto=none";
            return modifiedArgs;
        }
        return args;
    }

    public static void setDefaultTimezone() {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        Locale.setDefault(Locale.US);
    }

    @Generated
    private EntrypointUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

