/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.subscription;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;
import org.thingsboard.license.client.TbLicenseClient;
import org.thingsboard.license.client.TbLicenseClientListener;
import org.thingsboard.license.shared.exception.LicenseErrorCode;
import org.thingsboard.license.shared.exception.LicenseException;
import org.thingsboard.trendz.domain.system.Deployment;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.customize.UserManagementService;
import org.thingsboard.trendz.service.provider.TbAssetService;
import org.thingsboard.trendz.service.provider.TbDeviceService;
import org.thingsboard.trendz.subscription.DiscoverySubscriptionUtils;
import org.thingsboard.trendz.subscription.SubscriptionErrorType;
import org.thingsboard.trendz.subscription.SubscriptionPlanData;
import org.thingsboard.trendz.subscription.SubscriptionService;
import org.thingsboard.trendz.subscription.SubscriptionState;
import org.thingsboard.trendz.subscription.SubscriptionType;
import org.thingsboard.trendz.subscription.SubscriptionVersion;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Component
public class SelfHostedSubscriptionServiceV1
implements SubscriptionService,
TbLicenseClientListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SelfHostedSubscriptionServiceV1.class);
    private static final String MAX_DEVICES_KEY = "device_count";
    private static final String MAX_ASSETS_KEY = "asset_count";
    private static final long CHECK_INTERVAL = TimeUnit.HOURS.toMillis(12L);
    private final String licenseSecret;
    private final String instanceDataFilePath;
    private final TbAssetService assetService;
    private final TbDeviceService deviceService;
    private final UserManagementService userManagementService;
    private final ExecutorService triggerCheckScheduler;
    private final ConcurrentMap<UUID, SubscriptionState> tenantIdSubscriptionStateMap = new ConcurrentHashMap();
    private TbLicenseClient tbLicenseClient;
    private final Deployment deployment;

    @Autowired
    public SelfHostedSubscriptionServiceV1(@Value(value="${license.secret}") String licenseSecret, @Value(value="${license.instance_data_file:trndz-instance-license.data}") String instanceDataFilePath, TbAssetService assetService, TbDeviceService deviceService, UserManagementService userManagementService, Deployment deployment) {
        this.licenseSecret = licenseSecret;
        this.instanceDataFilePath = instanceDataFilePath;
        this.assetService = assetService;
        this.deviceService = deviceService;
        this.userManagementService = userManagementService;
        this.deployment = deployment;
        this.triggerCheckScheduler = Executors.newSingleThreadExecutor();
    }

    @PostConstruct
    public void init() {
        if (this.deployment.isCloud()) {
            return;
        }
        List<String> unselectOptions = List.of("PUT_YOUR_LICENSE_SECRET_HERE", "YOUR_LICENSE_SECRET_HERE", "PUT_LICENSE_HERE");
        if (StringUtils.isBlank((CharSequence)this.licenseSecret) || unselectOptions.contains(this.licenseSecret)) {
            this.tbLicenseClient = null;
            log.info("Subscription check service V1 is disabled.");
            return;
        }
        try {
            String property = System.getProperty("tb.license.server", "https://license.thingsboard.io");
            this.tbLicenseClient = TbLicenseClient.builder().licenseServerEndpoint(property).listener((TbLicenseClientListener)this).licenseSecret(this.licenseSecret).licenseDataFilePath(this.instanceDataFilePath).releaseDate(new SimpleDateFormat("yyyy-MM-dd").parse("2026-01-21").getTime()).build();
            this.tbLicenseClient.init();
        }
        catch (Exception e) {
            LicenseErrorCode licenseErrorCode = e instanceof LicenseException ? ((LicenseException)e).getErrorCode() : LicenseErrorCode.GENERAL_ERROR;
            String errorMessage = String.format("Failed to init license client (code = %s): %s", licenseErrorCode, e.getMessage());
            log.error(errorMessage, (Throwable)e);
            this.tbLicenseClient = null;
        }
    }

    @PreDestroy
    public void stop() {
        if (this.tbLicenseClient != null) {
            this.tbLicenseClient.stop();
        }
        this.triggerCheckScheduler.shutdownNow();
    }

    public SubscriptionState getSubscriptionState(JwtSecurityUser user) {
        SubscriptionState state = (SubscriptionState)this.tenantIdSubscriptionStateMap.get(user.getTenantId());
        if (state == null || !state.isValid() || System.currentTimeMillis() - state.getCheckTs() > CHECK_INTERVAL) {
            this.triggerCheckScheduler.submit(() -> {
                SubscriptionState currentState = (SubscriptionState)this.tenantIdSubscriptionStateMap.get(user.getTenantId());
                if (currentState == null || !currentState.isValid() || System.currentTimeMillis() - currentState.getCheckTs() > CHECK_INTERVAL) {
                    try {
                        log.debug("Validate subscription. Current state {}", (Object)currentState);
                        if (this.tbLicenseClient != null) {
                            SubscriptionState newState = this.checkSubscription(user);
                            this.tenantIdSubscriptionStateMap.put(user.getTenantId(), newState);
                            log.info("Subscription validated {}", (Object)newState);
                        } else {
                            this.tenantIdSubscriptionStateMap.put(user.getTenantId(), this.makeInvalidSubscriptionState("License client is not initialized"));
                            log.error("License client is not initialized");
                        }
                    }
                    catch (RuntimeException re) {
                        this.tenantIdSubscriptionStateMap.put(user.getTenantId(), this.makeInvalidSubscriptionState("Could not validate subscription"));
                        log.error("Could not validate subscription", (Throwable)re);
                    }
                }
            });
        }
        return state == null ? SubscriptionState.builder().valid(true).build() : state;
    }

    public void onError(LicenseException e) {
        String errorMessage = String.format("License Error occurred: %s(%s) - %s", e.getErrorCode(), e.getErrorCode().getErrorCode(), e.getMessage());
        log.error(errorMessage, (Throwable)e);
        if (e.isCritical()) {
            this.tenantIdSubscriptionStateMap.clear();
        }
    }

    private SubscriptionState checkSubscription(JwtSecurityUser user) {
        Page usersPage;
        UUID tenantId = user.getTenantId();
        int page = 0;
        int pageSize = 10;
        do {
            usersPage = this.userManagementService.findAllTenantUserByTenantId(tenantId, page, pageSize);
            for (JwtSecurityUser tenantUser : usersPage.getContent()) {
                try {
                    return this.checkSubscriptionByTenantUser(tenantUser);
                }
                catch (Exception e) {
                    log.error("Can not validate subscription by given user: {}", (Object)tenantUser, (Object)e);
                }
            }
            ++page;
        } while (usersPage.hasNext());
        throw new RuntimeException("Can not validate subscription by all users of tenant: " + String.valueOf(tenantId));
    }

    private SubscriptionState checkSubscriptionByTenantUser(JwtSecurityUser tenantUser) {
        long now = System.currentTimeMillis();
        long countAssets = this.countAssets(tenantUser);
        long countDevices = this.countDevices(tenantUser);
        long maxAssetsCount = this.tbLicenseClient.getPlanLongValue(MAX_ASSETS_KEY);
        long maxDevicesCount = this.tbLicenseClient.getPlanLongValue(MAX_DEVICES_KEY);
        SubscriptionPlanData planData = new SubscriptionPlanData(maxAssetsCount, maxDevicesCount);
        SubscriptionType subscriptionType = DiscoverySubscriptionUtils.getSubscriptionType((SubscriptionPlanData)planData).orElse(SubscriptionType.UNKNOWN);
        String name = "Self-hosted subscription: %s".formatted(subscriptionType.getValue());
        if (maxAssetsCount > 0L && maxAssetsCount < countAssets) {
            String msg = "Maximum allowed assets limit reached! Current %s but allowed %s".formatted(countAssets, maxAssetsCount);
            log.error(msg);
            return SubscriptionState.builder().valid(false).whiteLabelingEnabled(this.isWhitelabelingEnabled(subscriptionType)).checkTs(now).actualAssets(countAssets).actualDevices(countDevices).allowedAssets(maxAssetsCount).allowedDevices(maxDevicesCount).type(subscriptionType).name(name).errorMsg(msg).errorType(SubscriptionErrorType.LICENSE_ERROR).version(SubscriptionVersion.V1).build();
        }
        if (maxDevicesCount > 0L && maxDevicesCount < countDevices) {
            String msg = "Maximum allowed devices limit reached! Current %s but allowed %s".formatted(countDevices, maxDevicesCount);
            log.error(msg);
            return SubscriptionState.builder().valid(false).whiteLabelingEnabled(this.isWhitelabelingEnabled(subscriptionType)).checkTs(now).actualAssets(countAssets).actualDevices(countDevices).allowedAssets(maxAssetsCount).allowedDevices(maxDevicesCount).type(subscriptionType).name(name).errorMsg(msg).errorType(SubscriptionErrorType.LICENSE_ERROR).version(SubscriptionVersion.V1).build();
        }
        return SubscriptionState.builder().valid(true).whiteLabelingEnabled(this.isWhitelabelingEnabled(subscriptionType)).checkTs(now).actualAssets(countAssets).actualDevices(countDevices).allowedAssets(maxAssetsCount).allowedDevices(maxDevicesCount).type(subscriptionType).name(name).errorMsg(null).version(SubscriptionVersion.V1).build();
    }

    private long countDevices(JwtSecurityUser user) {
        long count = 0L;
        List deviceTypes = (List)DonReactive.block((Mono)this.deviceService.loadDeviceTypes(user).collectList());
        for (String deviceType : deviceTypes) {
            count += ((Long)DonReactive.block((Mono)this.deviceService.loadDeviceByType(deviceType, user).count())).longValue();
        }
        return count;
    }

    private long countAssets(JwtSecurityUser user) {
        long count = 0L;
        List assetTypes = (List)DonReactive.block((Mono)this.assetService.loadAssetTypes(user).collectList());
        for (String assetType : assetTypes) {
            count += ((Long)DonReactive.block((Mono)this.assetService.loadAssetByType(assetType, user).count())).longValue();
        }
        return count;
    }

    private SubscriptionState makeInvalidSubscriptionState(String errorMessage) {
        long now = System.currentTimeMillis();
        return SubscriptionState.builder().valid(false).whiteLabelingEnabled(false).checkTs(now).errorMsg(errorMessage).errorType(SubscriptionErrorType.LICENSE_ERROR).version(SubscriptionVersion.V1).build();
    }

    private boolean isWhitelabelingEnabled(SubscriptionType subscriptionType) {
        return subscriptionType != null && Set.of(SubscriptionType.UNKNOWN, SubscriptionType.MAKER).contains(subscriptionType);
    }
}

