/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.subscription;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.subscription.CompositeSubscriptionService;
import org.thingsboard.trendz.subscription.SubscriptionState;
import org.thingsboard.trendz.subscription.SubscriptionType;
import org.thingsboard.trendz.subscription.TrendzLicenceInfo;

@Service
public class LicenceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenceService.class);
    private final CompositeSubscriptionService compositeSubscriptionService;

    @Autowired
    public LicenceService(CompositeSubscriptionService compositeSubscriptionService) {
        this.compositeSubscriptionService = compositeSubscriptionService;
    }

    public TrendzLicenceInfo provideLicenceInfo(JwtSecurityUser user) {
        SubscriptionState subscriptionState = this.compositeSubscriptionService.getSubscriptionState(user);
        return TrendzLicenceInfo.builder().isValid(subscriptionState.isValid()).subscriptionVersion(subscriptionState.getVersion()).subscriptionErrorType(subscriptionState.getErrorType()).subscriptionType(subscriptionState.getName()).errorStr(subscriptionState.getErrorMsg()).subscriptionStartTimestamp(subscriptionState.getStartTs()).subscriptionEndTimestamp(subscriptionState.getEndTs()).build();
    }

    public SubscriptionType getSubscriptionType(JwtSecurityUser user) {
        return this.compositeSubscriptionService.getSubscriptionState(user).getType();
    }

    public boolean isWhitelabelingEnabled(JwtSecurityUser user) {
        return this.compositeSubscriptionService.getSubscriptionState(user).isWhiteLabelingEnabled();
    }

    public boolean isDeprecated(JwtSecurityUser user) {
        return this.compositeSubscriptionService.getSubscriptionState(user).isDeprecated();
    }
}

