/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.subscription;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.system.Deployment;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.provider.version.TbVersion;
import org.thingsboard.trendz.service.provider.version.TbVersionChecker;
import org.thingsboard.trendz.service.provider.version.TbVersionNumber;
import org.thingsboard.trendz.subscription.CloudSubscriptionService;
import org.thingsboard.trendz.subscription.SelfHostedSubscriptionServiceV1;
import org.thingsboard.trendz.subscription.SelfHostedSubscriptionServiceV2;
import org.thingsboard.trendz.subscription.SubscriptionService;
import org.thingsboard.trendz.subscription.SubscriptionState;

@Component
@Profile(value={"!install"})
public class CompositeSubscriptionService
implements SubscriptionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompositeSubscriptionService.class);
    private final SelfHostedSubscriptionServiceV1 selfHostedSubscriptionServiceV1;
    private final SelfHostedSubscriptionServiceV2 selfHostedSubscriptionServiceV2;
    private final CloudSubscriptionService cloudSubscriptionService;
    private final TbVersionChecker tbVersionChecker;
    private final Deployment deployment;

    @Autowired
    public CompositeSubscriptionService(SelfHostedSubscriptionServiceV1 selfHostedSubscriptionServiceV1, SelfHostedSubscriptionServiceV2 selfHostedSubscriptionServiceV2, CloudSubscriptionService cloudSubscriptionService, TbVersionChecker tbVersionChecker, Deployment deployment) {
        this.selfHostedSubscriptionServiceV1 = selfHostedSubscriptionServiceV1;
        this.selfHostedSubscriptionServiceV2 = selfHostedSubscriptionServiceV2;
        this.cloudSubscriptionService = cloudSubscriptionService;
        this.tbVersionChecker = tbVersionChecker;
        this.deployment = deployment;
    }

    public SubscriptionState getSubscriptionState(JwtSecurityUser user) {
        log.debug("Receiving a subscription state for tenant: {}", (Object)user.getTenantId());
        SubscriptionService service = this.getCurrentService(user);
        SubscriptionState state = service.getSubscriptionState(user);
        log.debug("Received subscription state for tenant: {}, valid = {}", (Object)user.getTenantId(), (Object)state.isValid());
        return state;
    }

    private SubscriptionService getCurrentService(JwtSecurityUser user) {
        if (this.deployment.isCloud()) {
            log.debug("Selected subscription service: CLOUD, tenant: {}", (Object)user.getTenantId());
            return this.cloudSubscriptionService;
        }
        TbVersion tbVersion = this.tbVersionChecker.getVersion(user);
        if (tbVersion.getVersion().less(TbVersionNumber.V_4_3_0)) {
            log.debug("Selected subscription service: V1, tenant: {}", (Object)user.getTenantId());
            return this.selfHostedSubscriptionServiceV1;
        }
        log.debug("Selected subscription service: V2, tenant: {}", (Object)user.getTenantId());
        return this.selfHostedSubscriptionServiceV2;
    }
}

