/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.service.view.proto.StreamTelemetryStoreKey;

public class StreamTelemetryStoreKey {
    private final UUID itemId;
    private final FieldAggregation aggregation;
    private final long startTs;
    private final long endTs;

    @JsonIgnore
    public String getKey() {
        return String.valueOf(this.itemId) + "_" + this.aggregation.name();
    }

    @JsonIgnore
    public TimeRange getTimerange() {
        return new TimeRange(this.startTs, this.endTs);
    }

    @Generated
    public static StreamTelemetryStoreKeyBuilder builder() {
        return new StreamTelemetryStoreKeyBuilder();
    }

    @Generated
    public UUID getItemId() {
        return this.itemId;
    }

    @Generated
    public FieldAggregation getAggregation() {
        return this.aggregation;
    }

    @Generated
    public long getStartTs() {
        return this.startTs;
    }

    @Generated
    public long getEndTs() {
        return this.endTs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamTelemetryStoreKey)) {
            return false;
        }
        StreamTelemetryStoreKey other = (StreamTelemetryStoreKey)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        UUID this$itemId = this.getItemId();
        UUID other$itemId = other.getItemId();
        if (this$itemId == null ? other$itemId != null : !((Object)this$itemId).equals(other$itemId)) {
            return false;
        }
        FieldAggregation this$aggregation = this.getAggregation();
        FieldAggregation other$aggregation = other.getAggregation();
        return !(this$aggregation == null ? other$aggregation != null : !this$aggregation.equals(other$aggregation));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StreamTelemetryStoreKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        UUID $itemId = this.getItemId();
        result = result * 59 + ($itemId == null ? 43 : ((Object)$itemId).hashCode());
        FieldAggregation $aggregation = this.getAggregation();
        result = result * 59 + ($aggregation == null ? 43 : $aggregation.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StreamTelemetryStoreKey(itemId=" + String.valueOf(this.getItemId()) + ", aggregation=" + String.valueOf(this.getAggregation()) + ", startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ")";
    }

    @Generated
    public StreamTelemetryStoreKey(UUID itemId, FieldAggregation aggregation, long startTs, long endTs) {
        this.itemId = itemId;
        this.aggregation = aggregation;
        this.startTs = startTs;
        this.endTs = endTs;
    }
}

