/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.view.proto.StreamTelemetryStoreKey;

public class StreamTelemetryStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamTelemetryStore.class);
    private final Map<UUID, Set<UUID>> itemsByBusinessEntity = new ConcurrentHashMap();
    private final Map<String, List<FieldValue>> valuesByItem = new ConcurrentHashMap();
    private final Map<String, CountDownLatch> loadingLocks = new ConcurrentHashMap();

    public void add(BusinessEntity be, StreamTelemetryStoreKey key, FieldValue fValue) {
        Set items = this.itemsByBusinessEntity.computeIfAbsent(be.getId(), id -> new HashSet());
        items.add(key.getItemId());
        List itemValues = this.valuesByItem.computeIfAbsent(key.getKey(), id -> new ArrayList());
        itemValues.add(fValue);
    }

    public List<FieldValue> get(StreamTelemetryStoreKey key) {
        List fieldValues = (List)this.valuesByItem.get(key.getKey());
        if (fieldValues == null) {
            return null;
        }
        List<FieldValue> filteredValues = ((List)this.valuesByItem.get(key.getKey())).stream().filter(fieldValue -> key.getTimerange().contains(fieldValue.getTs())).collect(Collectors.toList());
        return filteredValues;
    }

    public synchronized Optional<CountDownLatch> getLoadLock(Item item, FieldAggregation aggregation) {
        String key = String.valueOf(item.getId()) + "_" + aggregation.name();
        return Optional.ofNullable(this.loadingLocks.putIfAbsent(key, new CountDownLatch(1)));
    }
}

