/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.cache.CachedTelemetry;
import org.thingsboard.trendz.domain.cache.CachedTelemetryPoint;
import org.thingsboard.trendz.domain.cache.LoadedCachingData;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.manual.ManualDataset;
import org.thingsboard.trendz.domain.measurement.Measurable;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.service.alarm.alarmfield.AlarmFieldProcessor;
import org.thingsboard.trendz.service.cache.CachedTelemetryService;
import org.thingsboard.trendz.service.cache.PreloadedCache;
import org.thingsboard.trendz.service.model.anomaly.anomalyfield.AnomalyFieldProcessor;
import org.thingsboard.trendz.service.predict.PredictionService;
import org.thingsboard.trendz.service.provider.TbFieldValueService;
import org.thingsboard.trendz.service.script.calculatedfield.BatchFieldScriptProcessor;
import org.thingsboard.trendz.service.script.calculatedfield.FieldDto;
import org.thingsboard.trendz.service.script.calculatedfield.NativeFieldScriptProcessor;
import org.thingsboard.trendz.service.script.state.StateFieldProcessor;
import org.thingsboard.trendz.service.sql.SqlValueLoader;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.AggregatedValue;
import org.thingsboard.trendz.service.view.proto.AggregationServiceImpl;
import org.thingsboard.trendz.service.view.proto.FillGapService;
import org.thingsboard.trendz.service.view.proto.FilterService;
import org.thingsboard.trendz.service.view.proto.ItemDataLoader;
import org.thingsboard.trendz.service.view.proto.Row;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.service.view.proto.WindowedStreamStore;
import org.thingsboard.trendz.tools.DateTimeUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class ItemDataLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ItemDataLoader.class);
    private final TbFieldValueService tbFieldValueService;
    private final StateFieldProcessor stateFieldProcessor;
    private final BatchFieldScriptProcessor batchFieldScriptProcessor;
    private final NativeFieldScriptProcessor nativeFieldScriptProcessor;
    private final AnomalyFieldProcessor anomalyFieldProcessor;
    private final AlarmFieldProcessor alarmFieldProcessor;
    private final SqlValueLoader sqlValueLoader;
    private final AggregationServiceImpl aggregationService;
    private final CachedTelemetryService cachedTelemetryService;
    private final PredictionService predictionService;
    private final FillGapService fillGapService;
    private final FilterService filterService;

    @Autowired
    public ItemDataLoader(TbFieldValueService tbFieldValueService, StateFieldProcessor stateFieldProcessor, BatchFieldScriptProcessor batchFieldScriptProcessor, NativeFieldScriptProcessor nativeFieldScriptProcessor, AnomalyFieldProcessor anomalyFieldProcessor, AlarmFieldProcessor alarmFieldProcessor, SqlValueLoader sqlValueLoader, AggregationServiceImpl aggregationService, CachedTelemetryService cachedTelemetryService, PredictionService predictionService, FillGapService fillGapService, FilterService filterService) {
        this.nativeFieldScriptProcessor = nativeFieldScriptProcessor;
        this.aggregationService = aggregationService;
        this.cachedTelemetryService = cachedTelemetryService;
        this.tbFieldValueService = tbFieldValueService;
        this.stateFieldProcessor = stateFieldProcessor;
        this.batchFieldScriptProcessor = batchFieldScriptProcessor;
        this.anomalyFieldProcessor = anomalyFieldProcessor;
        this.alarmFieldProcessor = alarmFieldProcessor;
        this.sqlValueLoader = sqlValueLoader;
        this.predictionService = predictionService;
        this.fillGapService = fillGapService;
        this.filterService = filterService;
    }

    @Measurable(context="#ctx", type=MeasuredTaskType.LOAD_DATA_BUNDLE, viewFieldName="#parentField.label", viewFieldAggregation="#parentField.aggregationType", itemName="#item.name")
    public Mono<Map<String, List<FieldValue>>> loadChildrenData(ViewField parentField, Map<String, ViewField> paramFields, Item item, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, ViewContext ctx, boolean loadLatest) {
        ArrayList<Flux> fluxList = new ArrayList<Flux>();
        for (Map.Entry<String, ViewField> entry : paramFields.entrySet()) {
            Flux conditionFieldValues;
            boolean isInnerLoadField;
            String paramName = entry.getKey();
            ViewField viewField = new ViewField(entry.getValue());
            if (loadLatest) {
                viewField.setAggregationType(FieldAggregation.LATEST);
            }
            BusinessEntity businessEntity = (BusinessEntity)ctx.getBusinessEntityMap().get(viewField.getBusinessEntityId());
            BusinessEntityField businessEntityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(viewField.getEntityFieldId());
            boolean bl = isInnerLoadField = viewField.isForStateCondition() && businessEntityField.hasTime();
            if (isInnerLoadField) {
                conditionFieldValues = this.loadData(item, viewField, viewRequest, windowedStreamStore, businessEntityField, businessEntity, ctx, -1L).collectList().flatMap(fieldValues -> this.processPrediction(fieldValues, item, viewField, viewRequest, windowedStreamStore, ctx)).doOnNext(fieldValues -> {
                    if (viewField.isCollectDebugDataSample()) {
                        String pattern = viewField.getStateConditionPattern();
                        List values = fieldValues.stream().filter(fieldValue -> fieldValue.getFieldType() != FieldType.BLANK).map(fieldValue -> new FieldDto(fieldValue.getTs(), fieldValue.getInnerValue())).collect(Collectors.toList());
                        if (values.size() > 100) {
                            values = values.subList(0, 100);
                        }
                        viewField.getDebugDataSample().put(pattern, values);
                    }
                }).flatMapMany(Flux::fromIterable).map(value -> Pair.of((Object)paramName, (Object)value));
            } else {
                FieldValue value2 = this.getValueFromStore(windowedStreamStore, viewField, item, ctx);
                conditionFieldValues = Flux.just((Object)Pair.of((Object)paramName, (Object)value2));
            }
            fluxList.add(conditionFieldValues);
        }
        return Flux.merge(fluxList).collectList().map(allFieldValues -> {
            Map nameToValuesMap = allFieldValues.stream().collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toList())));
            nameToValuesMap.forEach((name, fieldValues) -> {
                boolean blank;
                boolean bl = blank = fieldValues.size() == 1 && ((FieldValue)fieldValues.get(0)).getFieldType() == FieldType.BLANK;
                if (blank) {
                    fieldValues.clear();
                }
                fieldValues.sort(Comparator.comparingLong(FieldValue::getTs));
            });
            return nameToValuesMap;
        });
    }

    @Measurable(context="#ctx", type=MeasuredTaskType.ITEM_LOAD_DATA, viewFieldName="#viewField.label", viewFieldAggregation="#viewField.aggregationType", itemName="#item.name")
    public Flux<FieldValue> loadData(Item item, ViewField viewField, ViewRequest request, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx, long methodId) {
        log.trace("Loading data for: item [{}] [{}], viewField ({})", new Object[]{item.getName(), item.getId(), viewField.getLabel()});
        return Mono.just((Object)new Object()).flatMapMany(o -> {
            if (request.isUsePersistedCacheTelemetry() && CachedTelemetryService.isPossibleToUseTelemetryCache((ViewRequest)request, (ViewField)viewField, (BusinessEntityField)entityField)) {
                return this.loadDataFromCache(item, viewField, request, windowedStreamStore, entityField, businessEntity, ctx, methodId);
            }
            return this.loadDataFromTb(item, viewField, request, windowedStreamStore, entityField, businessEntity, ctx, methodId);
        }).collectList().map(fieldValues -> this.handleFillGapSettings(fieldValues, request, viewField, entityField)).map(fieldValues -> this.handlePredictionFieldsSettings(fieldValues, request, viewField, ctx, item)).flatMapIterable(l -> l);
    }

    private Flux<FieldValue> loadDataFromTb(Item item, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx, long methodId) {
        log.trace("ItemDataLoader: Loading data source = thingsboard");
        return Flux.just((Object)new Object()).flatMap(o -> {
            if (this.isStateField(viewField)) {
                return this.processStateField(item, viewField, viewRequest, windowedStreamStore, ctx);
            }
            if (this.isBatchCalculatedField(viewField)) {
                return this.processBatchCalculatedField(item, viewField, viewRequest, windowedStreamStore, ctx);
            }
            if (this.isNativeCalculationField(viewField)) {
                return this.nativeFieldScriptProcessor.processNativeCalculatedField(item, businessEntity.getQuery().getEntityType(), viewField, viewRequest, ctx);
            }
            if (this.isAnomalyField(viewField)) {
                return this.anomalyFieldProcessor.processField(item, viewField, viewRequest, ctx);
            }
            if (this.isAlarmField(viewField)) {
                return this.alarmFieldProcessor.processField(item, viewField, viewRequest, windowedStreamStore, ctx);
            }
            if (viewRequest.isUsingManualDatasetAsChild(viewField)) {
                return this.loadFromManualDataset(item, viewField, viewRequest);
            }
            return Mono.just((Object)new Object()).flatMapMany(o1 -> {
                if (BusinessEntityType.EXTERNAL.equals((Object)businessEntity.getQuery().getEntityType())) {
                    return this.sqlValueLoader.loadSqlValues(item, viewField, ctx, windowedStreamStore);
                }
                return this.loadPrimaryData(item, viewField, viewRequest, windowedStreamStore, entityField, businessEntity, ctx);
            }).filter(fv -> {
                if (entityField.hasTime()) {
                    return this.getDateFieldAndFilterPairs(viewRequest).stream().allMatch(pair -> this.filterService.processTelemetryThroughDateFilter(ctx, (ViewField)pair.getLeft(), (RuntimeFilterField)pair.getRight(), fv.getTs(), viewRequest.getZoneId()));
                }
                return true;
            }).collectList().doOnNext(fieldValues -> {
                if (viewField.isCollectDebugDataSample()) {
                    String pattern = viewField.getStateConditionPattern();
                    List values = fieldValues.stream().filter(fieldValue -> fieldValue.getFieldType() != FieldType.BLANK).map(fieldValue -> new FieldDto(fieldValue.getTs(), fieldValue.getInnerValue())).collect(Collectors.toList());
                    if (values.size() > 100) {
                        values = values.subList(0, 100);
                    }
                    viewField.getDebugDataSample().put(pattern, values);
                }
            }).flatMapIterable(Function.identity());
        });
    }

    private boolean isStateField(ViewField viewField) {
        return viewField.isStateField();
    }

    private boolean isBatchCalculatedField(ViewField viewField) {
        return viewField.isCalculatedField() && viewField.isBatchCalculation();
    }

    private boolean isNativeCalculationField(ViewField viewField) {
        return viewField.isCalculatedField() && viewField.isNativeCalculation();
    }

    private boolean isAnomalyField(ViewField viewField) {
        return viewField.isAnomalyField() && viewField.getEntityFieldId() == null;
    }

    private boolean isAlarmField(ViewField viewField) {
        return viewField.isAlarmField();
    }

    private Flux<FieldValue> processStateField(Item item, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, ViewContext ctx) {
        this.checkConditionalFieldForExternalEntities(viewField, ctx);
        return this.stateFieldProcessor.processFieldStates(ctx.getUser(), item, viewField, viewRequest, this.loadChildrenData(viewField, viewField.getConditionFieldIds(), item, viewRequest, windowedStreamStore, ctx, false));
    }

    private void checkConditionalFieldForExternalEntities(ViewField viewField, ViewContext ctx) {
        List<String> externalFieldsLabel = viewField.getConditionFieldIds().values().stream().filter(vf -> {
            BusinessEntity businessEntity = (BusinessEntity)ctx.getBusinessEntityMap().get(vf.getBusinessEntityId());
            BusinessEntityType entityType = businessEntity.getQuery().getEntityType();
            return entityType.equals((Object)BusinessEntityType.EXTERNAL);
        }).map(ViewField::getLabel).toList();
        if (!externalFieldsLabel.isEmpty()) {
            throw new TrendzException("The system does not support batched calculation fields with external entities (yet): " + Arrays.toString(externalFieldsLabel.toArray()));
        }
    }

    private Flux<FieldValue> processBatchCalculatedField(Item item, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, ViewContext ctx) {
        this.checkConditionalFieldForExternalEntities(viewField, ctx);
        return this.batchFieldScriptProcessor.processBatchedCalculatedField(item, viewField, viewRequest, ctx, this.loadChildrenData(viewField, viewField.getConditionFieldIds(), item, viewRequest, windowedStreamStore, ctx, false));
    }

    private Flux<FieldValue> loadFromManualDataset(Item item, ViewField viewField, ViewRequest viewRequest) {
        ManualDataset dataset = viewRequest.getManualDataset(viewField);
        String key = viewField.getStateConditionPattern();
        List data = dataset.getData().getOrDefault(key, Collections.emptyList());
        return Flux.fromIterable(data).map(point -> new FieldValue(item, FieldType.NUMERIC, point.getValue(), point.getTs()));
    }

    private Flux<FieldValue> loadPrimaryData(Item item, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx) {
        FieldQueryType queryType = entityField.getQuery().getQueryType();
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldQueryType[queryType.ordinal()]) {
            case 1 -> this.valueOrAggregate(item, viewField, (Object)item.getId(), viewRequest.getNowTs());
            case 2 -> this.valueOrAggregate(item, viewField, (Object)item.getName(), viewRequest.getNowTs());
            case 3 -> this.valueOrAggregate(item, viewField, (Object)item.getLabel(), viewRequest.getNowTs());
            case 4 -> this.valueOrAggregate(item, viewField, (Object)item.getOwnerId(), viewRequest.getNowTs());
            case 5 -> this.tbFieldValueService.loadAttribute(ctx, item, viewField, entityField, businessEntity, ctx.getUser(), viewRequest.getNowTs());
            case 6, 7, 8, 9, 10 -> this.tbFieldValueService.loadTelemetry(item, viewField, viewRequest, entityField, businessEntity, windowedStreamStore, ctx);
            default -> throw new TrendzInternalException("Unsupported entity Field type: " + String.valueOf(queryType));
        };
    }

    private Flux<FieldValue> valueOrAggregate(Item item, ViewField viewField, Object val, long nowTs) {
        if (viewField.getAggregationType() == FieldAggregation.COUNT) {
            return Flux.just((Object)new FieldValue(item, FieldType.NUMERIC, (Object)1, nowTs));
        }
        return Flux.just((Object)new FieldValue(item, FieldType.STRING, val, nowTs));
    }

    private Flux<FieldValue> loadDataFromCache(Item item, ViewField viewField, ViewRequest request, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx, long methodId) {
        long requestStartTs = request.getStartTs(viewField);
        long requestEndTs = request.getEndTs(viewField);
        return this.loadCompatibleCaches(item.getId(), requestStartTs, requestEndTs, request.getZoneId(), viewField, request.getCachingDateAggregationType(), ctx).flatMap(cachedTelemetries -> this.validateCachesWithLatestData(ctx, requestStartTs, requestEndTs, viewField, item, cachedTelemetries)).flatMap(cachedTelemetries -> {
            if (cachedTelemetries.isEmpty()) {
                return this.loadDataWithoutCache(item, viewField, request, windowedStreamStore, entityField, businessEntity, ctx, methodId);
            }
            return this.loadDataWithCache(cachedTelemetries, item, viewField, request, windowedStreamStore, entityField, businessEntity, ctx, methodId);
        }).flatMapIterable(Function.identity());
    }

    private Mono<List<CachedTelemetry>> loadCompatibleCaches(UUID itemId, long startTs, long endTs, ZoneId zoneId, ViewField viewField, DateAggregationType cachingDateAggregation, ViewContext ctx) {
        PreloadedCache preloadedCache = ctx.getPreloadedCache();
        if (preloadedCache.containsCache(viewField, itemId)) {
            ArrayList cache = Lists.newArrayList((Iterable)preloadedCache.getCache(viewField, itemId));
            return Mono.just((Object)cache);
        }
        this.cachedTelemetryService.validateNeededTimeRangeOfCache(startTs, endTs, zoneId, cachingDateAggregation);
        return this.cachedTelemetryService.loadAllCompatibleCachedTelemetry((Set)Sets.newHashSet((Object[])new UUID[]{itemId}), startTs, endTs, viewField, cachingDateAggregation);
    }

    private Mono<List<CachedTelemetry>> validateCachesWithLatestData(ViewContext ctx, long requestStartTs, long requestEndTs, ViewField viewField, Item item, List<CachedTelemetry> cachedTelemetries) {
        long latestCachedTelemetryPointTs;
        log.debug("Telemetry cache validation: started, request range: {} - {}.", (Object)DateTimeUtils.fromTs((long)requestStartTs), (Object)DateTimeUtils.fromTs((long)requestEndTs));
        if (cachedTelemetries.isEmpty()) {
            log.debug("Telemetry cache validation [{}({}) - {} ({})]: no cache was found, skipping.", new Object[]{viewField.getAggregationType(), viewField.getLabel(), item.getName(), item.getLabel()});
            return Mono.just(cachedTelemetries);
        }
        long latestTelemetryTs = this.cachedTelemetryService.getRealLatestTelemetryFromItem(ctx, viewField, item).orElse(0L);
        if (latestTelemetryTs == (latestCachedTelemetryPointTs = cachedTelemetries.stream().mapToLong(CachedTelemetry::getLatestTelemetryPoint).max().orElseThrow())) {
            log.debug("Telemetry cache validation [{}({}) - {} ({})]: latest values are equal, return same.", new Object[]{viewField.getAggregationType(), viewField.getLabel(), item.getName(), item.getLabel()});
            return Mono.just(cachedTelemetries);
        }
        if (latestTelemetryTs < requestStartTs) {
            log.warn("Telemetry cache validation [{}({}) - {} ({})]: BAD CASE - the latest TB value earlier that request, latest value from cache = {}, latest value from TB = {}, return same.", new Object[]{viewField.getAggregationType(), viewField.getLabel(), item.getName(), item.getLabel(), DateTimeUtils.fromTs((long)latestCachedTelemetryPointTs), DateTimeUtils.fromTs((long)latestTelemetryTs)});
            return Mono.just(cachedTelemetries);
        }
        if (latestTelemetryTs < latestCachedTelemetryPointTs) {
            log.warn("Telemetry cache validation [{}({}) - {} ({})]: BAD CASE - inconsistent data: latest value from cache = {}, latest value from TB = {}, remove all cache", new Object[]{viewField.getAggregationType(), viewField.getLabel(), item.getName(), item.getLabel(), DateTimeUtils.fromTs((long)latestCachedTelemetryPointTs), DateTimeUtils.fromTs((long)latestTelemetryTs)});
            return Mono.just((Object)new Object()).flatMap(o -> this.cachedTelemetryService.removeTelemetries(cachedTelemetries)).map(o -> new ArrayList());
        }
        if (requestEndTs < latestCachedTelemetryPointTs) {
            log.debug("Telemetry cache validation [{}({}) - {} ({})]: latest value after end request, skipping.", new Object[]{viewField.getAggregationType(), viewField.getLabel(), item.getName(), item.getLabel()});
            return Mono.just(cachedTelemetries);
        }
        List toRemove = cachedTelemetries.stream().filter(cachedTelemetry -> cachedTelemetry.after(latestCachedTelemetryPointTs)).collect(Collectors.toList());
        log.debug("Telemetry cache validation: headers to remove: {}", toRemove);
        Optional<CachedTelemetry> toOverwriteOpt = cachedTelemetries.stream().filter(cachedTelemetry -> cachedTelemetry.getLatestTelemetryPoint() != 0L).filter(cachedTelemetry -> cachedTelemetry.before(latestTelemetryTs) || cachedTelemetry.contains(latestTelemetryTs)).max(Comparator.comparingLong(CachedTelemetry::getLatestTelemetryPoint));
        if (toOverwriteOpt.isEmpty()) {
            log.debug("Telemetry cache validation: no header to overwrite.");
            cachedTelemetries.removeAll(toRemove);
            return Mono.just((Object)new Object()).flatMap(o -> this.cachedTelemetryService.removeTelemetries(toRemove)).map(o -> {
                log.info("Telemetry cache validation 1 [{}({}) - {} ({})]: finished, returned caches: {}", new Object[]{viewField.getAggregationType(), viewField.getLabel(), item.getName(), item.getLabel(), cachedTelemetries});
                return cachedTelemetries;
            });
        }
        CachedTelemetry toOverwrite = toOverwriteOpt.get();
        log.debug("Telemetry cache validation: header to overwrite: {}, latest point TB = {}", (Object)toOverwrite, (Object)DateTimeUtils.fromTs((long)latestTelemetryTs));
        if (toOverwrite.getPoints().size() <= 1) {
            log.debug("Telemetry cache validation: header has only one point, remove: {}", toOverwrite.getPoints().iterator().next());
            toRemove.add(toOverwrite);
            cachedTelemetries.removeAll(toRemove);
            return Mono.just((Object)new Object()).flatMap(o -> this.cachedTelemetryService.removeTelemetries(toRemove)).map(o -> {
                log.info("Telemetry cache validation 2 [{}({}) - {} ({})]: finished, returned caches: {}", new Object[]{viewField.getAggregationType(), viewField.getLabel(), item.getName(), item.getLabel(), cachedTelemetries});
                return cachedTelemetries;
            });
        }
        CachedTelemetryPoint maxPoint = toOverwrite.getPoints().stream().max(Comparator.comparingLong(CachedTelemetryPoint::getTs)).orElseThrow();
        long lastPointTs = maxPoint.getTs() - 1L;
        toOverwrite.getPoints().remove(maxPoint);
        toOverwrite.setEndTs(lastPointTs);
        toOverwrite.setLatestTelemetryPoint(lastPointTs);
        log.debug("Telemetry cache validation: max point was removed {}, header to overwrite: {}", (Object)maxPoint, (Object)toOverwrite);
        cachedTelemetries.removeAll(toRemove);
        toRemove.add(toOverwrite);
        return Mono.just((Object)new Object()).flatMap(o -> this.cachedTelemetryService.removeTelemetries(toRemove)).flatMap(o -> this.cachedTelemetryService.persistTelemetry(toOverwrite)).map(o -> {
            log.info("Telemetry cache validation 3 [{}({}) - {} ({})]: finished, returned caches: {}", new Object[]{viewField.getAggregationType(), viewField.getLabel(), item.getName(), item.getLabel(), cachedTelemetries});
            return cachedTelemetries;
        });
    }

    private Mono<List<FieldValue>> loadDataWithoutCache(Item item, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx, long methodId) {
        log.debug("There is no compatible cached telemetries, loading data from TB...");
        ViewRequest modifiedRequest = new ViewRequest(viewRequest);
        modifiedRequest.setFillGap(false);
        List dateAggregationField = modifiedRequest.getCachingDateAggregationType().getCachingDateAggregationFieldList();
        return this.loadDataFromTb(item, viewField, modifiedRequest, windowedStreamStore, entityField, businessEntity, ctx, methodId).collectList().map(loadedData -> {
            List aggregated = this.aggregationService.preagregate(loadedData, viewField, modifiedRequest, modifiedRequest.getCachingDateAggregationType(), dateAggregationField, entityField, ctx);
            long latestTs = loadedData.stream().mapToLong(FieldValue::getTs).max().orElseThrow();
            return new LoadedCachingData(aggregated, latestTs);
        }).flatMap(loadedCachingData -> {
            CachedTelemetry cachedTelemetry = this.cachedTelemetryService.createNewCachedTelemetry(loadedCachingData, item.getId(), viewRequest.getStartTs(viewField), viewRequest.getEndTs(viewField), modifiedRequest.getCachingDateAggregationType(), viewField, ctx.getUser().getTenantId());
            return this.cachedTelemetryService.persistTelemetry(cachedTelemetry).doOnNext(arg_0 -> ((CachedTelemetry)cachedTelemetry).setId(arg_0)).doOnNext(uuid -> ctx.getPreloadedCache().addCache(viewField, item.getId(), cachedTelemetry)).map(uuid -> loadedCachingData.getData());
        });
    }

    private Mono<List<FieldValue>> loadDataWithCache(List<CachedTelemetry> cachedTelemetries, Item item, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx, long methodId) {
        long queriedStartTs = viewRequest.getStartTs(viewField);
        long queriedEndTs = viewRequest.getEndTs(viewField);
        this.cachedTelemetryService.verifyDuplicatedPoints(cachedTelemetries);
        CachedTelemetry resultCachedTelemetry = this.cachedTelemetryService.mergeCachedTelemetries(cachedTelemetries);
        List gapsTimeRangeList = this.cachedTelemetryService.findGapsBetweenCaches(cachedTelemetries, queriedStartTs, queriedEndTs);
        return Mono.just((Object)new Object()).flatMap(o -> this.loadDataForGaps(gapsTimeRangeList, item, viewField, viewRequest, windowedStreamStore, entityField, businessEntity, ctx, methodId)).map(loadedDataForGaps -> this.cachedTelemetryService.uniteMergedCacheAndGapData(resultCachedTelemetry, loadedDataForGaps)).flatMap(mergedCache -> {
            boolean areChangesNeeded;
            boolean bl = areChangesNeeded = cachedTelemetries.size() > 1 || !gapsTimeRangeList.isEmpty();
            if (areChangesNeeded) {
                mergedCache.setStartTs(Math.min(queriedStartTs, mergedCache.getStartTs()));
                mergedCache.setEndTs(Math.max(queriedEndTs, mergedCache.getEndTs()));
                return Mono.just((Object)new Object()).flatMap(o -> this.cachedTelemetryService.persistCashAndRemoveOthers(mergedCache, cachedTelemetries)).doOnNext(arg_0 -> ((CachedTelemetry)mergedCache).setId(arg_0)).map(uuid -> mergedCache);
            }
            mergedCache.setId(((CachedTelemetry)cachedTelemetries.iterator().next()).getId());
            return Mono.just((Object)mergedCache);
        }).doOnNext(mergedCache -> {
            ctx.getPreloadedCache().resetCache(viewField, item.getId());
            ctx.getPreloadedCache().addCache(viewField, item.getId(), mergedCache);
        }).map(CachedTelemetry::getPoints).map(allPoints -> this.cachedTelemetryService.mapToFieldValues(item, queriedStartTs, queriedEndTs, allPoints, resultCachedTelemetry.getFieldType()));
    }

    private Mono<List<LoadedCachingData>> loadDataForGaps(List<TimeRange> gapsTimeRangeList, Item item, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx, long methodId) {
        return Flux.fromIterable(gapsTimeRangeList).flatMap(timeRange -> this.loadDataByRequestAndGivenTimeRange(timeRange, item, viewField, viewRequest, windowedStreamStore, entityField, businessEntity, ctx, methodId)).collectList();
    }

    private Mono<LoadedCachingData> loadDataByRequestAndGivenTimeRange(TimeRange timeRange, Item item, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx, long methodId) {
        Item itemCopy = new Item(item);
        ViewRequest modifiedRequest = new ViewRequest(viewRequest);
        modifiedRequest.setStartTs(timeRange.getStartTs());
        modifiedRequest.setEndTs(timeRange.getEndTs());
        modifiedRequest.setFillGap(false);
        ViewField viewFieldCopy = modifiedRequest.getAllFields().stream().filter(vf -> vf.getId().equals(viewField.getId())).findAny().orElseThrow();
        List dateAggregationField = viewRequest.getCachingDateAggregationType().getCachingDateAggregationFieldList();
        return this.loadDataFromTb(itemCopy, viewFieldCopy, modifiedRequest, windowedStreamStore, entityField, businessEntity, ctx, methodId).collectList().map(loadedData -> {
            List aggregated = this.aggregationService.preagregate(loadedData, viewField, modifiedRequest, modifiedRequest.getCachingDateAggregationType(), dateAggregationField, entityField, ctx);
            long latestTs = loadedData.stream().mapToLong(FieldValue::getTs).max().orElseThrow();
            return new LoadedCachingData(aggregated, latestTs);
        }).map(loadedCachingData -> {
            FieldType fieldType = CachedTelemetryService.getFieldTypeOfData((List)loadedCachingData.getData());
            return fieldType == FieldType.BLANK ? new LoadedCachingData() : loadedCachingData;
        });
    }

    private FieldValue getValueFromStore(WindowedStreamStore windowedStreamStore, ViewField viewField, Item item, ViewContext ctx) {
        Row row = windowedStreamStore.getCurrentRow();
        Map hiddenValues = row.getHiddenValues();
        List rowFieldValues = (List)hiddenValues.get(viewField.getEntityFieldId());
        Map childItemIdToParentItemIdSetMap = ctx.getChildItemIdToParentItemIdSetMap();
        Set iteratedRootItemIdSet = Item.getRootParents(Set.of(item.getId()), (Map)childItemIdToParentItemIdSetMap);
        if (rowFieldValues != null) {
            for (AggregatedValue value : rowFieldValues) {
                Set valueItems = value.getFieldValue().getItems();
                Set rootItemIdSet = valueItems.stream().map(valueItem -> Item.getRootParents(Set.of(valueItem.getId()), (Map)childItemIdToParentItemIdSetMap)).flatMap(Collection::stream).collect(Collectors.toSet());
                Sets.SetView intersection = Sets.intersection((Set)iteratedRootItemIdSet, rootItemIdSet);
                if (intersection.isEmpty()) continue;
                return value.getFieldValue();
            }
        }
        throw new TrendzInternalException("Field was not processed yet: " + viewField.getLabel());
    }

    private Mono<List<FieldValue>> processPrediction(List<FieldValue> original, Item item, ViewField viewField, ViewRequest request, WindowedStreamStore windowedStreamStore, ViewContext ctx) {
        return Mono.just((Object)new Object()).flatMap(o -> {
            if (viewField.isPredictionEnabled() && !viewField.isBatchCalculation()) {
                List trimmedOriginal = original.stream().sorted(Comparator.comparingLong(FieldValue::getTs)).collect(Collectors.toList());
                return this.predictionService.enrichPrediction(viewField, trimmedOriginal, item, request, windowedStreamStore, ctx);
            }
            return Mono.just((Object)original);
        });
    }

    private List<FieldValue> handleFillGapSettings(List<FieldValue> fieldValues, ViewRequest request, ViewField viewField, BusinessEntityField entityField) {
        boolean isTelemetryField;
        if (fieldValues.isEmpty() || fieldValues.size() == 1 && fieldValues.get(0).getFieldType() == FieldType.BLANK) {
            return fieldValues;
        }
        boolean bl = isTelemetryField = viewField.getEntityFieldId() != null && entityField.hasTime();
        if (viewField.getFillGapSettings() != null && viewField.getFillGapSettings().isEnableFillGap() && (isTelemetryField || viewField.isStateField() || viewField.isCalculatedField() || viewField.isAnomalyField())) {
            return this.fillGapService.process(fieldValues, request.getStartTs(viewField), request.getEndTs(viewField), request.getZoneId(), viewField.getFillGapSettings());
        }
        return fieldValues;
    }

    private List<FieldValue> handlePredictionFieldsSettings(List<FieldValue> fieldValues, ViewRequest request, ViewField viewField, ViewContext ctx, Item item) {
        UUID id = viewField.getId();
        ZoneId zoneId = request.getZoneId();
        if (viewField.isPredictionModelField()) {
            boolean blank = fieldValues.stream().allMatch(fv -> fv.getFieldType() == FieldType.BLANK);
            if (blank) {
                return fieldValues;
            }
            Map predictionToHistoricalFieldMap = ctx.getPredictionToHistoricalFieldMap();
            UUID historicalFieldId = (UUID)predictionToHistoricalFieldMap.get(id);
            if (historicalFieldId == null) {
                return fieldValues;
            }
            long lastHistoricalTs = ((Map)ctx.getLastHistoricalTsPointMap().getOrDefault(historicalFieldId, new HashMap())).getOrDefault(item.getId(), 0L);
            return fieldValues.stream().filter(fv -> lastHistoricalTs <= fv.getTs()).toList();
        }
        Set historicalFieldSet = ctx.getHistoricalFieldSet();
        if (historicalFieldSet.contains(id)) {
            long lastHistoricalTs;
            if (request.getMinimalDateAggregation() != null) {
                long now = request.getNowTs();
                ChronoUnit timeUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)request.getMinimalDateAggregation());
                long truncatedNowTs = DateTimeUtils.extendedTruncateTo((long)now, (ZoneId)zoneId, (ChronoUnit)timeUnit);
                TimeRange currentUnitRange = new TimeRange(truncatedNowTs, now);
                List<FieldValue> points = fieldValues.stream().filter(fv -> currentUnitRange.contains(fv.getTs())).toList();
                Set currentUnitDataTs = points.stream().map(FieldValue::getTs).collect(Collectors.toSet());
                fieldValues.removeIf(fieldValue -> currentUnitRange.contains(fieldValue.getTs()));
                lastHistoricalTs = currentUnitDataTs.isEmpty() ? truncatedNowTs : (Long)Collections.min(currentUnitDataTs);
            } else {
                lastHistoricalTs = fieldValues.stream().mapToLong(FieldValue::getTs).max().orElse(0L);
            }
            ctx.getLastHistoricalTsPointMap().putIfAbsent(id, new HashMap());
            ((Map)ctx.getLastHistoricalTsPointMap().get(id)).put(item.getId(), lastHistoricalTs);
        }
        return fieldValues;
    }

    private Set<Pair<ViewField, RuntimeFilterField>> getDateFieldAndFilterPairs(ViewRequest viewRequest) {
        Map viewFieldMap = viewRequest.getAllFields().stream().filter(ViewField::isVirtualDateField).collect(Collectors.toMap(ViewField::getId, Function.identity()));
        Map filterMap = viewRequest.getRuntimeFilters().stream().filter(filter -> viewFieldMap.containsKey(filter.getViewFieldId())).collect(Collectors.toMap(RuntimeFilterField::getViewFieldId, Function.identity()));
        return filterMap.keySet().stream().map(id -> {
            ViewField viewField = (ViewField)viewFieldMap.get(id);
            RuntimeFilterField filterField = (RuntimeFilterField)filterMap.get(id);
            return Pair.of((Object)viewField, (Object)filterField);
        }).collect(Collectors.toSet());
    }
}

