/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.view.proto.FillGapStrategy;
import org.thingsboard.trendz.service.view.proto.GapSolveService;

@Service
public class GapSolveService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GapSolveService.class);

    public List<FieldValue> resolveGap(FieldValue left, FieldValue right, List<TimeRange> gaps, FillGapStrategy strategy) {
        FieldValue notNullValue;
        this.validateValuesAndMatching(left, right);
        FieldValue fieldValue = notNullValue = left == null ? right : left;
        if (left == null || right == null) {
            left = notNullValue;
            right = notNullValue;
        }
        Set items = notNullValue.getItems();
        FieldType fieldType = notNullValue.getFieldType();
        Stream<Long> timestampStream = gaps.stream().map(gap -> (gap.getStartTs() + gap.getEndTs()) / 2L);
        return switch (1.$SwitchMap$org$thingsboard$trendz$service$view$proto$FillGapStrategy[strategy.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.resolveBlank(items, fieldType, timestampStream, left, right);
            case 2 -> this.resolveZero(items, fieldType, timestampStream, left, right);
            case 3 -> this.resolveMin(items, fieldType, timestampStream, left, right);
            case 4 -> this.resolveMax(items, fieldType, timestampStream, left, right);
            case 5 -> this.resolveAvg(items, fieldType, timestampStream, left, right);
            case 6 -> this.resolveLeft(items, fieldType, timestampStream, left, right);
            case 7 -> this.resolveRight(items, fieldType, timestampStream, left, right);
            case 8 -> this.resolveLinear(items, fieldType, timestampStream, left, right);
        };
    }

    private void validateValuesAndMatching(FieldValue left, FieldValue right) {
        if (left == null && right == null) {
            throw new IllegalStateException("Neighboring values are null!");
        }
        if (left == null || right == null) {
            return;
        }
        if (left.getFieldType() != right.getFieldType()) {
            throw new IllegalStateException("Neighboring values are not matching by field type: left = [" + String.valueOf(left.getFieldType()) + "], right = [" + String.valueOf(right.getFieldType()) + "]");
        }
        if (!left.getItems().equals(right.getItems())) {
            throw new IllegalStateException("Neighboring values are not matching by items: left = " + String.valueOf(left.getItems()) + ", right = " + String.valueOf(right.getItems()));
        }
    }

    private List<FieldValue> resolveBlank(Set<Item> items, FieldType fieldType, Stream<Long> timestampStream, FieldValue left, FieldValue right) {
        return timestampStream.map(ts -> new FieldValue(items, FieldType.BLANK, null, ts.longValue())).collect(Collectors.toList());
    }

    private List<FieldValue> resolveZero(Set<Item> items, FieldType fieldType, Stream<Long> timestampStream, FieldValue left, FieldValue right) {
        Object zeroValue = switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldType[fieldType.ordinal()]) {
            case 1, 2 -> 0L;
            case 3 -> "";
            case 4 -> false;
            default -> throw new IllegalStateException("Unsupported field type for ZERO gap strategy: " + String.valueOf(fieldType));
        };
        return timestampStream.map(ts -> new FieldValue(items, fieldType, zeroValue, ts.longValue())).collect(Collectors.toList());
    }

    private List<FieldValue> resolveMin(Set<Item> items, FieldType fieldType, Stream<Long> timestampStream, FieldValue left, FieldValue right) {
        double l = ((Number)left.getInnerValue()).doubleValue();
        double r = ((Number)right.getInnerValue()).doubleValue();
        double minValue = Math.min(l, r);
        return timestampStream.map(ts -> new FieldValue(items, fieldType, (Object)minValue, ts.longValue())).collect(Collectors.toList());
    }

    private List<FieldValue> resolveMax(Set<Item> items, FieldType fieldType, Stream<Long> timestampStream, FieldValue left, FieldValue right) {
        double l = ((Number)left.getInnerValue()).doubleValue();
        double r = ((Number)right.getInnerValue()).doubleValue();
        double maxValue = Math.max(l, r);
        return timestampStream.map(ts -> new FieldValue(items, fieldType, (Object)maxValue, ts.longValue())).collect(Collectors.toList());
    }

    private List<FieldValue> resolveAvg(Set<Item> items, FieldType fieldType, Stream<Long> timestampStream, FieldValue left, FieldValue right) {
        double l = ((Number)left.getInnerValue()).doubleValue();
        double r = ((Number)right.getInnerValue()).doubleValue();
        double avgValue = (l + r) / 2.0;
        return timestampStream.map(ts -> new FieldValue(items, fieldType, (Object)avgValue, ts.longValue())).collect(Collectors.toList());
    }

    private List<FieldValue> resolveLeft(Set<Item> items, FieldType fieldType, Stream<Long> timestampStream, FieldValue left, FieldValue right) {
        return timestampStream.map(ts -> new FieldValue(items, fieldType, left.getInnerValue(), ts.longValue())).collect(Collectors.toList());
    }

    private List<FieldValue> resolveRight(Set<Item> items, FieldType fieldType, Stream<Long> timestampStream, FieldValue left, FieldValue right) {
        return timestampStream.map(ts -> new FieldValue(items, fieldType, right.getInnerValue(), ts.longValue())).collect(Collectors.toList());
    }

    private List<FieldValue> resolveLinear(Set<Item> items, FieldType fieldType, Stream<Long> timestampStream, FieldValue left, FieldValue right) {
        double l = ((Number)left.getInnerValue()).doubleValue();
        double r = ((Number)right.getInnerValue()).doubleValue();
        long lTs = left.getTs();
        long rTs = right.getTs();
        return timestampStream.map(ts -> {
            if (Double.compare(l, r) == 0) {
                return new FieldValue(items, fieldType, (Object)l, ts.longValue());
            }
            double value = l + (r - l) * (double)(ts - lTs) / (double)(rTs - lTs);
            return new FieldValue(items, fieldType, (Object)value, ts.longValue());
        }).collect(Collectors.toList());
    }
}

