/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.measurement.Measurable;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.service.aggregation.DateAggregationGroup;
import org.thingsboard.trendz.service.aggregation.DateAggregationKey;
import org.thingsboard.trendz.service.aggregation.DateAggregationValue;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.tools.DateTimeUtils;

@Service
public class DateGrouper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DateGrouper.class);

    @Measurable(context="#ctx", type=MeasuredTaskType.DATE_GROUPING, viewFieldName="#viewField.label", viewFieldAggregation="#viewField.aggregationType")
    public Map<DateAggregationGroup, List<FieldValue>> groupByDateFields(List<FieldValue> itemValues, DateAggregationType usedAggregationUnit, List<ViewField> dateAggregationFields, ViewRequest request, ViewField viewField) {
        HashMap<DateAggregationGroup, List<FieldValue>> groupedValues = new HashMap<DateAggregationGroup, List<FieldValue>>();
        if (dateAggregationFields.isEmpty()) {
            groupedValues.put(new DateAggregationGroup(), itemValues);
            return groupedValues;
        }
        ZoneId requestZoneId = request.getZoneId();
        for (FieldValue value : itemValues) {
            DateAggregationGroup groupKey;
            if (value.getFieldType().equals((Object)FieldType.BLANK) || (groupKey = this.getGroupKeyFromFieldValue(value, dateAggregationFields, request)).getKeys().isEmpty()) continue;
            groupedValues.computeIfAbsent(groupKey, i -> new ArrayList()).add(value);
        }
        Set items = itemValues.stream().map(FieldValue::getItems).flatMap(Collection::stream).collect(Collectors.toSet());
        List fillGaps = this.fillGaps(request, viewField, requestZoneId, groupedValues, usedAggregationUnit, dateAggregationFields, items, this.areAnomalyValues(itemValues));
        return groupedValues;
    }

    private boolean areAnomalyValues(List<FieldValue> itemValues) {
        return !itemValues.isEmpty() && itemValues.get(0).isAnomaly();
    }

    private boolean containsRawDateField(ViewRequest request) {
        return request.getDateAggregationFieldsVisible().stream().anyMatch(f -> f.getDateGrouping() == DateAggregationType.RAW);
    }

    private List<FieldValue> fillGaps(ViewRequest request, ViewField viewField, ZoneId zoneId, Map<DateAggregationGroup, List<FieldValue>> groupedValues, DateAggregationType usedAggregationUnit, List<ViewField> dateAggregationFields, Set<Item> itemSet, boolean needsToProcessFillGaps) {
        ArrayList<FieldValue> intervals = new ArrayList<FieldValue>();
        if (needsToProcessFillGaps || request.isFillGap()) {
            DateAggregationGroup groupKey;
            boolean containsRawDateField = this.containsRawDateField(request);
            ChronoUnit timeUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)usedAggregationUnit);
            ZonedDateTime startDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(request.getStartTs(viewField)), zoneId);
            ZonedDateTime endDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(request.getEndTs(viewField)), zoneId);
            ZonedDateTime currentDate = startDate;
            FieldValue timeValue = new FieldValue((Item)null, FieldType.BLANK, null, 0L);
            while (currentDate.isBefore(endDate)) {
                long currentTs = currentDate.toInstant().toEpochMilli();
                timeValue.setTs(currentTs);
                groupKey = this.getGroupKeyFromFieldValue(timeValue, dateAggregationFields, request);
                currentDate = currentDate.plus(1L, timeUnit);
                Collection valuesByGroupKey = groupedValues.getOrDefault(groupKey, Collections.emptyList());
                if (!valuesByGroupKey.isEmpty()) continue;
                if (needsToProcessFillGaps) {
                    intervals.add(new FieldValue(itemSet, FieldType.NUMERIC, (Object)0, currentTs));
                    continue;
                }
                if (!request.isFillGap()) continue;
                if (containsRawDateField) {
                    intervals.add(new FieldValue(itemSet, FieldType.NUMERIC, (Object)0, currentTs));
                    continue;
                }
                intervals.add(new FieldValue(itemSet, FieldType.BLANK, null, currentTs));
            }
            for (FieldValue interval : intervals) {
                groupKey = this.getGroupKeyFromFieldValue(interval, dateAggregationFields, request);
                if (groupKey.getKeys().isEmpty()) continue;
                groupedValues.computeIfAbsent(groupKey, i -> new ArrayList()).add(interval);
            }
        }
        return intervals;
    }

    private DateAggregationGroup getGroupKeyFromFieldValue(FieldValue interval, List<ViewField> dateAggregationFields, ViewRequest request) {
        DateAggregationGroup group = new DateAggregationGroup();
        for (ViewField aggregationField : dateAggregationFields) {
            DateAggregationKey groupKey = new DateAggregationKey(aggregationField.getId(), aggregationField.getDateGrouping());
            DateAggregationValue groupValue = this.applyGroupFunc(aggregationField, interval, request.getDatePickerConfig(), request.getZoneId());
            group.put(groupKey, groupValue);
        }
        return group;
    }

    private DateAggregationValue applyGroupFunc(ViewField dateAggField, FieldValue value, DatePickerConfig datePicker, ZoneId zoneId) {
        DateAggregationType dateGrouping = dateAggField.getDateGrouping();
        if (dateGrouping != DateAggregationType.RAW) {
            DateAggregationType fullDateGrouping = DateAggregationType.getFullType((DateAggregationType)dateGrouping);
            String dateString = dateGrouping.apply(value.getTs(), zoneId);
            String fullDateString = fullDateGrouping.apply(value.getTs(), zoneId);
            long dateTs = fullDateGrouping.apply(fullDateString, zoneId);
            return new DateAggregationValue(dateTs, dateString);
        }
        String rangeBy = datePicker.getRangeBy();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rangeBy})) {
            ChronoUnit chronoUnit = switch (rangeBy) {
                case "minute" -> ChronoUnit.MINUTES;
                case "hour" -> ChronoUnit.HOURS;
                case "day" -> ChronoUnit.DAYS;
                case "week" -> ChronoUnit.WEEKS;
                case "month" -> ChronoUnit.MONTHS;
                case "year" -> ChronoUnit.YEARS;
                default -> throw new TrendzInternalException("Unexpected behaviour in the date grouper!");
            };
            long date = DateTimeUtils.extendedTruncateTo((long)value.getTs(), (ZoneId)zoneId, (ChronoUnit)chronoUnit);
            return new DateAggregationValue(date, Long.valueOf(date).toString());
        }
        throw new TrendzInternalException("Unexpected behaviour in the date grouper!");
    }
}

