/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.measurement.Measurable;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.predict.PredictionService;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ItemDataLoader;
import org.thingsboard.trendz.service.view.proto.TelemetryCachePreloader;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.service.view.proto.WindowedStreamStore;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class DataLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataLoader.class);
    private final ItemDataLoader itemDataLoader;
    private final TelemetryCachePreloader telemetryCachePreloader;
    private final PredictionService predictionService;

    @Autowired
    public DataLoader(ItemDataLoader itemDataLoader, TelemetryCachePreloader telemetryCachePreloader, PredictionService predictionService) {
        this.itemDataLoader = itemDataLoader;
        this.telemetryCachePreloader = telemetryCachePreloader;
        this.predictionService = predictionService;
    }

    @Measurable(context="#ctx", type=MeasuredTaskType.LOAD_DATA, viewFieldName="#viewField.label", viewFieldAggregation="#viewField.aggregationType")
    public Flux<List<FieldValue>> loadData(ViewField viewField, Set<Item> items, WindowedStreamStore windowedStreamStore, ViewRequest request, ViewContext ctx, long methodId) {
        BusinessEntity businessEntity = (BusinessEntity)ctx.getBusinessEntityMap().get(viewField.getBusinessEntityId());
        BusinessEntityField entityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(viewField.getEntityFieldId());
        return Mono.just(items).doOnNext(l -> ctx.setFieldItemsCnt(viewField, l.size())).flatMap(itemList -> this.telemetryCachePreloader.preloadCache(itemList, request, viewField, businessEntity, entityField, ctx)).flatMapIterable(l -> l).flatMap(item -> this.loadItemValues(item, viewField, request, windowedStreamStore, entityField, businessEntity, ctx, methodId)).doOnNext(l -> ctx.setFieldValuesCnt(viewField, l.size()));
    }

    private Mono<List<FieldValue>> loadItemValues(Item item, ViewField viewField, ViewRequest request, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx, long methodId) {
        long startTs = System.currentTimeMillis();
        return this.itemDataLoader.loadData(item, viewField, request, windowedStreamStore, entityField, businessEntity, ctx, methodId).collectList().doOnNext(fieldValues -> fieldValues.forEach(fieldValue -> this.defineOwner(fieldValue, viewField, businessEntity, entityField, ctx))).doOnNext(fieldValues -> ctx.getStats().getFieldValueLoadTime().computeIfAbsent(viewField, id -> new AtomicLong()).addAndGet(System.currentTimeMillis() - startTs)).flatMap(fieldValues -> this.processPrediction(fieldValues, item, viewField, request, windowedStreamStore, ctx));
    }

    private void defineOwner(FieldValue fieldValue, ViewField viewField, BusinessEntity businessEntity, BusinessEntityField beField, ViewContext ctx) {
        if (businessEntity.getQuery().getEntityType().equals((Object)BusinessEntityType.EXTERNAL)) {
            return;
        }
        if (beField != null && viewField.getAggregationType() != FieldAggregation.COUNT && beField.getQuery().getQueryType().equals((Object)FieldQueryType.OWNER)) {
            String ownerName = "Admin";
            if (fieldValue.getInnerValue() != null && ctx.getOwnerDictionary().containsKey(fieldValue.getInnerValue()) && StringUtils.isBlank((CharSequence)(ownerName = (String)ctx.getOwnerDictionary().get(fieldValue.getInnerValue())))) {
                ownerName = "Admin";
            }
            fieldValue.setInnerValue((Object)ownerName);
        }
    }

    private Mono<List<FieldValue>> processPrediction(List<FieldValue> original, Item item, ViewField viewField, ViewRequest request, WindowedStreamStore windowedStreamStore, ViewContext ctx) {
        return Mono.just((Object)new Object()).flatMap(o -> {
            if (viewField.isPredictionEnabled() && !viewField.isBatchCalculation()) {
                List trimmedOriginal = original.stream().sorted(Comparator.comparingLong(FieldValue::getTs)).collect(Collectors.toList());
                return this.predictionService.enrichPrediction(viewField, trimmedOriginal, item, request, windowedStreamStore, ctx);
            }
            return Mono.just((Object)original);
        });
    }
}

