/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.StateProperty;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.measurement.Measurable;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.service.aggregation.DateAggregationGroup;
import org.thingsboard.trendz.service.aggregation.DateAggregationKey;
import org.thingsboard.trendz.service.aggregation.DateAggregationValue;
import org.thingsboard.trendz.service.cache.CachedTelemetryService;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.AggregatedValue;
import org.thingsboard.trendz.service.view.proto.AggregationService;
import org.thingsboard.trendz.service.view.proto.AggregationServiceImpl;
import org.thingsboard.trendz.service.view.proto.DateGrouper;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.tools.DateTimeUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AggregationServiceImpl
implements AggregationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AggregationServiceImpl.class);
    private final DateGrouper dateGrouper;

    @Autowired
    public AggregationServiceImpl(DateGrouper dateGrouper) {
        this.dateGrouper = dateGrouper;
    }

    @Measurable(context="#ctx", type=MeasuredTaskType.FIELD_AGGREGATION, viewFieldName="#viewField.label", viewFieldAggregation="#viewField.aggregationType")
    public Mono<List<AggregatedValue>> aggregate(List<List<FieldValue>> loadingData, ViewField viewField, DateAggregationType usedAggregationUnit, List<ViewField> dateAggregationFields, ViewRequest request, ViewContext ctx, long methodId) {
        BusinessEntityField entityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(viewField.getEntityFieldId());
        return Flux.fromIterable(loadingData).map(fieldValues -> this.calculateDelta(fieldValues, viewField, entityField, request)).map(fieldValues -> this.preagregate(fieldValues, viewField, request, usedAggregationUnit, dateAggregationFields, entityField, ctx)).collectList().map(lists -> lists.stream().flatMap(Collection::stream).collect(Collectors.toList())).map(aggregatedValueList -> this.groupAndAggregate(entityField, aggregatedValueList, request, ctx, usedAggregationUnit, dateAggregationFields, viewField)).map(aggregatedValueList -> this.postProcessDurationPercent(aggregatedValueList, request, viewField));
    }

    @Measurable(context="#ctx", type=MeasuredTaskType.FIELD_PRE_AGGREGATION, viewFieldName="#viewField.label", viewFieldAggregation="#viewField.aggregationType")
    public List<FieldValue> preagregate(List<FieldValue> fieldValues, ViewField viewField, ViewRequest request, DateAggregationType usedAggregationUnit, List<ViewField> dateAggregationFields, BusinessEntityField entityField, ViewContext ctx) {
        return this.groupAndAggregate(entityField, fieldValues, request, ctx, usedAggregationUnit, dateAggregationFields, viewField).stream().map(agVal -> agVal.hasDateGroups() ? Lists.newArrayList(agVal.getDateGroups().values()) : Lists.newArrayList((Object[])new FieldValue[]{agVal.getFieldValue()})).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<AggregatedValue> groupAndAggregate(BusinessEntityField entityField, List<FieldValue> itemValues, ViewRequest request, ViewContext ctx, DateAggregationType usedAggregationUnit, List<ViewField> dateAggregationFields, ViewField viewField) {
        boolean hasTime = this.hasTime(entityField, viewField);
        Set items = itemValues.stream().map(FieldValue::getItems).flatMap(Collection::stream).collect(Collectors.toSet());
        if (usedAggregationUnit != null && hasTime && viewField.getAggregationType() != FieldAggregation.UNIQ) {
            Map groupedValues = this.dateGrouper.groupByDateFields(itemValues, usedAggregationUnit, dateAggregationFields, request, viewField);
            AggregatedValue value = this.aggregateDayGroup(groupedValues, items, viewField, request);
            return Collections.singletonList(value);
        }
        if (itemValues.isEmpty()) {
            AggregatedValue value = new AggregatedValue(new FieldValue(Collections.emptySet(), FieldType.BLANK, null), items);
            return Collections.singletonList(value);
        }
        return this.aggregateValues(viewField.getAggregationType(), itemValues, 0L);
    }

    private AggregatedValue aggregateDayGroup(Map<DateAggregationGroup, List<FieldValue>> groupedValues, Set<Item> items, ViewField viewField, ViewRequest request) {
        if (groupedValues.isEmpty()) {
            return new AggregatedValue(new FieldValue((Set)Sets.newHashSet(items), FieldType.BLANK, null), items);
        }
        AggregatedValue dateAggregation = new AggregatedValue(null, items, new HashMap());
        for (DateAggregationGroup group : groupedValues.keySet()) {
            DateAggregationKey lowestKey = group.getLowestKey();
            DateAggregationValue dateValue = group.get(lowestKey);
            long currentTs = dateValue.getTs();
            List<FieldValue> fieldValues = groupedValues.get(group);
            List dateSubGroups = this.aggregateValues(viewField.getAggregationType(), fieldValues, currentTs);
            if (dateSubGroups.size() > 1) {
                throw new TrendzInternalException("Subgroup Aggregation is not allowed for fields with day grouping");
            }
            dateAggregation.getDateGroups().put(group, ((AggregatedValue)dateSubGroups.get(0)).getFieldValue());
        }
        return dateAggregation;
    }

    private boolean hasTime(BusinessEntityField entityField, ViewField viewField) {
        boolean result = false;
        result |= viewField.isBatchCalculation();
        result |= viewField.isNativeCalculation();
        result |= viewField.isStateField();
        result |= viewField.isAnomalyField();
        result |= viewField.isAlarmField();
        result |= viewField.getAggregationType() == FieldAggregation.COUNT;
        return result |= entityField != null && entityField.hasTime();
    }

    private List<AggregatedValue> aggregateValues(FieldAggregation fieldAggregationType, List<FieldValue> fieldValues, long optionalTs) {
        HashSet groupItems = new HashSet(fieldValues.size());
        ArrayList<FieldValue> nonBlankFieldValues = new ArrayList<FieldValue>(fieldValues.size());
        for (FieldValue fv : fieldValues) {
            if (!fv.getFieldType().equals((Object)FieldType.BLANK)) {
                nonBlankFieldValues.add(fv);
            }
            groupItems.addAll(fv.getItems());
        }
        if (nonBlankFieldValues.isEmpty()) {
            return this.makeAggregatedResult(groupItems, FieldType.BLANK, null, optionalTs, 0.0, 0L);
        }
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$FieldAggregation[fieldAggregationType.ordinal()]) {
            case 1 -> nonBlankFieldValues.stream().max(Comparator.comparingLong(FieldValue::getTs)).map(last -> this.makeAggregatedResult(groupItems, last.getFieldType(), last.getInnerValue(), last.getTs(), last.getNumeric().orElse(0.0).doubleValue(), 1L)).orElseThrow();
            case 2 -> {
                HashMap<Object, HashSet> valueToItems = new HashMap<Object, HashSet>(fieldValues.size());
                HashMap<Object, FieldValue> valueToField = new HashMap<Object, FieldValue>(fieldValues.size());
                for (FieldValue fv : nonBlankFieldValues) {
                    if (valueToItems.containsKey(fv.getInnerValue())) {
                        ((Set)valueToItems.get(fv.getInnerValue())).addAll(fv.getItems());
                        continue;
                    }
                    valueToItems.put(fv.getInnerValue(), Sets.newHashSet((Iterable)fv.getItems()));
                    valueToField.put(fv.getInnerValue(), fv);
                }
                ArrayList groupedResult = Lists.newArrayList();
                for (Map.Entry entry : valueToItems.entrySet()) {
                    FieldValue fieldValue = (FieldValue)valueToField.get(entry.getKey());
                    fieldValue.setItems((Set)entry.getValue());
                    groupedResult.add(new AggregatedValue(fieldValue, (Set)entry.getValue()));
                }
                yield groupedResult;
            }
            case 3 -> this.aggregate(nonBlankFieldValues, DoubleStream::average, null, groupItems, optionalTs);
            case 4 -> this.aggregate(nonBlankFieldValues, doubleStream -> doubleStream.reduce(Double::sum), null, groupItems, optionalTs);
            case 5 -> this.aggregate(nonBlankFieldValues, doubleStream -> doubleStream.reduce(Double::sum), (Object)0, groupItems, optionalTs);
            case 6 -> this.aggregate(nonBlankFieldValues, DoubleStream::min, null, groupItems, optionalTs);
            case 7 -> this.aggregate(nonBlankFieldValues, DoubleStream::max, null, groupItems, optionalTs);
            default -> throw new TrendzInternalException("Aggregation not implemented for " + String.valueOf(fieldAggregationType));
        };
    }

    private List<AggregatedValue> aggregate(List<FieldValue> nonBlankFieldValues, Function<DoubleStream, OptionalDouble> mapper, Object defaultValue, Set<Item> groupItems, long optionalTs) {
        double totalAvgSum = nonBlankFieldValues.stream().mapToDouble(FieldValue::getAvgSum).sum();
        long totalAvgCount = nonBlankFieldValues.stream().mapToLong(FieldValue::getAvgCount).sum();
        DoubleStream doubleStream = nonBlankFieldValues.stream().filter(v -> v.getNumeric().isPresent()).mapToDouble(v -> (Double)v.getNumeric().get());
        return mapper.apply(doubleStream).stream().mapToObj(avg -> this.makeAggregatedResult(groupItems, FieldType.NUMERIC, (Object)avg, optionalTs, totalAvgSum, totalAvgCount)).findAny().orElse(this.makeAggregatedResult(groupItems, FieldType.NUMERIC, defaultValue, optionalTs, 0.0, 0L));
    }

    private List<AggregatedValue> makeAggregatedResult(Set<Item> groupItems, FieldType type, Object value, long optionalTs, double totalAvgSum, long totalAvgCount) {
        return Collections.singletonList(new AggregatedValue(new FieldValue(groupItems, type, value, optionalTs, totalAvgSum, totalAvgCount), groupItems));
    }

    private List<FieldValue> calculateDelta(List<FieldValue> fieldValues, ViewField viewField, BusinessEntityField entityField, ViewRequest request) {
        if (!request.isDeltaFieldsPresent()) {
            return fieldValues;
        }
        if (!viewField.isCalculatedField() && entityField.getType() != FieldType.NUMERIC) {
            return fieldValues;
        }
        FieldType typeOfData = CachedTelemetryService.getFieldTypeOfData(fieldValues);
        if (viewField.isCalculatedField() && typeOfData != FieldType.NUMERIC) {
            return fieldValues;
        }
        if (!viewField.isUseDelta()) {
            return fieldValues;
        }
        List<FieldValue> nonBlankFields = fieldValues.stream().filter(fv -> !fv.getFieldType().equals((Object)FieldType.BLANK)).filter(v -> v.getNumeric().isPresent()).sorted(Comparator.comparingLong(FieldValue::getTs)).toList();
        if (nonBlankFields.isEmpty()) {
            return fieldValues;
        }
        ArrayList<Double> deltaValues = new ArrayList<Double>();
        ArrayList<FieldValue> deltaFields = new ArrayList<FieldValue>();
        FieldValue prev = nonBlankFields.iterator().next();
        for (FieldValue current : nonBlankFields) {
            if (current != prev) {
                double prevValue = (Double)prev.getNumeric().orElseThrow();
                double currentValue = (Double)current.getNumeric().orElseThrow();
                deltaFields.add(current);
                deltaValues.add(currentValue - prevValue);
            }
            prev = current;
        }
        for (int i = 0; i < deltaValues.size(); ++i) {
            ((FieldValue)deltaFields.get(i)).setInnerValue(deltaValues.get(i));
        }
        long realStartTs = viewField.getLocalTimeRange() != null ? viewField.getLocalTimeRange().buildStartEndPair(request.getZoneId(), request.getNowTs()).getStartTs() : request.getStartTs(null);
        List<FieldValue> result = deltaFields.stream().filter(fieldValue -> realStartTs <= fieldValue.getTs()).sorted(Comparator.comparingLong(FieldValue::getTs)).collect(Collectors.toList());
        return result;
    }

    private List<AggregatedValue> postProcessDurationPercent(List<AggregatedValue> aggregatedValues, ViewRequest request, ViewField viewField) {
        FieldValue fieldValue;
        boolean noDateAggregation;
        boolean stateFieldWithDurationPercent;
        boolean bl = stateFieldWithDurationPercent = viewField.isStateField() && viewField.getStateProperty() == StateProperty.DURATION_PERCENT;
        if (!stateFieldWithDurationPercent) {
            return aggregatedValues;
        }
        boolean bl2 = noDateAggregation = request.getMinimalDateAggregation() == null;
        if (noDateAggregation && aggregatedValues.size() == 1 && (fieldValue = aggregatedValues.iterator().next().getFieldValue()).getFieldType() == FieldType.BLANK) {
            return aggregatedValues;
        }
        if (viewField.getAggregationType() == FieldAggregation.COUNT) {
            if (noDateAggregation) {
                AggregationServiceImpl.processDurationPercentCountNoDate(aggregatedValues);
            } else {
                AggregationServiceImpl.processDurationPercentCountWithDate(aggregatedValues);
            }
        } else {
            ZoneId requestZoneId = request.getZoneId();
            long startTs = request.getStartTs(viewField);
            long endTs = request.getEndTs(viewField);
            ZonedDateTime requestStartDate = DateTimeUtils.fromTs((long)startTs, (ZoneId)requestZoneId);
            ZonedDateTime requestEndDate = DateTimeUtils.fromTs((long)endTs, (ZoneId)requestZoneId);
            if (noDateAggregation) {
                AggregationServiceImpl.processDurationPercentNoDate(aggregatedValues, (long)endTs, (long)startTs);
            } else {
                AggregationServiceImpl.processDurationPercentWithDate(aggregatedValues, (ViewRequest)request, (ZoneId)requestZoneId, (ZonedDateTime)requestStartDate, (ZonedDateTime)requestEndDate);
            }
        }
        return aggregatedValues;
    }

    private static void processDurationPercentCountNoDate(List<AggregatedValue> aggregatedValues) {
        double totalCount = aggregatedValues.stream().map(AggregatedValue::getFieldValue).mapToDouble(fieldValue -> (Double)fieldValue.getInnerValue()).sum();
        for (AggregatedValue av : aggregatedValues) {
            if (totalCount == 0.0) {
                av.getFieldValue().setInnerValue((Object)0);
                continue;
            }
            double count = (Double)av.getFieldValue().getInnerValue();
            double countPercent = count * 100.0 / totalCount;
            av.getFieldValue().setInnerValue((Object)countPercent);
        }
    }

    private static void processDurationPercentCountWithDate(List<AggregatedValue> aggregatedValues) {
        double totalCount = aggregatedValues.stream().map(AggregatedValue::getDateGroups).map(Map::values).flatMap(Collection::stream).mapToDouble(fieldValue -> (Double)fieldValue.getInnerValue()).sum();
        for (AggregatedValue av : aggregatedValues) {
            for (FieldValue value : av.getDateGroups().values()) {
                if (totalCount == 0.0) {
                    value.setInnerValue((Object)0);
                    continue;
                }
                double count = (Double)value.getInnerValue();
                double countPercent = count * 100.0 / totalCount;
                value.setInnerValue((Object)countPercent);
            }
        }
    }

    private static void processDurationPercentNoDate(List<AggregatedValue> aggregatedValues, long endTs, long startTs) {
        for (AggregatedValue av : aggregatedValues) {
            double duration = (Double)av.getFieldValue().getInnerValue();
            long totalDuration = endTs - startTs;
            int itemCount = av.getFieldValue().getItems().size();
            double durationPercent = totalDuration == 0L || itemCount == 0 ? 0.0 : duration * 100.0 / (double)(totalDuration * (long)itemCount);
            av.getFieldValue().setInnerValue((Object)durationPercent);
        }
    }

    private static void processDurationPercentWithDate(List<AggregatedValue> aggregatedValues, ViewRequest request, ZoneId requestZoneId, ZonedDateTime requestStartDate, ZonedDateTime requestEndDate) {
        DateAggregationType minimalDateAggregation = request.getMinimalDateAggregation();
        ChronoUnit minimalDateAggregationUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)minimalDateAggregation);
        DateAggregationType maximalCycleDateAggregation = AggregationServiceImpl.getMaximalCycleDateAggregation((ViewRequest)request);
        for (AggregatedValue av : aggregatedValues) {
            for (FieldValue value : av.getDateGroups().values()) {
                long currentTs = value.getTs();
                ZonedDateTime currentDate = DateTimeUtils.fromTs((long)currentTs, (ZoneId)requestZoneId);
                ZonedDateTime truncatedCurrentData = DateTimeUtils.extendedTruncateTo((ZonedDateTime)currentDate, (ChronoUnit)minimalDateAggregationUnit);
                ZonedDateTime currentPeriodStart = DateTimeUtils.max((ZonedDateTime)truncatedCurrentData, (ZonedDateTime)requestStartDate);
                ZonedDateTime currentPeriodEnd = DateTimeUtils.min((ZonedDateTime)truncatedCurrentData.plus(1L, minimalDateAggregationUnit), (ZonedDateTime)requestEndDate);
                long startTime = DateTimeUtils.toTs((ZonedDateTime)currentPeriodStart);
                long endTime = DateTimeUtils.toTs((ZonedDateTime)currentPeriodEnd);
                double duration = (Double)value.getInnerValue();
                long totalDuration = endTime - startTime;
                int itemCount = value.getItems().size();
                long unitCountInRange = AggregationServiceImpl.getUnitCountInRange((ZonedDateTime)requestStartDate, (ZonedDateTime)requestEndDate, (ZoneId)requestZoneId, (DateAggregationType)maximalCycleDateAggregation, (long)currentTs);
                double durationPercent = totalDuration == 0L || itemCount == 0 || unitCountInRange == 0L ? 0.0 : duration * 100.0 / (double)totalDuration / (double)itemCount / (double)unitCountInRange;
                value.setInnerValue((Object)durationPercent);
            }
        }
    }

    private static DateAggregationType getMaximalCycleDateAggregation(ViewRequest request) {
        Set availableGroups = request.getDateAggregationFieldsVisible().stream().map(ViewField::getDateGrouping).collect(Collectors.toSet());
        Object[] types = DateAggregationType.values();
        ArrayUtils.reverse((Object[])types);
        for (Object type : types) {
            if (!type.isCyclic() || !availableGroups.contains(type)) continue;
            return type;
        }
        return null;
    }

    private static long getUnitCountInRange(ZonedDateTime rangeStart, ZonedDateTime rangeEnd, ZoneId zoneId, DateAggregationType type, long unitTs) {
        if (type == null || !type.isCyclic()) {
            return 1L;
        }
        String filter = type.apply(unitTs, zoneId);
        long count = 0L;
        ChronoUnit timeUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)type);
        ZonedDateTime currentTime = rangeStart;
        while (currentTime.isBefore(rangeEnd)) {
            long currentTs = currentTime.toInstant().toEpochMilli();
            if (type.apply(currentTs, zoneId).equals(filter)) {
                ++count;
            }
            currentTime = currentTime.plus(1L, timeUnit);
        }
        return count;
    }
}

