/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.dao.model.prediction.PredictionModelDao;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.calculation.CalculationField;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.FilterCondition;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.measurement.Measurable;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.measurement.MeasurementInfo;
import org.thingsboard.trendz.domain.measurement.MeasurementLogger;
import org.thingsboard.trendz.domain.measurement.MeasurementReport;
import org.thingsboard.trendz.domain.measurement.MeasurementService;
import org.thingsboard.trendz.domain.measurement.RequestTrace;
import org.thingsboard.trendz.domain.measurement.TraceBuilder;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.domain.runtime.TimeEvent;
import org.thingsboard.trendz.domain.runtime.ViewReport;
import org.thingsboard.trendz.exception.BadConfiguredTaskException;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.exception.model.prediction.PredictionModelNotFoundException;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityFieldNotFoundException;
import org.thingsboard.trendz.exception.view.TrendzViewException;
import org.thingsboard.trendz.exception.view.ViewConfigBuildFailedException;
import org.thingsboard.trendz.exception.view.ViewRequestUnknownFieldTempException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.cache.CachedTelemetryService;
import org.thingsboard.trendz.service.calculation.CalculationFieldService;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.graph.RelationGraph;
import org.thingsboard.trendz.service.graph.RelationGraphService;
import org.thingsboard.trendz.service.metrics.ViewReportMetricService;
import org.thingsboard.trendz.service.model.prediction.PredictionModel;
import org.thingsboard.trendz.service.provider.TbCustomerRelationService;
import org.thingsboard.trendz.service.script.ScriptFieldPreprocessor;
import org.thingsboard.trendz.service.script.engine.MyCustomLogger;
import org.thingsboard.trendz.service.stats.StatsCollector;
import org.thingsboard.trendz.service.stats.TickType;
import org.thingsboard.trendz.service.view.CachedViewService;
import org.thingsboard.trendz.service.view.ViewBuildingResult;
import org.thingsboard.trendz.service.view.ViewBuildingService;
import org.thingsboard.trendz.service.view.ViewBuildingServiceImpl;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.ViewRequestFieldProcessor;
import org.thingsboard.trendz.service.view.proto.FillGapSettings;
import org.thingsboard.trendz.service.view.proto.LoadFieldOrderingService;
import org.thingsboard.trendz.service.view.proto.RequestStats;
import org.thingsboard.trendz.service.view.proto.Row;
import org.thingsboard.trendz.service.view.proto.RowBuilder;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.tools.DateTimeUtils;
import org.thingsboard.trendz.tools.json.JsonUtils;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ViewBuildingServiceImpl
implements ViewBuildingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ViewBuildingServiceImpl.class);
    private static final Set<FieldAggregation> ALLOWED_BATCHED_CALCULATION_FIELDS_AGGREGATIONS = Set.of(FieldAggregation.NONE, FieldAggregation.UNIQ, FieldAggregation.LATEST);
    private final LoadFieldOrderingService loadFieldOrderingService;
    private final BusinessEntityService businessEntityService;
    private final RelationGraphService relationGraphService;
    private final ScriptFieldPreprocessor scriptFieldPreprocessor;
    private final CachedViewService cachedViewService;
    private final ViewRequestFieldProcessor viewRequestFieldProcessor;
    private final TbCustomerRelationService tbCustomerRelationService;
    private final StatsCollector statsCollector;
    private final MeasurementService measurementService;
    private final MyCustomLogger customLogger;
    private final MeasurementLogger measurementLogger;
    private final TraceBuilder traceBuilder;
    private final ViewReportMetricService metricService;
    private final CalculationFieldService calculationFieldService;
    private final PredictionModelDao predictionModelDao;

    @Autowired
    public ViewBuildingServiceImpl(LoadFieldOrderingService loadFieldOrderingService, TraceBuilder traceBuilder, BusinessEntityService businessEntityService, RelationGraphService relationGraphService, ScriptFieldPreprocessor scriptFieldPreprocessor, CachedViewService cachedViewService, ViewRequestFieldProcessor viewRequestFieldProcessor, TbCustomerRelationService tbCustomerRelationService, StatsCollector statsCollector, MeasurementLogger measurementLogger, MeasurementService measurementService, MyCustomLogger customLogger, ViewReportMetricService metricService, CalculationFieldService calculationFieldService, PredictionModelDao predictionModelDao) {
        this.loadFieldOrderingService = loadFieldOrderingService;
        this.traceBuilder = traceBuilder;
        this.businessEntityService = businessEntityService;
        this.relationGraphService = relationGraphService;
        this.scriptFieldPreprocessor = scriptFieldPreprocessor;
        this.cachedViewService = cachedViewService;
        this.viewRequestFieldProcessor = viewRequestFieldProcessor;
        this.tbCustomerRelationService = tbCustomerRelationService;
        this.statsCollector = statsCollector;
        this.measurementLogger = measurementLogger;
        this.measurementService = measurementService;
        this.customLogger = customLogger;
        this.metricService = metricService;
        this.calculationFieldService = calculationFieldService;
        this.predictionModelDao = predictionModelDao;
    }

    @Measurable(context="", measurementReport="#measurementReport", type=MeasuredTaskType.BUILD_VIEW)
    public Mono<ViewBuildingResult> buildView(ViewConfig viewConfig, JwtSecurityUser user, MeasurementReport measurementReport) {
        long startTs = System.currentTimeMillis();
        this.metricService.incrementAllReportsCounter(user);
        return Mono.just((Object)new Object()).flatMap(obj -> {
            RequestStats stats = new RequestStats();
            stats.setSubmitTs(System.currentTimeMillis());
            ViewRequest request = new ViewRequest(viewConfig, startTs);
            this.checkNeedTruncateRequestTimeRanges(request, null);
            request.getFields().forEach(viewField -> {
                if (viewField.getLocalTimeRange() != null) {
                    this.checkNeedTruncateRequestTimeRanges(request, viewField);
                }
            });
            Optional optional = this.cachedViewService.getFromCache(viewConfig, user);
            if (optional.isPresent()) {
                log.info("Reuse ViewResult from Report Cache for task");
                return Mono.just((Object)new ViewBuildingResult((ViewReport)optional.get(), null));
            }
            request.getAllFields().forEach(field -> {
                if (field.isCalculatedField()) {
                    this.updateNewCalculationField(user, field);
                }
                if (field.isPredictionModelField()) {
                    this.preparePredictionModelField(user, field, request);
                }
            });
            this.scriptFieldPreprocessor.process(request, user);
            ViewContext ctx = this.initContext(request, user, stats);
            ctx.setStats(stats);
            ctx.setMeasurementReport(measurementReport);
            List orderedFields = this.loadFieldOrderingService.order(request, ctx);
            ctx.setOrderedFields(orderedFields);
            stats.setInitFinishTs(System.currentTimeMillis());
            return Mono.just((Object)new Object()).flatMap(o -> this.processViewRequest(request, ctx)).map(o -> {
                ctx.getRowBuilder().filterBlankFields(request, ctx);
                List rows = ctx.getRowBuilder().build(request, ctx);
                ArrayList events = Lists.newArrayList();
                for (Map.Entry entry : ctx.getTimeEventFields().entrySet()) {
                    List<TimeEvent> timeEvents = ((List)entry.getValue()).stream().map(fv -> new TimeEvent((UUID)entry.getKey(), fv.getTs(), fv.getInnerValue(), ((Item)fv.getItems().iterator().next()).getName())).toList();
                    events.addAll(timeEvents);
                }
                Map<UUID, List> viewFieldIdToLogsMap = request.getAllFields().stream().filter(viewField -> Objects.nonNull(viewField.getScriptDebugLogId())).map(viewField -> {
                    List logList = this.customLogger.getLog(viewField.getScriptDebugLogId());
                    this.customLogger.clearLog(viewField.getScriptDebugLogId());
                    return Pair.of((Object)viewField.getId(), (Object)logList);
                }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
                Map<UUID, Map> viewFieldIdToDebugDataMap = request.getFields().stream().filter(vf -> !vf.isCalculatedField() && vf.isCollectDebugDataSample()).map(viewField -> Pair.of((Object)viewField.getParentStateField(), (Object)viewField.getDebugDataSample())).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (o1, o2) -> {
                    HashMap mergedData = new HashMap();
                    mergedData.putAll(o1);
                    mergedData.putAll(o2);
                    return mergedData;
                }));
                ViewReport viewReport = new ViewReport(rows, (List)events, ctx.getFieldFilterOptions(), Long.valueOf(ctx.getMaxRealTs()), viewFieldIdToLogsMap, viewFieldIdToDebugDataMap, null, null);
                this.cachedViewService.cacheReport(viewConfig, user, viewReport);
                stats.setFinishTs(System.currentTimeMillis());
                if (log.isDebugEnabled()) {
                    ctx.getStats().printDebug(ctx);
                    this.statsCollector.logRequestStats();
                }
                measurementReport.setFieldKeyToItemsCnt(ctx.getFieldKeyToItemsCnt());
                measurementReport.setFieldKeyToValuesCnt(ctx.getFieldKeyToValuesCnt());
                return new ViewBuildingResult(viewReport, ctx);
            });
        }).map(viewReportAndContext -> {
            Map taskTypeListMap = measurementReport.getMeasurements().stream().collect(Collectors.groupingBy(MeasurementInfo::getType, Collectors.toList()));
            RequestTrace trace = this.traceBuilder.buildRequestTrace(measurementReport);
            ViewReport viewReport = viewReportAndContext.getViewReport();
            this.measurementLogger.log(taskTypeListMap, trace);
            viewReport.setMeasurements(taskTypeListMap);
            viewReport.setTrace(trace);
            this.metricService.incrementSuccessfulReportsCounter(user);
            this.metricService.recordSuccessfulReportDuration(user, System.currentTimeMillis() - startTs);
            this.logLoadTelemetryData(viewReportAndContext.getViewContext(), viewConfig, user);
            return viewReportAndContext;
        }).onErrorMap(throwable -> {
            Map<UUID, List> viewFieldIdToLogsMap = viewConfig.getAllFields().stream().filter(viewField -> viewField.getScriptDebugLogId() != null).map(viewField -> {
                List logList = this.customLogger.getLog(viewField.getScriptDebugLogId());
                this.customLogger.clearLog(viewField.getScriptDebugLogId());
                return Pair.of((Object)viewField.getId(), (Object)logList);
            }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
            String message = String.format("Error during view report build, view config = \"%s\"", viewConfig.getName());
            ObjectNode node = JsonUtils.getObjectMapper().createObjectNode();
            node.set("logs", JsonUtils.toNodeFromObject(viewFieldIdToLogsMap));
            node.set("message", JsonUtils.toNodeFromObject((Object)message));
            ViewConfigBuildFailedException exception = new ViewConfigBuildFailedException(JsonUtils.fromNodeToRaw((JsonNode)node), throwable, message, viewFieldIdToLogsMap);
            this.metricService.incrementFailedReportsCounter(user);
            this.metricService.recordFailedReportDuration(user, System.currentTimeMillis() - startTs);
            return exception;
        });
    }

    private void logLoadTelemetryData(ViewContext ctx, ViewConfig viewConfig, JwtSecurityUser user) {
        if (ctx == null) {
            return;
        }
        long tbTelemetryRequestCount = ctx.getTbTelemetryRequestCount().get();
        long tbTelemetryPointsCount = ctx.getTelemetryPointsCount().get();
        log.info("Loaded telemetry data: requests = {}, points = {} for view {} for user {} for tenant {}", new Object[]{tbTelemetryRequestCount, tbTelemetryPointsCount, viewConfig.getName(), user.getUserId(), ctx.getUser().getTenant()});
        this.metricService.recordLoadTelemetryPointsCount(user, tbTelemetryPointsCount, tbTelemetryRequestCount);
    }

    private void checkNeedTruncateRequestTimeRanges(ViewRequest viewRequest, ViewField viewField) {
        boolean predictionIsEnabled;
        boolean useCache = viewRequest.isUsePersistedCacheTelemetry();
        boolean truncationIsNeeded = useCache | (predictionIsEnabled = viewRequest.getFields().stream().anyMatch(ViewField::isPredictionEnabled));
        if (truncationIsNeeded) {
            ZonedDateTime truncatedEndDate;
            long prevStartTs = viewRequest.getStartTs(viewField);
            long prevEndTs = viewRequest.getEndTs(viewField) + 1000L;
            ZoneId requestZoneId = viewRequest.getZoneId();
            ChronoUnit timeUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)viewRequest.getCachingDateAggregationType());
            ZonedDateTime startDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(prevStartTs), requestZoneId);
            ZonedDateTime endDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(prevEndTs), requestZoneId);
            ZonedDateTime truncatedStartDate = DateTimeUtils.extendedTruncateTo((ZonedDateTime)startDate, (ChronoUnit)timeUnit);
            boolean truncationIsPossible = truncatedStartDate.isBefore(truncatedEndDate = DateTimeUtils.extendedTruncateTo((ZonedDateTime)endDate, (ChronoUnit)timeUnit));
            if (truncationIsPossible) {
                long newStartTs = truncatedStartDate.toInstant().toEpochMilli();
                long newEndTs = truncatedEndDate.toInstant().toEpochMilli() - 1L;
                if (log.isDebugEnabled()) {
                    log.debug("View request time ranges truncation: start = (before: {}, after: {}), end = (before: {}, after: {})", new Object[]{ZonedDateTime.ofInstant(Instant.ofEpochMilli(viewRequest.getStartTs(viewField)), requestZoneId), ZonedDateTime.ofInstant(Instant.ofEpochMilli(newStartTs), requestZoneId), ZonedDateTime.ofInstant(Instant.ofEpochMilli(viewRequest.getEndTs(viewField)), requestZoneId), ZonedDateTime.ofInstant(Instant.ofEpochMilli(newEndTs), requestZoneId)});
                }
                if (viewField == null || viewField.getLocalTimeRange() == null) {
                    viewRequest.setStartTs(newStartTs);
                    viewRequest.setEndTs(newEndTs);
                } else {
                    viewField.getLocalTimeRange().setSelectedType(null);
                    viewField.getLocalTimeRange().setStartTs(newStartTs);
                    viewField.getLocalTimeRange().setEndTs(newEndTs);
                }
            }
        }
    }

    private Mono<Boolean> processViewRequest(ViewRequest request, ViewContext ctx) {
        Row firstRow = new Row(ctx.getOrderedFields());
        RowBuilder rowBuilder = new RowBuilder(firstRow);
        ctx.setRowBuilder(rowBuilder);
        long startTs = System.currentTimeMillis();
        return this.processViewRequestRecursive(request, ctx, rowBuilder, 1).then(Mono.fromCallable(() -> {
            this.statsCollector.tick("viewFieldProcessed", startTs, System.currentTimeMillis(), TickType.VIEW_FIELD_TICK);
            int iteration = ctx.getStats().getMainIterations().incrementAndGet();
            log.debug("Row {} finished. Current rows size {}", (Object)iteration, (Object)rowBuilder.getAllRows().size());
            ctx.getStats().getIterationDuration().put(iteration, System.currentTimeMillis() - startTs);
            return true;
        }));
    }

    private Mono<Boolean> processViewRequestRecursive(ViewRequest request, ViewContext ctx, RowBuilder rowBuilder, int recursionDepth) {
        log.debug("View request processing, recursion depth = {}", (Object)recursionDepth);
        if (1000 < recursionDepth) {
            throw new TrendzViewException("The recursion depth is too high = " + recursionDepth);
        }
        return Mono.just((Object)rowBuilder.getAllRows()).doOnNext(rows -> ctx.getStats().getRowsAfterIteration().put(ctx.getStats().getMainIterations().get(), rows.size())).flatMapIterable(Function.identity()).flatMap(row -> {
            Optional unprocessedFieldOptional = row.getNextUnprocessed();
            if (unprocessedFieldOptional.isPresent()) {
                ViewField unprocessedField = (ViewField)unprocessedFieldOptional.get();
                return this.viewRequestFieldProcessor.processNextField(rowBuilder, row, unprocessedField, request, ctx);
            }
            return Mono.just((Object)false);
        }).collectList().map(boolList -> boolList.stream().anyMatch(i -> i)).flatMap(modified -> modified != false ? this.processViewRequestRecursive(request, ctx, rowBuilder, recursionDepth + 1) : Mono.just((Object)true));
    }

    private ViewContext initContext(ViewRequest request, JwtSecurityUser user, RequestStats stats) {
        List allEntities = this.businessEntityService.getAllEntities(user);
        this.validateRequest(request, allEntities);
        Map idToEntityMap = allEntities.stream().collect(Collectors.toMap(BusinessEntity::getId, Function.identity()));
        Map idToEntityFieldMap = allEntities.stream().map(BusinessEntity::getFields).flatMap(Collection::stream).collect(Collectors.toMap(BusinessEntityField::getId, Function.identity()));
        if (request.isCacheRequired()) {
            request.setCacheItemTelemetry(true);
            log.debug("Telemetry cache enabled");
        }
        boolean streamProcessingEnabled = this.defineStreamProcessing(request, allEntities);
        request.setStreamProcessingEnabled(streamProcessingEnabled);
        RelationGraph initialGraph = this.relationGraphService.createGraph(allEntities);
        Set allowedEntityIds = request.getAllowedEntityIds();
        RelationGraph reducedGraph = allowedEntityIds.isEmpty() ? initialGraph : this.relationGraphService.reduceGraph(initialGraph, allowedEntityIds);
        Set requestedEntityIds = this.extractRequestedEntities(request);
        this.addExternalBeParentsIfNeeded(request, requestedEntityIds, idToEntityMap);
        RelationGraph finalGraph = this.relationGraphService.getMinimalGraph(reducedGraph, requestedEntityIds);
        this.relationGraphService.validateGraph(finalGraph);
        Set requestedEntitiesWithAttributeIds = this.extractRequestedEntitiesWithAttributeField(request, idToEntityFieldMap);
        List fieldsToAdd = this.addMissedRelationFields(finalGraph, requestedEntitiesWithAttributeIds, idToEntityMap, idToEntityFieldMap);
        request.getFields().addAll(fieldsToAdd);
        this.addLatestFieldsForTelemetryCaching(request, idToEntityFieldMap);
        ViewContext ctx = new ViewContext(allEntities, finalGraph, user, request.getRequestPriority());
        this.enableOwnerLoading(request, user, stats, ctx);
        this.initRoot(request, finalGraph, ctx);
        UUID rootEntityId = request.getRootEntityId();
        Map distancesFromRoot = this.relationGraphService.computeDistancesFromRoot(finalGraph, rootEntityId);
        ctx.setDistancesFromRoot(distancesFromRoot);
        Map predictionToHistoricalFieldMap = this.findWiredPredictionAndHistoricalFields(user, request);
        HashSet historicalFieldSet = new HashSet(predictionToHistoricalFieldMap.values());
        ctx.setPredictionToHistoricalFieldMap(predictionToHistoricalFieldMap);
        ctx.setHistoricalFieldSet(historicalFieldSet);
        ctx.setLastHistoricalTsPointMap(new ConcurrentHashMap());
        return ctx;
    }

    private void validateRequest(ViewRequest request, List<BusinessEntity> allEntities) {
        this.validateAlarmFields(request);
        this.validateNoneAggregation(request);
        this.validateUsedDisallowedEntities(request, allEntities);
        this.validateUnknownFields(request, allEntities);
        this.validateUnreferencedCalculatedFields(request);
        this.validateEmptyReferenceFields(request);
        this.validateEmptyFillGapSettings(request);
        this.validateAnomalyFields(request);
        this.validateExternalEntities(request, allEntities);
    }

    private void validateAlarmFields(ViewRequest request) {
        List<String> fields = request.getFields().stream().filter(ViewField::isAlarmField).filter(vf -> vf.getBusinessEntityId() == null).map(ViewField::getLabel).toList();
        if (!fields.isEmpty()) {
            String message = String.format("There are alarm fields without selected originator business entity: %s", Arrays.toString(fields.toArray()));
            throw new BadConfiguredTaskException(message);
        }
    }

    private void validateNoneAggregation(ViewRequest request) {
        List<String> fieldsWithNoneAggregation = request.getFields().stream().filter(viewField -> !viewField.isForStateCondition()).filter(viewField -> !viewField.isSimpleCalculation()).filter(viewField -> FieldAggregation.NONE.equals((Object)viewField.getAggregationType())).map(ViewField::getLabel).toList();
        List<String> batchedConditionalFieldsWithWrongAggregation = request.getFields().stream().filter(ViewField::isBatchCalculation).map(ViewField::getConditionFieldIds).filter(Objects::nonNull).map(Map::values).flatMap(Collection::stream).filter(ViewField::isForStateCondition).filter(viewField -> !ALLOWED_BATCHED_CALCULATION_FIELDS_AGGREGATIONS.contains(viewField.getAggregationType())).map(ViewField::getLabel).toList();
        if (!fieldsWithNoneAggregation.isEmpty()) {
            String message = String.format("Some fields uses aggregations that are not allowed: %s", Arrays.toString(fieldsWithNoneAggregation.toArray()));
            throw new BadConfiguredTaskException(message);
        }
        if (!batchedConditionalFieldsWithWrongAggregation.isEmpty()) {
            String message = String.format("Some fields uses aggregations that are not allowed: %s", Arrays.toString(batchedConditionalFieldsWithWrongAggregation.toArray()));
            throw new BadConfiguredTaskException(message);
        }
    }

    private void validateUsedDisallowedEntities(ViewRequest request, List<BusinessEntity> allEntities) {
        Set requestedEntityIds;
        Sets.SetView remainedDisallowedEntities;
        Set allowedEntityIds = request.getAllowedEntityIds();
        if (!allowedEntityIds.isEmpty() && !(remainedDisallowedEntities = Sets.difference((Set)(requestedEntityIds = this.extractRequestedEntities(request)), (Set)allowedEntityIds)).isEmpty()) {
            Map idToEntityMap = allEntities.stream().collect(Collectors.toMap(BusinessEntity::getId, Function.identity()));
            List entityNames = remainedDisallowedEntities.stream().map(idToEntityMap::get).map(BusinessEntity::getName).collect(Collectors.toList());
            String message = String.format("Some fields uses entities that are not allowed: %s", Arrays.toString(entityNames.toArray()));
            throw new BadConfiguredTaskException(message);
        }
    }

    private void validateUnknownFields(ViewRequest request, List<BusinessEntity> allEntities) {
        Set knownEntityFieldIds;
        Set entityFieldIds = this.extractRequestedEntityFields(request);
        Sets.SetView unknownEntityField = Sets.difference((Set)entityFieldIds, knownEntityFieldIds = allEntities.stream().map(BusinessEntity::getFields).flatMap(Collection::stream).map(BusinessEntityField::getId).collect(Collectors.toSet()));
        if (!unknownEntityField.isEmpty()) {
            Map<UUID, String> idToLabelMap = request.getFields().stream().collect(Collectors.toMap(ViewField::getEntityFieldId, ViewField::getLabel, (o1, o2) -> o1 + ", " + o2));
            Object[] unknownFieldNameArray = unknownEntityField.stream().map(idToLabelMap::get).map(label -> "[" + label + "]").distinct().toArray();
            String message = String.format("The view config contains fields that represent unknown fields: %s", Arrays.toString(unknownFieldNameArray));
            throw new ViewRequestUnknownFieldTempException(message);
        }
    }

    private void validateUnreferencedCalculatedFields(ViewRequest request) {
        List fieldIdsWithoutRelation = request.getFields().stream().filter(viewField -> viewField.isBatchCalculation() || viewField.isStateField()).filter(viewField -> viewField.getBusinessEntityId() == null).map(ViewField::getId).collect(Collectors.toList());
        if (!fieldIdsWithoutRelation.isEmpty()) {
            Map<UUID, String> idToLabelMap = request.getFields().stream().collect(Collectors.toMap(ViewField::getId, ViewField::getLabel));
            Object[] fieldNameWithoutRelationArray = fieldIdsWithoutRelation.stream().map(idToLabelMap::get).toArray();
            String message = String.format("The request contains fields without any relation to business entities: %s", Arrays.toString(fieldNameWithoutRelationArray));
            throw new BadConfiguredTaskException(message);
        }
    }

    private void validateEmptyReferenceFields(ViewRequest request) {
        request.getFields().stream().filter(ViewField::isSimpleCalculation).forEach(f -> {
            UUID entityId = f.getBusinessEntityId();
            if (!EntityId.NULL_UUID.equals(entityId)) {
                throw new TrendzException("Field validation failed: simple calculation fields mustn't have business entity id.");
            }
        });
        request.getFields().stream().filter(f -> !f.isSimpleCalculation()).forEach(f -> {
            UUID entityId = f.getBusinessEntityId();
            if (entityId == null || EntityId.NULL_UUID.equals(entityId)) {
                throw new TrendzException("Field validation failed: non simple calculation fields must have business entity id.");
            }
        });
    }

    private void validateEmptyFillGapSettings(ViewRequest request) {
        for (ViewField viewField : request.getAllFields()) {
            FillGapSettings settings = viewField.getFillGapSettings();
            if (settings == null || !settings.isEnableFillGap() || settings.getFillGapStrategy() != null && settings.getTimeUnit() != null) continue;
            String message = String.format("The [%s] field has empty values of Fill Gap settings.", viewField.getLabel());
            throw new BadConfiguredTaskException(message);
        }
    }

    private void validateAnomalyFields(ViewRequest request) {
        Optional<ViewField> anomalyFieldWithEmptyBeId = request.getAnomalyFields().stream().filter(f -> f.getBusinessEntityId() == null).findAny();
        if (anomalyFieldWithEmptyBeId.isPresent()) {
            String label = anomalyFieldWithEmptyBeId.get().getLabel();
            throw new BadConfiguredTaskException("Anomaly field has not selected model: " + label);
        }
    }

    private void validateExternalEntities(ViewRequest request, List<BusinessEntity> allEntities) {
        Map idToEntityMap = allEntities.stream().collect(Collectors.toMap(BusinessEntity::getId, Function.identity()));
        Set requestedEntityIds = this.extractRequestedEntities(request);
        requestedEntityIds.stream().map(idToEntityMap::get).filter(businessEntity -> {
            BusinessEntityType entityType = businessEntity.getQuery().getEntityType();
            return BusinessEntityType.EXTERNAL.equals((Object)entityType);
        }).forEach(businessEntity -> {
            Set relatedEntityIdSet = businessEntity.getRelations().stream().filter(Relation::isEnabled).map(Relation::getRelatedEntityId).collect(Collectors.toSet());
            this.validateExternalEntitiesRelatedSet(businessEntity, relatedEntityIdSet, idToEntityMap);
            UUID relatedEntityId = (UUID)relatedEntityIdSet.iterator().next();
            BusinessEntity relatedEntity = (BusinessEntity)idToEntityMap.get(relatedEntityId);
            Set reverseRelatedEntityIdSet = relatedEntity.getRelations().stream().filter(Relation::isEnabled).map(Relation::getRelatedEntityId).filter(entityId -> businessEntity.getId().equals(entityId)).collect(Collectors.toSet());
            this.validateExternalEntitiesRelatedSet(businessEntity, reverseRelatedEntityIdSet, idToEntityMap);
        });
    }

    private void validateExternalEntitiesRelatedSet(BusinessEntity businessEntity, Set<UUID> relatedEntityIdSet, Map<UUID, BusinessEntity> idToEntityMap) {
        if (relatedEntityIdSet.isEmpty()) {
            String message = String.format("The given business entity [%s] does not have any external relation", businessEntity.getName());
            throw new TrendzException(message);
        }
        if (relatedEntityIdSet.size() > 1) {
            Object[] relatedEntityNames = (String[])relatedEntityIdSet.stream().map(idToEntityMap::get).map(BusinessEntity::getName).map(name -> "[" + name + "]").toArray(String[]::new);
            String message = String.format("The given external business entity [%s] must have only one external relation but several were found: %s", businessEntity.getName(), Arrays.toString(relatedEntityNames));
            throw new TrendzException(message);
        }
    }

    private boolean defineStreamProcessing(ViewRequest request, List<BusinessEntity> allEntities) {
        boolean rawDataLoading;
        JsonNode rawDataLoadingNode = request.getSettings().get("rawDataLoading");
        boolean bl = rawDataLoading = rawDataLoadingNode != null && rawDataLoadingNode.booleanValue();
        if (rawDataLoading) {
            return true;
        }
        if (DateAggregationType.isNotLoadableAggregationType((DateAggregationType)request.getMinimalDateAggregation())) {
            return true;
        }
        Map idToEntityFieldMap = allEntities.stream().map(BusinessEntity::getFields).flatMap(Collection::stream).collect(Collectors.toMap(BusinessEntityField::getId, Function.identity()));
        for (ViewField viewField : request.getFields()) {
            if (viewField.isPredictionEnabled()) {
                return true;
            }
            if (viewField.getFillGapSettings() != null && viewField.getFillGapSettings().isEnableFillGap()) {
                return true;
            }
            BusinessEntityField entityField = (BusinessEntityField)idToEntityFieldMap.get(viewField.getEntityFieldId());
            if (entityField == null || !entityField.hasTime() || viewField.getAggregationType() != FieldAggregation.UNIQ) continue;
            return true;
        }
        long alarmFields = request.getFields().stream().filter(ViewField::isAlarmField).count();
        if (alarmFields > 1L) {
            return true;
        }
        boolean hasDelta = request.getAllFields().stream().anyMatch(ViewField::isUseDelta);
        return hasDelta;
    }

    private List<ViewField> extractAllFieldsFromRequest(ViewRequest request) {
        List fields = request.getFields();
        List calculationFields = request.getFields().stream().map(ViewField::getConditionFieldIds).filter(Objects::nonNull).map(Map::values).flatMap(Collection::stream).collect(Collectors.toList());
        ArrayList<ViewField> result = new ArrayList<ViewField>();
        result.addAll(fields);
        result.addAll(calculationFields);
        return result;
    }

    private Set<UUID> extractRequestedEntities(ViewRequest request) {
        return this.extractAllFieldsFromRequest(request).stream().map(ViewField::getBusinessEntityId).filter(id -> !EntityId.NULL_UUID.equals(id)).collect(Collectors.toSet());
    }

    private Set<UUID> extractRequestedEntityFields(ViewRequest request) {
        return this.extractAllFieldsFromRequest(request).stream().map(ViewField::getEntityFieldId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Set<UUID> extractRequestedEntitiesWithAttributeField(ViewRequest request, Map<UUID, BusinessEntityField> idToFieldMap) {
        Set<FieldQueryType> attributeQueryTypeSet = Set.of(FieldQueryType.ENTITY_ID, FieldQueryType.ENTITY_NAME, FieldQueryType.ENTITY_LABEL, FieldQueryType.OWNER, FieldQueryType.ATTRIBUTE);
        return this.extractAllFieldsFromRequest(request).stream().filter(viewField -> viewField.getEntityFieldId() != null).filter(viewField -> {
            UUID entityFieldId = viewField.getEntityFieldId();
            BusinessEntityField entityField = (BusinessEntityField)idToFieldMap.get(entityFieldId);
            FieldQueryType queryType = entityField.getQuery().getQueryType();
            boolean isAttributeType = attributeQueryTypeSet.contains(queryType);
            FieldAggregation aggregationType = viewField.getAggregationType();
            boolean isAllowableAgg = FieldAggregation.UNIQ.equals((Object)aggregationType);
            return isAttributeType && isAllowableAgg;
        }).map(ViewField::getBusinessEntityId).collect(Collectors.toSet());
    }

    private void addExternalBeParentsIfNeeded(ViewRequest request, Set<UUID> requestedEntityIds, Map<UUID, BusinessEntity> idToEntityMap) {
        Set externalBeParentIdSet = requestedEntityIds.stream().map(idToEntityMap::get).filter(businessEntity -> {
            BusinessEntityType entityType = businessEntity.getQuery().getEntityType();
            return BusinessEntityType.EXTERNAL.equals((Object)entityType);
        }).flatMap(businessEntity -> businessEntity.getRelations().stream().map(Relation::getRelatedEntityId).findAny().stream()).collect(Collectors.toSet());
        for (UUID externalBeParentId : externalBeParentIdSet) {
            if (requestedEntityIds.contains(externalBeParentId)) continue;
            BusinessEntity externalBeParent = idToEntityMap.get(externalBeParentId);
            BusinessEntityField nameEntityField = externalBeParent.getFields().stream().filter(entityField -> FieldQueryType.ENTITY_NAME.equals((Object)entityField.getQuery().getQueryType())).findAny().orElseThrow();
            String entityName = externalBeParent.getName();
            ViewField missedField = new ViewField();
            missedField.setId(TimeStampUUIDGenerator.generateId());
            missedField.setHidden(true);
            missedField.setAggregationType(FieldAggregation.UNIQ);
            missedField.setBusinessEntityId(externalBeParent.getId());
            missedField.setEntityFieldId(nameEntityField.getId());
            missedField.setLabel(entityName + " (missed, external parent)");
            requestedEntityIds.add(externalBeParentId);
            request.getFields().add(missedField);
            log.info("Add missed external parent {} {}", (Object)externalBeParent.getId(), (Object)entityName);
        }
    }

    public List<ViewField> addMissedRelationFields(RelationGraph graph, Set<UUID> requestedEntitiesWithAttributeIds, Map<UUID, BusinessEntity> idToEntityMap, Map<UUID, BusinessEntityField> idToEntityFieldMap) {
        Set entityIdSet = this.relationGraphService.getEntitySet(graph);
        Sets.SetView missedEntityIdSet = Sets.difference((Set)entityIdSet, requestedEntitiesWithAttributeIds);
        Map entityIdToNameFieldMap = idToEntityFieldMap.values().stream().filter(entityField -> {
            FieldQueryType queryType = entityField.getQuery().getQueryType();
            boolean sqlIdKey = entityField.getQuery().isSqlIdKey();
            return sqlIdKey || FieldQueryType.ENTITY_NAME.equals((Object)queryType);
        }).collect(Collectors.toMap(BusinessEntityField::getBusinessEntityId, Function.identity(), (o1, o2) -> {
            String entityName = ((BusinessEntity)idToEntityMap.get(o1.getBusinessEntityId())).getName();
            String message = String.format("There are two or more name/sql-id field in the entity, but only one allowed! Entity = %s, fields = [%s, %s]", entityName, o1.getName(), o2.getName());
            throw new TrendzException(message);
        }));
        return missedEntityIdSet.stream().map(missedEntityId -> {
            String missedEntityName = ((BusinessEntity)idToEntityMap.get(missedEntityId)).getName();
            UUID missedEntityFieldId = ((BusinessEntityField)entityIdToNameFieldMap.get(missedEntityId)).getId();
            ViewField missedEntityField = new ViewField();
            missedEntityField.setId(TimeStampUUIDGenerator.generateId());
            missedEntityField.setLabel(missedEntityName + " (missed)");
            missedEntityField.setMissedRelationField(true);
            missedEntityField.setBusinessEntityId(missedEntityId);
            missedEntityField.setEntityFieldId(missedEntityFieldId);
            missedEntityField.setAggregationType(FieldAggregation.UNIQ);
            log.debug("Add missed entity: {} {}", missedEntityId, (Object)missedEntityName);
            return missedEntityField;
        }).collect(Collectors.toList());
    }

    private void addLatestFieldsForTelemetryCaching(ViewRequest request, Map<UUID, BusinessEntityField> idToEntityFieldMap) {
        if (!request.isUsePersistedCacheTelemetry()) {
            return;
        }
        List latestFields = request.getFields().stream().filter(viewField -> {
            if (viewField.isCalculatedField() || viewField.isBatchCalculation() || viewField.isStateField()) {
                return false;
            }
            BusinessEntityField entityField = (BusinessEntityField)idToEntityFieldMap.get(viewField.getEntityFieldId());
            return CachedTelemetryService.isPossibleToUseTelemetryCache((ViewRequest)request, (ViewField)viewField, (BusinessEntityField)entityField);
        }).collect(Collectors.toMap(field -> ((BusinessEntityField)idToEntityFieldMap.get(field.getEntityFieldId())).getQuery(), Function.identity(), (o1, o2) -> o1)).values().stream().map(viewField -> ViewBuildingServiceImpl.getLatestTelemetryViewField((String)viewField.getLabel(), (UUID)viewField.getBusinessEntityId(), (UUID)viewField.getEntityFieldId(), (boolean)true)).collect(Collectors.toList());
        request.getFields().addAll(latestFields);
    }

    public static ViewField getLatestTelemetryViewField(String label, UUID businessEntityId, UUID entityFieldId, boolean isHidden) {
        ViewField resultField = new ViewField();
        resultField.setId(TimeStampUUIDGenerator.generateId());
        resultField.setLabel(label + " (latest telemetry)");
        resultField.setHidden(isHidden);
        resultField.setBusinessEntityId(businessEntityId);
        resultField.setEntityFieldId(entityFieldId);
        resultField.setAggregationType(FieldAggregation.LATEST);
        return resultField;
    }

    private void enableOwnerLoading(ViewRequest request, JwtSecurityUser securityUser, RequestStats stats, ViewContext ctx) {
        boolean withOwner = request.getFields().stream().map(ViewField::getEntityFieldId).filter(Objects::nonNull).anyMatch(entityFieldId -> {
            BusinessEntityField entityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(entityFieldId);
            return entityField.getQuery().getQueryType().equals((Object)FieldQueryType.OWNER);
        });
        if (withOwner) {
            request.setOwnerRequired(true);
            long startTs = System.currentTimeMillis();
            Map customerDictionary = this.tbCustomerRelationService.getCustomerDictionary(securityUser);
            Map tenantCustomerInfo = this.tbCustomerRelationService.getTenantCustomerInfoDictionary(securityUser, ctx);
            stats.setCustomerDictionaryLoadTime(System.currentTimeMillis() - startTs);
            ctx.getOwnerDictionary().putAll(customerDictionary);
            ctx.getOwnerDictionary().putAll(tenantCustomerInfo);
        }
    }

    private void initRoot(ViewRequest request, RelationGraph relationGraph, ViewContext ctx) {
        boolean manual;
        UUID root;
        if (request.getRootEntityId() == null) {
            root = this.defineRoot(request, relationGraph, ctx);
            request.setRootEntityId(root);
            manual = false;
        } else {
            root = request.getRootEntityId();
            manual = true;
            Set entitySet = this.relationGraphService.getEntitySet(relationGraph);
            if (!entitySet.contains(root)) {
                throw new BadConfiguredTaskException("You have chosen a root that is not related to provided fields.");
            }
        }
        String entityName = "STUB";
        if (!EntityId.NULL_UUID.equals(root)) {
            Map idToEntityMap = ctx.getBusinessEntityMap();
            BusinessEntity businessEntity = (BusinessEntity)idToEntityMap.get(root);
            entityName = businessEntity.getName();
        }
        log.info("Set default root: name = {}, manually = {}", (Object)entityName, (Object)manual);
    }

    private UUID defineRoot(ViewRequest request, RelationGraph relationGraph, ViewContext ctx) {
        Set fieldsWithAllowedEntity = request.getFields().stream().filter(f -> !f.isSimpleCalculation()).filter(f -> {
            BusinessEntity be = (BusinessEntity)ctx.getBusinessEntityMap().get(f.getBusinessEntityId());
            return !BusinessEntityType.EXTERNAL.equals((Object)be.getQuery().getEntityType());
        }).collect(Collectors.toSet());
        Set primaryFields = fieldsWithAllowedEntity.stream().filter(f -> !f.isMissedRelationField()).filter(f -> !f.isAnomalyField()).filter(f -> !f.isAlarmField()).filter(f -> !f.isStateField()).filter(f -> !f.isBatchCalculation()).filter(f -> !f.isNativeCalculation()).collect(Collectors.toSet());
        Set primaryFieldIds = primaryFields.stream().map(ViewField::getId).collect(Collectors.toSet());
        Set secondaryFields = fieldsWithAllowedEntity.stream().filter(f -> !primaryFieldIds.contains(f.getId())).collect(Collectors.toSet());
        Map idToFieldMap = ctx.getBusinessEntityFieldMap();
        Set fieldsWithAttributes = primaryFields.stream().filter(viewField -> {
            UUID entityFieldId = viewField.getEntityFieldId();
            BusinessEntityField entityField = (BusinessEntityField)idToFieldMap.get(entityFieldId);
            FieldQueryType queryType = entityField.getQuery().getQueryType();
            return !queryType.hasTime();
        }).collect(Collectors.toSet());
        Set fieldsIdsWithTelemetry = primaryFields.stream().filter(viewField -> {
            UUID entityFieldId = viewField.getEntityFieldId();
            BusinessEntityField entityField = (BusinessEntityField)idToFieldMap.get(entityFieldId);
            FieldQueryType queryType = entityField.getQuery().getQueryType();
            return queryType.hasTime();
        }).collect(Collectors.toSet());
        HashSet simpleAggregations = Sets.newHashSet((Object[])new FieldAggregation[]{FieldAggregation.UNIQ, FieldAggregation.NONE, FieldAggregation.LATEST});
        Set fieldsWithAggregatedAttributes = fieldsWithAttributes.stream().filter(f -> simpleAggregations.contains(f.getAggregationType())).collect(Collectors.toSet());
        Set fieldsWithAggregatedTelemetry = fieldsIdsWithTelemetry.stream().filter(f -> simpleAggregations.contains(f.getAggregationType())).collect(Collectors.toSet());
        Set fieldsWithFilteredAggregatedAttributes = fieldsWithAttributes.stream().filter(ViewField::isEnableRuntimeFilter).filter(viewField -> {
            Optional<RuntimeFilterField> optional = request.getRuntimeFilters().stream().filter(f -> f.getViewFieldId().equals(viewField.getId())).findAny();
            if (optional.isEmpty()) {
                return false;
            }
            RuntimeFilterField filter = optional.get();
            boolean includeCondition = filter.getCondition() == FilterCondition.ONE_OF && !filter.getSelection().isEmpty();
            boolean excludeCondition = filter.getCondition() == FilterCondition.NO_ONE_OF && filter.getSelection().isEmpty();
            boolean anotherCondition = filter.getCondition() != FilterCondition.ONE_OF && filter.getCondition() != FilterCondition.NO_ONE_OF;
            return includeCondition || excludeCondition || anotherCondition;
        }).collect(Collectors.toSet());
        Set fieldsWithFilteredAggregatedTelemetry = fieldsWithAttributes.stream().filter(ViewField::isEnableRuntimeFilter).collect(Collectors.toSet());
        Set selectedCandidates = fieldsWithFilteredAggregatedAttributes;
        if (selectedCandidates.isEmpty()) {
            selectedCandidates = fieldsWithAggregatedAttributes;
        }
        if (selectedCandidates.isEmpty()) {
            selectedCandidates = fieldsWithAttributes;
        }
        if (selectedCandidates.isEmpty()) {
            selectedCandidates = fieldsWithFilteredAggregatedTelemetry;
        }
        if (selectedCandidates.isEmpty()) {
            selectedCandidates = fieldsWithAggregatedTelemetry;
        }
        if (selectedCandidates.isEmpty()) {
            selectedCandidates = fieldsIdsWithTelemetry;
        }
        if (selectedCandidates.isEmpty()) {
            selectedCandidates = secondaryFields;
        }
        if (selectedCandidates.isEmpty()) {
            selectedCandidates = fieldsWithAllowedEntity;
        }
        if (selectedCandidates.isEmpty()) {
            return EntityId.NULL_UUID;
        }
        Set entityIds = selectedCandidates.stream().map(ViewField::getBusinessEntityId).collect(Collectors.toSet());
        return this.relationGraphService.findCentralNode(relationGraph, entityIds);
    }

    private Map<UUID, UUID> findWiredPredictionAndHistoricalFields(JwtSecurityUser securityUser, ViewRequest request) {
        List<ViewField> predictionFields = request.getFields().stream().filter(ViewField::isPredictionModelField).toList();
        Set predictionFieldIdSet = predictionFields.stream().map(ViewField::getEntityFieldId).collect(Collectors.toSet());
        Map wireMap = this.predictionModelDao.findWiredPredictionAndHistoricalFields(securityUser, predictionFieldIdSet);
        HashSet<UUID> visited = new HashSet<UUID>();
        HashMap<UUID, UUID> result = new HashMap<UUID, UUID>();
        for (ViewField predictionField : predictionFields) {
            UUID predictionFieldId = predictionField.getEntityFieldId();
            UUID historicalFieldId = (UUID)wireMap.get(predictionFieldId);
            FieldAggregation aggregationType = predictionField.getAggregationType();
            if (visited.contains(predictionFieldId)) {
                result.remove(predictionFieldId);
                continue;
            }
            visited.add(predictionFieldId);
            List<ViewField> historicalFieldCandidatList = request.getFields().stream().filter(field -> historicalFieldId.equals(field.getEntityFieldId())).filter(field -> aggregationType.equals((Object)field.getAggregationType())).toList();
            if (historicalFieldCandidatList.size() != 1) continue;
            UUID key = predictionField.getId();
            UUID value = historicalFieldCandidatList.iterator().next().getId();
            result.put(key, value);
        }
        return result;
    }

    private void updateNewCalculationField(JwtSecurityUser user, ViewField viewField) {
        if (ViewBuildingServiceImpl.isNewCalculationField((ViewField)viewField)) {
            UUID entityFieldId = viewField.getEntityFieldId();
            if (viewField.isLocalCalculation()) {
                CalculationField calculationField = (CalculationField)this.calculationFieldService.findFieldByEntityFieldId(entityFieldId, user, true).orElseThrow(() -> new BusinessEntityFieldNotFoundException(entityFieldId));
                viewField.setCalcFunction(calculationField.getScript());
                viewField.setScriptLanguage(calculationField.getLanguage());
                switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$calculation$CalculationFieldType[calculationField.getCalculationFieldType().ordinal()]) {
                    case 1: {
                        viewField.setBatchCalculation(true);
                        viewField.setNativeCalculation(false);
                        viewField.setAggregationType(calculationField.getFieldAggregation());
                        break;
                    }
                    case 2: {
                        viewField.setBatchCalculation(false);
                        viewField.setNativeCalculation(true);
                        viewField.setAggregationType(calculationField.getFieldAggregation());
                        break;
                    }
                    case 3: {
                        viewField.setBatchCalculation(false);
                        viewField.setNativeCalculation(false);
                    }
                }
            } else {
                BusinessEntityField entityField = this.businessEntityService.findEntityFieldById(user, entityFieldId);
                UUID businessEntityId = entityField.getBusinessEntityId();
                viewField.setCalculatedField(false);
                viewField.setBusinessEntityId(businessEntityId);
            }
        }
    }

    private static boolean isNewCalculationField(ViewField field) {
        boolean result = field.isCalculatedField();
        result &= !field.isFromTemplateEntityField();
        return result &= Objects.nonNull(field.getEntityFieldId());
    }

    private void preparePredictionModelField(JwtSecurityUser user, ViewField viewField, ViewRequest request) {
        UUID modelId = viewField.getPredictionModelId();
        PredictionModel model = (PredictionModel)this.predictionModelDao.findById(user, modelId, true).orElseThrow(() -> new PredictionModelNotFoundException(modelId));
        boolean enabled = model.isEnabled();
        if (!enabled) {
            throw new BadConfiguredTaskException("Can not run report build with disabled prediction model, name = %s, field = %s".formatted(model.getName(), viewField.getLabel()));
        }
        if (viewField.isUsingPredictionPeriod()) {
            if (viewField.getLocalTimeRange() != null) {
                throw new TrendzException("Can not reset local time range because already set.");
            }
            ChronoUnit predictionPeriodUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)DateAggregationType.getDateGroupingFromPicker((String)viewField.getPredictionPeriodUnit()));
            int predictionPeriodUnitCount = viewField.getPredictionPeriodUnitCount();
            DatePickerConfig datePickerConfig = request.getDatePickerConfig();
            TimeRange requestedTimeRange = datePickerConfig.buildStartEndPair(request.getZoneId(), request.getNowTs());
            ZonedDateTime requestedEndDate = DateTimeUtils.fromTs((long)(requestedTimeRange.getEndTs() + 1L), (ZoneId)request.getZoneId());
            ZonedDateTime extendedEndDate = DateTimeUtils.extendedTruncateTo((ZonedDateTime)requestedEndDate, (ChronoUnit)predictionPeriodUnit).plus(predictionPeriodUnitCount, predictionPeriodUnit);
            TimeRange extendedTimeRange = new TimeRange(requestedTimeRange.getStartTs(), DateTimeUtils.toTs((ZonedDateTime)extendedEndDate) - 1L);
            DatePickerConfig localDatePicker = new DatePickerConfig(extendedTimeRange.getStartTs(), extendedTimeRange.getEndTs(), datePickerConfig.getRangeBy());
            viewField.setLocalTimeRange(localDatePicker);
        }
    }
}

