/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfigSelectType;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.runtime.FieldFilterOption;
import org.thingsboard.trendz.domain.runtime.ViewReport;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;
import org.thingsboard.trendz.service.view.CachedViewService;
import org.thingsboard.trendz.service.view.proto.FillGapSettings;
import org.thingsboard.trendz.tools.json.JsonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CachedViewService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CachedViewService.class);
    @Value(value="${cache.report.enabled}")
    private boolean cachingEnabled;
    @Value(value="${cache.specs.viewReports.maxSize}")
    private int maxCacheSize;
    @Autowired
    private CacheManager cacheManager;
    @Value(value="${cache.report.sessionDurationInMinutes}")
    private long sessionDurationInMinutes;

    public void cacheReport(ViewConfig config, JwtSecurityUser securityUser, ViewReport viewReport) {
        if (!this.cachingEnabled) {
            log.trace("Report caching is disabled, skipping.");
            return;
        }
        if (BooleanUtils.isFalse((Boolean)config.getCacheSettings().getUseReportCache())) {
            log.trace("Report caching is disabled for current config, skipping.");
            return;
        }
        String configKey = this.buildRequestKey(config, securityUser);
        if (configKey == null) {
            return;
        }
        long reportSize = this.getReportSize(viewReport);
        if (reportSize > (long)this.maxCacheSize) {
            log.info("Skip Report save in cache. Size is too big {}", (Object)reportSize);
            return;
        }
        Cache reportCache = this.cacheManager.getCache(CacheConfigurationName.viewReportsCacheName.getValue());
        if (reportCache == null) {
            throw new TrendzInternalException("Report Cache is not initialized.");
        }
        reportCache.put((Object)configKey, (Object)viewReport);
        log.info("Report saved in cache.");
    }

    public Optional<ViewReport> getFromCache(ViewConfig config, JwtSecurityUser securityUser) {
        if (!this.cachingEnabled) {
            log.trace("Report caching is disabled, skipping.");
            return Optional.empty();
        }
        if (BooleanUtils.isFalse((Boolean)config.getCacheSettings().getUseReportCache())) {
            log.trace("Report caching is disabled for current config, skipping.");
            return Optional.empty();
        }
        String configKey = this.buildRequestKey(config, securityUser);
        if (configKey == null) {
            return Optional.empty();
        }
        Cache reportCache = this.cacheManager.getCache(CacheConfigurationName.viewReportsCacheName.getValue());
        if (reportCache == null) {
            throw new TrendzInternalException("Report Cache is not initialized.");
        }
        ViewReport report = (ViewReport)reportCache.get((Object)configKey, ViewReport.class);
        if (report == null) {
            log.debug("Report not found in cache.");
            return Optional.empty();
        }
        return Optional.of(report);
    }

    private String buildRequestKey(ViewConfig config, JwtSecurityUser securityUser) {
        try {
            long cacheTimeMs = System.currentTimeMillis();
            ViewConfig copyConfig = new ViewConfig(config);
            this.absentUselessData(copyConfig);
            long truncatedCacheTimeMs = this.handleTimeRangeSettings(copyConfig, cacheTimeMs);
            UUID tenantId = securityUser.getTenantId();
            UUID customerId = securityUser.getCustomerId();
            UUID userId = securityUser.getUserId();
            ConfigKey configKey = ConfigKey.builder().tenantId(tenantId).customerId(customerId).userId(userId).config(copyConfig).truncatedCacheTime(truncatedCacheTimeMs).build();
            return JsonUtils.toCanonicalJson((Object)configKey);
        }
        catch (Exception ex) {
            log.error("Could not create copy of View Config {} for Report Cache", (Object)config, (Object)ex);
            return null;
        }
    }

    private void absentUselessData(ViewConfig config) {
        config.setCollectionId(null);
        config.setParentPath(null);
        config.setFavorite(false);
        config.setName(null);
        config.setUpdatedAt(0L);
        config.setCacheSettings(null);
        config.setSavingCalculatedTelemetrySettings(null);
        List allFields = config.getAllFields();
        allFields.forEach(viewField -> {
            FillGapSettings fillGapSettings;
            viewField.setLabel(null);
            viewField.setColorConfig(null);
            if (viewField.isStateField() || viewField.isCalculatedField()) {
                viewField.setBusinessEntityId(null);
                viewField.setParsedCondition(null);
                viewField.setConditionFieldIds(null);
            } else {
                viewField.setScriptLanguage(null);
            }
            if (!viewField.isPredictionEnabled()) {
                viewField.setPredictionRangeSec(0);
                viewField.setPredictionMethod(null);
            }
            if ((fillGapSettings = viewField.getFillGapSettings()) != null && !fillGapSettings.isEnableFillGap()) {
                viewField.setFillGapSettings(null);
            }
        });
        config.getRuntimeFilters().forEach(filterField -> {
            filterField.setName(null);
            filterField.setOptions(null);
        });
        Set missedGraphEntities = config.getAllowedEntityIds();
        ArrayNode missedGraphEntitiesNode = (ArrayNode)JsonUtils.getObjectMapper().valueToTree((Object)missedGraphEntities);
        ObjectNode settingsNode = JsonUtils.getObjectMapper().createObjectNode();
        settingsNode.putArray("missedGraphEntities").addAll(missedGraphEntitiesNode);
        config.setSettings((JsonNode)settingsNode);
    }

    private long handleTimeRangeSettings(ViewConfig config, long cacheTimeTs) {
        boolean isRelative;
        long maxSessionTime = TimeUnit.MINUTES.toMillis(this.sessionDurationInMinutes);
        DatePickerConfig picker = config.getDatePickerConfig();
        DatePickerConfigSelectType type = picker.getSelectedType();
        boolean bl = isRelative = type != null && DatePickerConfigSelectType.Value.relative.equals((Object)type.getValue());
        if (isRelative) {
            picker.setStartTs(0L);
            picker.setEndTs(0L);
            return cacheTimeTs / maxSessionTime * maxSessionTime;
        }
        picker.setSelectedType(null);
        picker.setSelectedUnit(null);
        picker.setRelativeUnit(null);
        picker.setRelativeLastAmount(0);
        return 0L;
    }

    private int getReportSize(ViewReport report) {
        int size = 0;
        if (CollectionUtils.isNotEmpty((Collection)report.getRows())) {
            size += report.getRows().size();
        }
        if (CollectionUtils.isNotEmpty((Collection)report.getTimeEvents())) {
            size += report.getTimeEvents().size();
        }
        if (CollectionUtils.isNotEmpty((Collection)report.getFilterOptions())) {
            for (FieldFilterOption filterOption : report.getFilterOptions()) {
                if (!CollectionUtils.isNotEmpty((Collection)filterOption.getOptions())) continue;
                size += filterOption.getOptions().size();
            }
        }
        return size;
    }
}

