/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.topology;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.topology.DiscoverConfig;
import reactor.core.publisher.Flux;

public interface TopologyDiscoveryService {
    public Flux<BusinessEntity> discoverTopology(TaskExecutionProgressStepBuilder var1, DiscoverConfig var2, JwtSecurityUser var3);

    public static <T> List<T> chooseItemsToAnalyse(Set<T> allItems, DiscoverConfig discoverConfig) {
        if (allItems.size() < discoverConfig.getMinItemToAnalyze()) {
            return new ArrayList<T>(allItems);
        }
        ArrayList itemsToAnalyze = Lists.newArrayList();
        int analyzed = 0;
        for (T item : allItems) {
            if (++analyzed % 100 >= discoverConfig.getAnalyzePercent()) continue;
            itemsToAnalyze.add(item);
        }
        return itemsToAnalyze;
    }
}

