/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.topology;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.relation.Direction;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.provider.TbItemService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.task.progress_content.TopologyDiscoveryProgressContent;
import org.thingsboard.trendz.service.topology.DiscoverConfig;
import org.thingsboard.trendz.service.topology.TopologyDiscoveryService;
import reactor.core.publisher.Flux;

@Service
public class TbRelationDiscovery {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbRelationDiscovery.class);
    private final TbRestDataSource apiClient;
    private final TbItemService itemService;

    @Autowired
    public TbRelationDiscovery(TbRestDataSource apiClient, TbItemService itemService) {
        this.apiClient = apiClient;
        this.itemService = itemService;
    }

    public Flux<BusinessEntity> discoverRelations(TopologyDiscoveryProgressContent mutableContent, List<BusinessEntity> businessEntities, DiscoverConfig discoverConfig, JwtSecurityUser user) {
        mutableContent.setCurrentState("Discover relations");
        ConcurrentHashMap relationMap = new ConcurrentHashMap();
        ConcurrentHashMap entityIdToBusiness = new ConcurrentHashMap();
        return Flux.fromIterable(businessEntities).flatMap(businessEntity -> this.itemService.loadItems(businessEntity, null, null, null, user).collect(Collectors.toSet()).flatMap(items -> {
            log.info("Loaded {} items for business entity {}", (Object)items.size(), (Object)businessEntity.getName());
            List itemsToAnalyze = TopologyDiscoveryService.chooseItemsToAnalyse((Set)items, (DiscoverConfig)discoverConfig);
            return Flux.fromIterable((Iterable)itemsToAnalyze).flatMap(item -> this.apiClient.findRelations(item.getId(), businessEntity.getQuery().getEntityType().name(), user, null, Direction.FROM).collectList()).filter(l -> !l.isEmpty()).doOnNext(r -> relationMap.put(((EntityRelation)r.get(0)).getFrom().getId(), r)).collectList().doOnNext(relations -> {
                items.forEach(en -> entityIdToBusiness.put(en.getId(), businessEntity));
                mutableContent.getRelationsDetected().addAndGet(items.size());
            }).map(i -> businessEntity);
        })).doOnNext(businessEntity -> {
            this.mapEntities(relationMap, entityIdToBusiness);
            businessEntities.forEach(arg_0 -> this.clearRedundantRelations(arg_0));
        });
    }

    private void mapEntities(Map<UUID, List<EntityRelation>> relationMap, Map<UUID, BusinessEntity> entityToBusiness) {
        HashMap<UUID, Multimap> mappingEntityToType = new HashMap<UUID, Multimap>();
        HashMap<UUID, Multimap> mappingTypeToEntity = new HashMap<UUID, Multimap>();
        for (UUID entityId : entityToBusiness.keySet()) {
            if (!CollectionUtils.isNotEmpty((Collection)relationMap.get(entityId))) continue;
            for (EntityRelation relation : relationMap.get(entityId)) {
                if (!entityToBusiness.containsKey(relation.getTo().getId())) continue;
                Multimap toType = (Multimap)mappingEntityToType.get(entityId);
                if (toType == null) {
                    toType = HashMultimap.create();
                    mappingEntityToType.put(entityId, toType);
                }
                toType.put((Object)relation.getType(), (Object)entityToBusiness.get(relation.getTo().getId()));
                Multimap toEntity = (Multimap)mappingTypeToEntity.get(entityId);
                if (toEntity == null) {
                    toEntity = HashMultimap.create();
                    mappingTypeToEntity.put(entityId, toEntity);
                }
                toEntity.put((Object)entityToBusiness.get(relation.getTo().getId()), (Object)relation.getType());
            }
        }
        for (UUID businessEntityId : mappingEntityToType.keySet()) {
            BusinessEntity businessEntity = entityToBusiness.get(businessEntityId);
            for (String relationType : ((Multimap)mappingEntityToType.get(businessEntityId)).keySet()) {
                for (BusinessEntity toEntity : ((Multimap)mappingEntityToType.get(businessEntityId)).get((Object)relationType)) {
                    Relation relation = Relation.builder().name(relationType).enabled(true).relatedEntityId(toEntity.getId()).relationType(relationType).direction(Direction.FROM).build();
                    businessEntity.getRelations().add(relation);
                    toEntity.getRelations().add(relation.revert(businessEntity.getId()));
                }
            }
        }
    }

    private void clearRedundantRelations(BusinessEntity entity) {
        if (entity.getRelations() != null) {
            entity.setRelations((List)Lists.newArrayList((Iterable)Sets.newHashSet((Iterable)entity.getRelations())));
            log.info("Discovered {} relations for {} : [{}]", new Object[]{entity.getRelations().size(), entity.getName(), entity.getRelations()});
        } else {
            log.info("Discover process didnt find relations for {}", (Object)entity.getName());
        }
    }
}

