/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.tb.widget;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.tb.widget.base.TbResourceStatus;
import org.thingsboard.trendz.domain.tb.widget.base.UploadTbResourceStatus;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.provider.version.TbVersion;
import org.thingsboard.trendz.service.provider.version.TbVersionChecker;
import org.thingsboard.trendz.service.provider.version.TbVersionNumber;
import org.thingsboard.trendz.service.tb.widget.NativeWidgetBundleService;
import org.thingsboard.trendz.service.tb.widget.NativeWidgetBundleServiceV1;
import org.thingsboard.trendz.service.tb.widget.NativeWidgetBundleServiceV2;
import org.thingsboard.trendz.service.tb.widget.NativeWidgetBundleServiceV3;

@Service
public class NativeWidgetBundleServiceComposite
implements NativeWidgetBundleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NativeWidgetBundleServiceComposite.class);
    public static final TbVersionNumber FIRST_SUPPORTED_VERSION = TbVersionNumber.V_3_3_3;
    public static final TbVersionNumber LAST_SUPPORTED_VERSION = TbVersionNumber.V_4_4_0;
    public static final TbVersionNumber VERSION_NUMBER_1 = TbVersionNumber.V_3_6_0;
    public static final TbVersionNumber VERSION_NUMBER_2 = TbVersionNumber.V_4_3_0;
    private final TbVersionChecker versionChecker;
    private final NativeWidgetBundleServiceV1 serviceV1;
    private final NativeWidgetBundleServiceV2 serviceV2;
    private final NativeWidgetBundleServiceV3 serviceV3;

    @Autowired
    public NativeWidgetBundleServiceComposite(TbVersionChecker versionChecker, NativeWidgetBundleServiceV1 serviceV1, NativeWidgetBundleServiceV2 serviceV2, NativeWidgetBundleServiceV3 serviceV3) {
        this.versionChecker = versionChecker;
        this.serviceV1 = serviceV1;
        this.serviceV2 = serviceV2;
        this.serviceV3 = serviceV3;
    }

    public boolean bundleExists(JwtSecurityUser user) {
        TbVersion version = this.versionChecker.getVersion(user);
        TbVersionNumber versionNumber = version.getVersion();
        if (versionNumber.less(FIRST_SUPPORTED_VERSION) || versionNumber.greater(LAST_SUPPORTED_VERSION)) {
            log.error("Trendz have been detected the unsupported version of the TB - {}", (Object)version);
            throw new RuntimeException("Trendz have been detected the unsupported version of the TB");
        }
        if (versionNumber.inTheInterval(FIRST_SUPPORTED_VERSION, VERSION_NUMBER_1)) {
            return this.serviceV1.bundleExists(user);
        }
        if (versionNumber.inTheInterval(VERSION_NUMBER_1, VERSION_NUMBER_2)) {
            return this.serviceV2.bundleExists(user);
        }
        return this.serviceV3.bundleExists(user);
    }

    public TbResourceStatus getBundleStatus(JwtSecurityUser user, String domain, String externalUrl) {
        TbVersion version = this.versionChecker.getVersion(user);
        TbVersionNumber versionNumber = version.getVersion();
        if (versionNumber.less(FIRST_SUPPORTED_VERSION) || versionNumber.greater(LAST_SUPPORTED_VERSION)) {
            log.error("Trendz have been detected the unsupported version of the TB - {}", (Object)version);
            return TbResourceStatus.NOT_SUPPORTED_TB_VERSION;
        }
        if (versionNumber.inTheInterval(FIRST_SUPPORTED_VERSION, VERSION_NUMBER_1)) {
            return this.serviceV1.getBundleStatus(user, domain, externalUrl);
        }
        if (versionNumber.inTheInterval(VERSION_NUMBER_1, VERSION_NUMBER_2)) {
            return this.serviceV2.getBundleStatus(user, domain, externalUrl);
        }
        return this.serviceV3.getBundleStatus(user, domain, externalUrl);
    }

    public UploadTbResourceStatus uploadNativeWidgetBundle(JwtSecurityUser user, String domain, String externalUrl) {
        TbVersion version = this.versionChecker.getVersion(user);
        TbVersionNumber versionNumber = version.getVersion();
        if (versionNumber.less(FIRST_SUPPORTED_VERSION) || versionNumber.greater(LAST_SUPPORTED_VERSION)) {
            log.error("Trendz have been detected the unsupported version of the TB - {}", (Object)version);
            return UploadTbResourceStatus.NOT_SUPPORTED_TB_VERSION;
        }
        if (versionNumber.inTheInterval(FIRST_SUPPORTED_VERSION, VERSION_NUMBER_1)) {
            return this.serviceV1.uploadNativeWidgetBundle(user, domain, externalUrl);
        }
        if (versionNumber.inTheInterval(VERSION_NUMBER_1, VERSION_NUMBER_2)) {
            return this.serviceV2.uploadNativeWidgetBundle(user, domain, externalUrl);
        }
        return this.serviceV3.uploadNativeWidgetBundle(user, domain, externalUrl);
    }
}

