/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.tb.dashboard.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.tb.dashboard.dto.DashboardEntityAlias;
import org.thingsboard.trendz.domain.tb.dashboard.dto.DashboardWidget;
import org.thingsboard.trendz.domain.tb.dashboard.dto.DashboardWidgetConfig;
import org.thingsboard.trendz.domain.tb.dashboard.dto.DashboardWidgetConfigAction;
import org.thingsboard.trendz.domain.tb.dashboard.dto.DashboardWidgetConfigDatasource;
import org.thingsboard.trendz.domain.tb.dashboard.dto.DashboardWidgetConfigSettings;
import org.thingsboard.trendz.service.provider.version.TbVersion;
import org.thingsboard.trendz.service.provider.version.TbVersionNumber;

public class DashboardWidgetFactory {
    private static final String WIDGET_VIEW_URL = "/viewMode/";

    public static DashboardWidget createBasicTrendzWidget(String trendzUrl, UUID widgetId, UUID viewConfigId, String widgetTypeAlias, String bundleAlias, String widgetName, DashboardEntityAlias dashboardAlias, String filterName, TbVersion version) {
        List datasources;
        String widgetType;
        String bundle = version.getVersion().less(TbVersionNumber.V_3_6_0) ? bundleAlias : null;
        String type = version.getVersion().less(TbVersionNumber.V_3_6_0) ? widgetTypeAlias : null;
        String fqn = version.getVersion().greaterOrEqual(TbVersionNumber.V_4_3_0) ? "system." + widgetTypeAlias : (version.getVersion().greaterOrEqual(TbVersionNumber.V_3_6_1) ? "tenant." + bundleAlias + "." + widgetTypeAlias : (version.getVersion().greaterOrEqual(TbVersionNumber.V_3_6_0) ? "tenant." + widgetTypeAlias : null));
        if (filterName == null) {
            if (version.getVersion().greaterOrEqual(TbVersionNumber.V_4_3_0)) {
                widgetType = "latest";
                datasources = Collections.emptyList();
            } else {
                widgetType = "static";
                datasources = null;
            }
        } else {
            widgetType = "latest";
            datasources = new ArrayList<DashboardWidgetConfigDatasource>(List.of(DashboardWidgetConfigDatasource.getDefault((String)dashboardAlias.getId().toString())));
        }
        return DashboardWidget.builder().id(widgetId.toString()).isSystemType(Boolean.valueOf(false)).type(widgetType).config(DashboardWidgetConfig.builder().title("").showTitle(Boolean.valueOf(false)).settings(DashboardWidgetConfigSettings.builder().viewUrl(trendzUrl + WIDGET_VIEW_URL + String.valueOf(viewConfigId)).filterName(filterName).build()).datasources(datasources).build()).bundleAlias(bundle).typeFullFqn(fqn).typeAlias(type).title(widgetName).build();
    }

    public static DashboardWidget createBasicTableWidget(String entityAliasId, String stateId, String newGeneratedAliasSuffix) {
        return DashboardWidget.builder().id(TimeStampUUIDGenerator.generateId().toString()).title("Basic Table Widget").type("latest").bundleAlias("cards").typeAlias("entities_table").isSystemType(Boolean.valueOf(true)).config(DashboardWidgetConfig.builder().title("Basic Table Widget").showTitle(Boolean.valueOf(true)).settings(DashboardWidgetConfigSettings.getBasicWidgetConfigSettings()).datasources(new ArrayList<DashboardWidgetConfigDatasource>(List.of(DashboardWidgetConfigDatasource.builder().entityAliasId(entityAliasId).type("entity").dataKeys(new ArrayList<DashboardWidgetConfigDatasource.DataKey>(List.of(DashboardWidgetConfigDatasource.DataKey.builder().label("Name").name("name").type("entityField").color("#2196f3").settings(DashboardWidgetConfigDatasource.DataKey.Settings.getDefault()).build()))).build()))).actions(new HashMap<String, ArrayList<DashboardWidgetConfigAction>>(Map.of("rowClick", new ArrayList<DashboardWidgetConfigAction>(List.of(DashboardWidgetConfigAction.builder().id(TimeStampUUIDGenerator.generateId().toString()).targetDashboardStateId(stateId).type("updateDashboardState").stateEntityParamName("SelectedEntity " + newGeneratedAliasSuffix).name("On row click Action").setEntityId(Boolean.valueOf(true)).build()))))).build()).build();
    }
}

