/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.progress_content;

import lombok.Generated;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.service.task.TaskExecutionProgressContent;
import org.thingsboard.trendz.service.task.progress_content.ChatProgressContent;

public class ChatProgressContent
implements TaskExecutionProgressContent {
    private int progressPercent;
    private AiAgentType currentAgent;

    public ChatProgressContent() {
        this.progressPercent = 4;
        this.currentAgent = AiAgentType.MEMORY_MANAGER_EXPERT;
    }

    public void updateContent(AiAgentType currentAgent) {
        this.currentAgent = currentAgent;
        if (currentAgent.getChatType() == null) {
            throw new IllegalArgumentException("Chat progress content cannot be used for non chat-scope agents.");
        }
        this.progressPercent = switch (1.$SwitchMap$org$thingsboard$trendz$domain$chat$ChatType[currentAgent.getChatType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> {
                switch (1.$SwitchMap$org$thingsboard$trendz$domain$assistance$agent$AiAgentType[currentAgent.ordinal()]) {
                    case 1: {
                        yield 10;
                    }
                    case 2: {
                        yield 20;
                    }
                    case 3: 
                    case 4: {
                        yield 36;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        yield 52;
                    }
                    case 9: 
                    case 10: {
                        yield 68;
                    }
                    case 11: 
                    case 12: {
                        yield 84;
                    }
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: {
                        yield 95;
                    }
                    case 21: 
                    case 22: 
                    case 23: {
                        yield 100;
                    }
                }
                throw new IllegalArgumentException("View assistant chat progress content cannot be used for non view assistance chat-scope agents.");
            }
            case 2 -> {
                switch (1.$SwitchMap$org$thingsboard$trendz$domain$assistance$agent$AiAgentType[currentAgent.ordinal()]) {
                    case 24: {
                        yield 15;
                    }
                    case 25: {
                        yield 30;
                    }
                    case 26: {
                        yield Math.min(99, this.progressPercent + 15);
                    }
                    case 27: {
                        yield 100;
                    }
                }
                throw new IllegalArgumentException("Metric code assistant chat progress content cannot be used for non metric code assistance chat-scope agents.");
            }
            case 3 -> throw new IllegalArgumentException("Custom progress content cannot be used for non chat-scope agents.");
        };
    }

    public void complete() {
        this.currentAgent = null;
        this.progressPercent = 100;
    }

    public ChatProgressContent clone() {
        return new ChatProgressContent(this.progressPercent, this.currentAgent);
    }

    @Generated
    public static ChatProgressContentBuilder builder() {
        return new ChatProgressContentBuilder();
    }

    @Generated
    public int getProgressPercent() {
        return this.progressPercent;
    }

    @Generated
    public AiAgentType getCurrentAgent() {
        return this.currentAgent;
    }

    @Generated
    public void setProgressPercent(int progressPercent) {
        this.progressPercent = progressPercent;
    }

    @Generated
    public void setCurrentAgent(AiAgentType currentAgent) {
        this.currentAgent = currentAgent;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatProgressContent)) {
            return false;
        }
        ChatProgressContent other = (ChatProgressContent)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getProgressPercent() != other.getProgressPercent()) {
            return false;
        }
        AiAgentType this$currentAgent = this.getCurrentAgent();
        AiAgentType other$currentAgent = other.getCurrentAgent();
        return !(this$currentAgent == null ? other$currentAgent != null : !this$currentAgent.equals(other$currentAgent));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChatProgressContent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getProgressPercent();
        AiAgentType $currentAgent = this.getCurrentAgent();
        result = result * 59 + ($currentAgent == null ? 43 : $currentAgent.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ChatProgressContent(progressPercent=" + this.getProgressPercent() + ", currentAgent=" + String.valueOf(this.getCurrentAgent()) + ")";
    }

    @Generated
    public ChatProgressContent(int progressPercent, AiAgentType currentAgent) {
        this.progressPercent = progressPercent;
        this.currentAgent = currentAgent;
    }
}

