/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.model;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.task.model.TaskSchedule;
import org.thingsboard.trendz.service.task.model.TaskSequence;
import org.thingsboard.trendz.service.task.model.TaskSequenceConfig;
import org.thingsboard.trendz.service.task.model.TaskSequenceItem;

public class TaskSequenceConfig {
    private UUID id;
    private String name;
    private boolean enabled;
    private TaskSchedule schedule;
    private List<TaskSequenceItem> sequenceItems;

    public TaskSequence makeNew(JwtSecurityUser user) {
        long now = System.currentTimeMillis();
        UUID id = TimeStampUUIDGenerator.generateId();
        return TaskSequence.builder().id(id).user(user).createdTs(now).updatedTs(now).name(this.name).enabled(this.enabled).schedule(this.schedule).sequenceItems(this.sequenceItems == null ? Collections.emptyList() : this.sequenceItems.stream().map(TaskSequenceItem::new).toList()).build();
    }

    public TaskSequence update(TaskSequence previous, long now) {
        return TaskSequence.builder().id(previous.getId()).user(previous.getUser()).createdTs(previous.getCreatedTs()).updatedTs(now).name(this.name).enabled(this.enabled).schedule(this.schedule).sequenceItems(this.sequenceItems == null ? Collections.emptyList() : this.sequenceItems.stream().map(TaskSequenceItem::new).toList()).build();
    }

    @Generated
    public static TaskSequenceConfigBuilder builder() {
        return new TaskSequenceConfigBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public TaskSchedule getSchedule() {
        return this.schedule;
    }

    @Generated
    public List<TaskSequenceItem> getSequenceItems() {
        return this.sequenceItems;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setSchedule(TaskSchedule schedule) {
        this.schedule = schedule;
    }

    @Generated
    public void setSequenceItems(List<TaskSequenceItem> sequenceItems) {
        this.sequenceItems = sequenceItems;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskSequenceConfig)) {
            return false;
        }
        TaskSequenceConfig other = (TaskSequenceConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        TaskSchedule this$schedule = this.getSchedule();
        TaskSchedule other$schedule = other.getSchedule();
        if (this$schedule == null ? other$schedule != null : !this$schedule.equals(other$schedule)) {
            return false;
        }
        List this$sequenceItems = this.getSequenceItems();
        List other$sequenceItems = other.getSequenceItems();
        return !(this$sequenceItems == null ? other$sequenceItems != null : !((Object)this$sequenceItems).equals(other$sequenceItems));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskSequenceConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        TaskSchedule $schedule = this.getSchedule();
        result = result * 59 + ($schedule == null ? 43 : $schedule.hashCode());
        List $sequenceItems = this.getSequenceItems();
        result = result * 59 + ($sequenceItems == null ? 43 : ((Object)$sequenceItems).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TaskSequenceConfig(id=" + String.valueOf(this.getId()) + ", name=" + this.getName() + ", enabled=" + this.isEnabled() + ", schedule=" + String.valueOf(this.getSchedule()) + ", sequenceItems=" + String.valueOf(this.getSequenceItems()) + ")";
    }

    @Generated
    public TaskSequenceConfig() {
    }

    @Generated
    public TaskSequenceConfig(UUID id, String name, boolean enabled, TaskSchedule schedule, List<TaskSequenceItem> sequenceItems) {
        this.id = id;
        this.name = name;
        this.enabled = enabled;
        this.schedule = schedule;
        this.sequenceItems = sequenceItems;
    }
}

