/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.model;

import java.util.UUID;
import lombok.Generated;
import org.thingsboard.trendz.dao.task.TaskState;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.model.TaskExecutionRequest;

public class TaskExecutionRequest {
    private UUID taskId;
    private UUID executionId;
    private boolean scheduled;
    private JwtSecurityUser user;
    private TaskJob job;
    private long createdTs;
    private TaskState state;

    public TaskExecutionRequest(TaskExecutionRequest that) {
        this.taskId = that.taskId;
        this.executionId = that.executionId;
        this.scheduled = that.scheduled;
        this.user = that.user == null ? null : new JwtSecurityUser(that.user);
        this.job = that.job.clone();
        this.createdTs = that.createdTs;
        this.state = that.state;
    }

    @Generated
    public static TaskExecutionRequestBuilder builder() {
        return new TaskExecutionRequestBuilder();
    }

    @Generated
    public UUID getTaskId() {
        return this.taskId;
    }

    @Generated
    public UUID getExecutionId() {
        return this.executionId;
    }

    @Generated
    public boolean isScheduled() {
        return this.scheduled;
    }

    @Generated
    public JwtSecurityUser getUser() {
        return this.user;
    }

    @Generated
    public TaskJob getJob() {
        return this.job;
    }

    @Generated
    public long getCreatedTs() {
        return this.createdTs;
    }

    @Generated
    public TaskState getState() {
        return this.state;
    }

    @Generated
    public void setTaskId(UUID taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setExecutionId(UUID executionId) {
        this.executionId = executionId;
    }

    @Generated
    public void setScheduled(boolean scheduled) {
        this.scheduled = scheduled;
    }

    @Generated
    public void setUser(JwtSecurityUser user) {
        this.user = user;
    }

    @Generated
    public void setJob(TaskJob job) {
        this.job = job;
    }

    @Generated
    public void setCreatedTs(long createdTs) {
        this.createdTs = createdTs;
    }

    @Generated
    public void setState(TaskState state) {
        this.state = state;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskExecutionRequest)) {
            return false;
        }
        TaskExecutionRequest other = (TaskExecutionRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isScheduled() != other.isScheduled()) {
            return false;
        }
        if (this.getCreatedTs() != other.getCreatedTs()) {
            return false;
        }
        UUID this$taskId = this.getTaskId();
        UUID other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId)) {
            return false;
        }
        UUID this$executionId = this.getExecutionId();
        UUID other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !((Object)this$executionId).equals(other$executionId)) {
            return false;
        }
        JwtSecurityUser this$user = this.getUser();
        JwtSecurityUser other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        TaskJob this$job = this.getJob();
        TaskJob other$job = other.getJob();
        if (this$job == null ? other$job != null : !this$job.equals(other$job)) {
            return false;
        }
        TaskState this$state = this.getState();
        TaskState other$state = other.getState();
        return !(this$state == null ? other$state != null : !this$state.equals(other$state));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskExecutionRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isScheduled() ? 79 : 97);
        long $createdTs = this.getCreatedTs();
        result = result * 59 + (int)($createdTs >>> 32 ^ $createdTs);
        UUID $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        UUID $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : ((Object)$executionId).hashCode());
        JwtSecurityUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        TaskJob $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : $job.hashCode());
        TaskState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TaskExecutionRequest(taskId=" + String.valueOf(this.getTaskId()) + ", executionId=" + String.valueOf(this.getExecutionId()) + ", scheduled=" + this.isScheduled() + ", user=" + String.valueOf(this.getUser()) + ", job=" + String.valueOf(this.getJob()) + ", createdTs=" + this.getCreatedTs() + ", state=" + String.valueOf(this.getState()) + ")";
    }

    @Generated
    public TaskExecutionRequest() {
    }

    @Generated
    public TaskExecutionRequest(UUID taskId, UUID executionId, boolean scheduled, JwtSecurityUser user, TaskJob job, long createdTs, TaskState state) {
        this.taskId = taskId;
        this.executionId = executionId;
        this.scheduled = scheduled;
        this.user = user;
        this.job = job;
        this.createdTs = createdTs;
        this.state = state;
    }
}

