/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.task.TaskSequenceDao;
import org.thingsboard.trendz.exception.task.TaskSequenceExecutionException;
import org.thingsboard.trendz.exception.task.TaskSequenceNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.TaskSequenceExecutionJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskExecution;
import org.thingsboard.trendz.service.task.model.TaskExecutionStatus;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskSequence;
import org.thingsboard.trendz.service.task.model.TaskSequenceItem;
import org.thingsboard.trendz.service.task.progress_content.TaskSequenceExecutionJobProgressContent;
import org.thingsboard.trendz.tools.json.JsonUtils;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class TaskSequenceExecutionJobExecutor
implements TaskJobExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskSequenceExecutionJobExecutor.class);
    private final Scheduler threadPoolScheduler;
    private final TaskService taskService;
    private final TaskSequenceDao taskSequenceDao;

    @Autowired
    public TaskSequenceExecutionJobExecutor(ExecutorManagementService executorManagementService, TaskService taskService, TaskSequenceDao taskSequenceDao) {
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.TASK_SEQUENCE_EXECUTION_SCHEDULING);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"task sequence execution scheduler");
        this.taskService = taskService;
        this.taskSequenceDao = taskSequenceDao;
    }

    public TaskJobType getJobType() {
        return TaskJobType.TASK_SEQUENCE_EXECUTION;
    }

    public Class<TaskSequenceExecutionJob> getJobClass() {
        return TaskSequenceExecutionJob.class;
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Class<TaskSequenceExecutionJobProgressContent> getProgressContentClass() {
        return TaskSequenceExecutionJobProgressContent.class;
    }

    public TaskSequenceExecutionJobProgressContent createProgressContent() {
        return new TaskSequenceExecutionJobProgressContent();
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        TaskSequenceExecutionJob job = (TaskSequenceExecutionJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        TaskSequenceExecutionJobProgressContent stepContent = (TaskSequenceExecutionJobProgressContent)progressBuilder.getStepContent(TaskSequenceExecutionJobProgressContent.class);
        UUID sequenceId = job.getSequenceId();
        TaskSequence taskSequence = (TaskSequence)this.taskSequenceDao.findTaskSequenceById(user, sequenceId).orElseThrow(() -> new TaskSequenceNotFoundException(sequenceId));
        List items = taskSequence.getSequenceItems();
        stepContent.setTotalTasks(items.size());
        stepContent.setInitialized(true);
        int counter = 1;
        for (TaskSequenceItem item : items) {
            TaskReference reference = item.getReference();
            Task task = (Task)this.taskService.findTaskByReferencedEntity(user, reference).orElseThrow();
            String stepTitle = "Task %s/%s - %s".formatted(counter, items.size(), task.getName());
            try {
                TaskExecutionProgressStepBuilder step = progressBuilder.makeStep(stepTitle);
                try {
                    log.debug("Awaiting delay before task execution ({} ms)...", (Object)item.getExecutionDelayMs());
                    TimeUnit.MILLISECONDS.sleep(item.getExecutionDelayMs());
                    UUID executionId = this.taskService.runExecution(user, task.getId(), false);
                    TaskExecution taskExecution = this.taskService.awaitExecution(user, executionId);
                    TaskExecutionStatus status = taskExecution.getStatus();
                    if (status != TaskExecutionStatus.FINISHED) {
                        String lastElementAsString;
                        String jsonResult = taskExecution.getJsonResult();
                        JsonNode jsonResultNode = JsonUtils.toNodeFromRaw((String)jsonResult);
                        if (jsonResultNode != null && jsonResultNode.isArray() && !jsonResultNode.isEmpty()) {
                            int lastIndex = jsonResultNode.size() - 1;
                            JsonNode lastElement = jsonResultNode.get(lastIndex);
                            lastElementAsString = lastElement.toString();
                        } else {
                            lastElementAsString = jsonResult;
                        }
                        String message = "Task execution failed, id = %s, reason = %s".formatted(executionId, lastElementAsString);
                        throw new TaskSequenceExecutionException((Throwable)new RuntimeException(message));
                    }
                    stepContent.setFinishedTasks(counter++);
                }
                finally {
                    if (step == null) continue;
                    step.close();
                }
            }
            catch (Exception e) {
                throw new TaskSequenceExecutionException((Throwable)e);
            }
        }
        return Mono.just((Object)"Finished!");
    }
}

