/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import com.google.common.collect.Sets;
import java.time.ZoneId;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.model.prediction.PredictionModelLastItemPointDao;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.base.TimeSeries;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.exception.model.prediction.PredictionModelException;
import org.thingsboard.trendz.exception.model.prediction.PredictionModelNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.model.prediction.PredictionModel;
import org.thingsboard.trendz.service.model.prediction.PredictionModelDatasourceParameters;
import org.thingsboard.trendz.service.model.prediction.PredictionModelService;
import org.thingsboard.trendz.service.model.prediction.PredictionModelStatus;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.PredictionModelRefreshJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class PredictionModelRefreshJobExecutor
implements TaskJobExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PredictionModelRefreshJobExecutor.class);
    private final Scheduler threadPoolScheduler;
    private final PredictionModelService predictionModelService;
    private final PredictionModelLastItemPointDao predictionModelLastItemPointDao;

    @Autowired
    public PredictionModelRefreshJobExecutor(ExecutorManagementService executorManagementService, PredictionModelService predictionModelService, PredictionModelLastItemPointDao predictionModelLastItemPointDao) {
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.BACKGROUND_TASK);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"prediction model refresh scheduler");
        this.predictionModelService = predictionModelService;
        this.predictionModelLastItemPointDao = predictionModelLastItemPointDao;
    }

    public TaskJobType getJobType() {
        return TaskJobType.PREDICTION_MODEL_REFRESH;
    }

    public Class<PredictionModelRefreshJob> getJobClass() {
        return PredictionModelRefreshJob.class;
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        PredictionModelRefreshJob job = (PredictionModelRefreshJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        long now = System.currentTimeMillis();
        UUID modelId = job.getPredictionModelId();
        PredictionModel model = (PredictionModel)this.predictionModelService.findById(user, modelId).orElseThrow(() -> new PredictionModelNotFoundException(modelId));
        if (model.getStatus() != PredictionModelStatus.READY) {
            return Mono.error((Throwable)new PredictionModelException("Model is not trained!"));
        }
        PredictionModelDatasourceParameters dsParameters = model.getDatasourceParameters();
        ZoneId zoneId = ZoneId.of(dsParameters.getTzName());
        boolean enabledPartialFit = job.isEnabledPartialFit();
        Set selectedItemSet = job.getItemSet().isEmpty() ? model.getTrainedItemsSet() : Sets.intersection((Set)model.getTrainedItemsSet(), (Set)job.getItemSet());
        Map itemToLastestUsedPointMap = this.predictionModelLastItemPointDao.getItemToLastPointMap(modelId);
        return this.predictionModelService.loadLatestTelemetry(user, model, selectedItemSet).flatMapMany(itemToLatestPresentPointMap -> Flux.fromIterable((Iterable)selectedItemSet).filter(item -> {
            if (!itemToLatestPresentPointMap.containsKey(item.getId())) {
                log.warn("Impossible to process item {} for prediction model {}: latest present point was not found", (Object)item.getId(), (Object)modelId);
                return false;
            }
            if (!itemToLastestUsedPointMap.containsKey(item.getId())) {
                log.warn("Impossible to process item {} for prediction model {}: latest used point was not found", (Object)item.getId(), (Object)modelId);
                return false;
            }
            return true;
        }).flatMap(item -> {
            AtomicLong latestUsedTs = new AtomicLong((Long)itemToLastestUsedPointMap.get(item.getId()));
            long latestPresentTs = (Long)itemToLatestPresentPointMap.get(item.getId());
            return Mono.just((Object)new Object()).flatMap(o -> {
                TimeRange partialFitRange = this.predictionModelService.defineRangePartialFit(model, latestUsedTs.get(), latestPresentTs, now);
                log.debug("Partial fit range: {}", (Object)partialFitRange.toString(zoneId));
                if (partialFitRange.duration().isZero()) {
                    return Mono.just((Object)"The partial fit is skipped because the time range has zero duration.");
                }
                if (partialFitRange.duration().isNegative()) {
                    return Mono.error((Throwable)new PredictionModelException("The prediction range has invalid duration"));
                }
                return this.doPartialFit(enabledPartialFit, user, model, item, latestUsedTs, partialFitRange);
            }).flatMap(partialFitMessage -> {
                TimeRange predictionRange = this.predictionModelService.defineRangePrediction(model, latestUsedTs.get(), latestPresentTs, now);
                log.debug("Prediction range: {}", (Object)predictionRange.toString(zoneId));
                return this.doRefresh(user, model, item, predictionRange).map(refreshMessage -> Triple.of((Object)item, (Object)partialFitMessage, (Object)refreshMessage));
            }).doOnNext(o -> itemToLastestUsedPointMap.put(item.getId(), latestUsedTs.get()));
        })).collectList().doOnNext(o -> this.predictionModelLastItemPointDao.saveItemToLastPointMap(modelId, itemToLastestUsedPointMap)).map(resultMessageSet -> {
            Map<ItemLite, String> itemToPartialFitMessageMap = resultMessageSet.stream().collect(Collectors.toMap(Triple::getLeft, Triple::getMiddle));
            Map<ItemLite, String> itemToRefreshMessageMap = resultMessageSet.stream().collect(Collectors.toMap(Triple::getLeft, Triple::getRight));
            StringBuilder builder = new StringBuilder();
            builder.append("The prediction model refresh job is finished.\n");
            for (ItemLite item : selectedItemSet) {
                String partialFitMessage = itemToPartialFitMessageMap.get(item);
                String refreshMessage = itemToRefreshMessageMap.get(item);
                builder.append("Item: %s - %s. Partial fit: %s, Refresh: %s \n".formatted(item.getId(), item.getName(), partialFitMessage, refreshMessage));
            }
            return builder.toString();
        });
    }

    private Mono<String> doPartialFit(boolean enabledPartialFit, JwtSecurityUser user, PredictionModel model, ItemLite item, AtomicLong latestTs, TimeRange partialFitRange) {
        if (!enabledPartialFit) {
            return Mono.just((Object)"The partial fit is disabled");
        }
        PredictionModelDatasourceParameters dsParameters = model.getDatasourceParameters();
        ZoneId zoneId = ZoneId.of(dsParameters.getTzName());
        return this.predictionModelService.partialFitModel(user, model, item, partialFitRange).flatMap(partialFitResult -> {
            if (partialFitResult.isFitted()) {
                latestTs.set(partialFitResult.getLatestUsedTs());
                TimeSeries historicalTelemetry = partialFitResult.getPreparedData().getHistoricalTelemetry();
                String tbKey = PredictionModelService.createTbKey((String)model.getTbTelemetryKey());
                UUID businessEntityId = dsParameters.getBusinessEntityId();
                return this.predictionModelService.sendTelemetryToTb(user, businessEntityId, tbKey, item, historicalTelemetry).map(o -> partialFitResult.getMessage());
            }
            return Mono.just((Object)partialFitResult.getMessage());
        });
    }

    private Mono<String> doRefresh(JwtSecurityUser user, PredictionModel model, ItemLite item, TimeRange predictionRange) {
        PredictionModelDatasourceParameters dsParameters = model.getDatasourceParameters();
        ZoneId zoneId = ZoneId.of(dsParameters.getTzName());
        return this.predictionModelService.makePrediction(user, model, item, predictionRange).flatMap(prediction -> {
            String tbKey = PredictionModelService.createTbKey((String)model.getTbTelemetryKey());
            UUID businessEntityId = dsParameters.getBusinessEntityId();
            return this.predictionModelService.sendTelemetryToTb(user, businessEntityId, tbKey, item, prediction).map(o2 -> "The prediction was created and sent successfully, info = %s".formatted(prediction.toString(zoneId)));
        });
    }
}

