/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.chat.ChatContext;
import org.thingsboard.trendz.domain.chat.ChatLite;
import org.thingsboard.trendz.domain.chat.ChatMessage;
import org.thingsboard.trendz.domain.chat.ChatRequest;
import org.thingsboard.trendz.domain.chat.ChatType;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.token.TokenUsageService;
import org.thingsboard.trendz.service.chat.ChatMessageProcessor;
import org.thingsboard.trendz.service.chat.ChatService;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.ChatAssistance;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.service.task.progress_content.ChatProgressContent;
import org.thingsboard.trendz.tools.DateTimeUtils;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class ChatAssistanceJobExecutor
implements TaskJobExecutor {
    private final Scheduler threadPoolScheduler;
    private final ChatService chatService;
    private final TokenUsageService tokenUsageService;
    private final Map<ChatType, ChatMessageProcessor<?>> messageProcessorMap;

    @Autowired
    public ChatAssistanceJobExecutor(ExecutorManagementService executorManagementService, ChatService chatService, TokenUsageService tokenUsageService, List<ChatMessageProcessor<?>> messageProcessors) {
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.AI_PROCESSOR);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"chat assistance process scheduler");
        this.chatService = chatService;
        this.tokenUsageService = tokenUsageService;
        this.messageProcessorMap = messageProcessors.stream().collect(Collectors.toMap(ChatMessageProcessor::getChatType, Function.identity()));
    }

    public TaskJobType getJobType() {
        return TaskJobType.CHAT_ASSISTANCE;
    }

    public Class<ChatAssistance> getJobClass() {
        return ChatAssistance.class;
    }

    public ChatProgressContent createProgressContent() {
        return new ChatProgressContent();
    }

    public Class<ChatProgressContent> getProgressContentClass() {
        return ChatProgressContent.class;
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressStepBuilder) {
        ChatAssistance job = (ChatAssistance)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        ChatLite chatLite = this.chatService.getChatLite(job.getChatRequest().getChatId(), user);
        this.tokenUsageService.checkTokenUsage(user, chatLite.getType());
        return this.doWork(progressStepBuilder, (ChatMessageProcessor)this.messageProcessorMap.get(chatLite.getType()), job.getChatRequest(), chatLite, user, progressStepBuilder);
    }

    private <T extends ChatContext> Mono<?> doWork(TaskExecutionProgressStepBuilder stepBuilder, ChatMessageProcessor<T> chatMessageProcessor, ChatRequest chatRequest, ChatLite chatLite, JwtSecurityUser user, TaskExecutionProgressStepBuilder progressStepBuilder) {
        ChatContext chatContext = chatMessageProcessor.createNewContext(chatRequest, user);
        ChatMessage chatMessage = this.chatService.getChatMessage(chatRequest.getChatId(), chatRequest.getMessageId(), user);
        List history = this.chatService.getAllChatMessageLite(chatLite.getId(), user);
        chatContext.setUser(user);
        chatContext.setQuestion(chatMessage.getUserQuestion());
        chatContext.setProgressContent((ChatProgressContent)progressStepBuilder.getMutableContent());
        chatContext.setStepBuilder(progressStepBuilder);
        chatContext.setAgentMetadataContainer(Collections.synchronizedList(new ArrayList()));
        chatContext.setChatSummary(chatLite.getChatSummary());
        chatContext.setZoneId(DateTimeUtils.fromTzName((String)chatRequest.getTzName()));
        chatContext.setHistory(history);
        chatContext.setDomain(chatRequest.getDomain());
        chatContext.setChatLite(chatLite);
        chatContext.setChatMessage(chatMessage);
        return chatMessageProcessor.processChatRequest(stepBuilder, chatContext);
    }
}

