/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.anomaly.AnomalyAlarmConfig;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelStatus;
import org.thingsboard.trendz.domain.anomaly.AnomalyPersistenceReport;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.model.anomaly.AnomalyAlarmService;
import org.thingsboard.trendz.service.model.anomaly.AnomalyModelBuildService;
import org.thingsboard.trendz.service.model.anomaly.AnomalyModelService;
import org.thingsboard.trendz.service.model.anomaly.AnomalyService;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.AnomalyModelBuildJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class AnomalyModelBuildJobExecutor
implements TaskJobExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnomalyModelBuildJobExecutor.class);
    private final Scheduler threadPoolScheduler;
    private final AnomalyService anomalyService;
    private final AnomalyAlarmService anomalyAlarmService;
    private final AnomalyModelService anomalyModelService;
    private final AnomalyModelBuildService anomalyModelBuildService;

    @Autowired
    public AnomalyModelBuildJobExecutor(ExecutorManagementService executorManagementService, AnomalyService anomalyService, AnomalyAlarmService anomalyAlarmService, AnomalyModelService anomalyModelService, AnomalyModelBuildService anomalyModelBuildService) {
        this.anomalyService = anomalyService;
        this.anomalyAlarmService = anomalyAlarmService;
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.ANOMLALY_PROCESSOR);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"anomaly model build scheduler");
        this.anomalyModelService = anomalyModelService;
        this.anomalyModelBuildService = anomalyModelBuildService;
    }

    public TaskJobType getJobType() {
        return TaskJobType.ANOMALY_MODEL_BUILD;
    }

    public Class<AnomalyModelBuildJob> getJobClass() {
        return AnomalyModelBuildJob.class;
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        AnomalyModelBuildJob job = (AnomalyModelBuildJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        AnomalyModel anomalyModel = this.anomalyModelService.getModelByIdOrThrow(user, job.getModelId());
        this.anomalyModelService.validate(anomalyModel);
        return this.anomalyModelBuildService.buildModel(user, anomalyModel).flatMap(clusterReport -> {
            job.setItemIdLastSegmentMap(clusterReport.getEndOfTheLastSegmentPerItem());
            AnomalyAlarmConfig anomalyAlarmConfig = AnomalyAlarmConfig.defaultAlertConfig((double)anomalyModel.getProperties().getAnomalyExtractProperties().getThresholdScore());
            anomalyModel.setAnomalyAlarmConfig(anomalyAlarmConfig);
            this.anomalyModelService.saveModel(user, anomalyModel, false, false);
            AnomalyPersistenceReport anomalyPersistenceReport = this.anomalyService.rewriteAll(anomalyModel.getId(), clusterReport.getAnomalies());
            return this.anomalyAlarmService.clearOrDeleteAlarmsFrom(user, anomalyPersistenceReport.getDeletedAnomalies(), anomalyModel.isEnabledAlarmDeletion());
        });
    }

    public void doOnCancel(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        AnomalyModelBuildJob job = (AnomalyModelBuildJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        AnomalyModel anomalyModel = this.anomalyModelService.getModelByIdOrThrow(user, job.getModelId());
        anomalyModel.setStatus(AnomalyModelStatus.CANCELED);
        anomalyModel.setAnomalyAlarmConfig(null);
        this.anomalyModelService.saveModel(user, anomalyModel, false, true);
    }

    public void doOnError(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder rootStepBuilder) {
        AnomalyModelBuildJob job = (AnomalyModelBuildJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        AnomalyModel anomalyModel = this.anomalyModelService.getModelByIdOrThrow(user, job.getModelId());
        anomalyModel.setStatus(AnomalyModelStatus.FAILED);
        anomalyModel.setAnomalyAlarmConfig(null);
        this.anomalyModelService.saveModel(user, anomalyModel, false, true);
    }
}

