/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.task.TaskSequenceDao;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.exception.task.TaskSequenceNotFoundException;
import org.thingsboard.trendz.exception.task.TaskSequenceNullIdException;
import org.thingsboard.trendz.exception.task.TaskSequenceValidationException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskManagementService;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.TaskSequenceExecutionJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskConfig;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.service.task.model.TaskSequence;
import org.thingsboard.trendz.service.task.model.TaskSequenceConfig;
import org.thingsboard.trendz.service.task.model.TaskSequenceFilteringField;
import org.thingsboard.trendz.service.task.model.TaskSequenceItem;
import org.thingsboard.trendz.service.task.model.TaskSequenceSortingField;

@Service
public class TaskSequenceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskSequenceService.class);
    private final TaskService taskService;
    private final TaskManagementService taskManagementService;
    private final TaskSequenceDao taskSequenceDao;

    @Autowired
    public TaskSequenceService(TaskService taskService, TaskManagementService taskManagementService, TaskSequenceDao taskSequenceDao) {
        this.taskService = taskService;
        this.taskManagementService = taskManagementService;
        this.taskSequenceDao = taskSequenceDao;
    }

    public List<TaskSequence> exportAll(JwtSecurityUser user) {
        return this.taskSequenceDao.exportAll(user);
    }

    public List<TaskSequence> importAll(JwtSecurityUser user, List<TaskSequence> taskSequences) {
        List saved = this.taskSequenceDao.importAll(taskSequences);
        for (TaskSequence sequence : saved) {
            this.createTask(user, sequence);
        }
        return saved;
    }

    public Page<TaskSequence> getAllTaskSequences(JwtSecurityUser user, int page, int pageSize, List<TaskSequenceFilteringField> filteringFields, List<TaskSequenceSortingField> sortingFields) {
        return this.taskSequenceDao.findAllTaskSequences(user, page, pageSize, filteringFields, sortingFields);
    }

    public Optional<TaskSequence> findTaskSequenceById(JwtSecurityUser user, UUID id) {
        return this.findTaskSequenceById(user, id, false);
    }

    public Optional<TaskSequence> findTaskSequenceById(JwtSecurityUser user, UUID id, boolean insecure) {
        if (id == null) {
            throw new TaskSequenceNullIdException();
        }
        return this.taskSequenceDao.findTaskSequenceById(user, id, insecure);
    }

    public TaskSequence saveTaskSequence(JwtSecurityUser user, TaskSequenceConfig config) {
        TaskSequence entity;
        Set presentTasks;
        long now = System.currentTimeMillis();
        UUID id = config.getId();
        boolean duplicatesPresent = config.getSequenceItems().stream().map(TaskSequenceItem::getOrderNumber).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).values().stream().anyMatch(count -> count > 1L);
        if (duplicatesPresent) {
            throw new TaskSequenceValidationException("Order numbers has duplicates");
        }
        Set taskReferenceSet = config.getSequenceItems().stream().map(TaskSequenceItem::getReference).collect(Collectors.toSet());
        if (!taskReferenceSet.isEmpty() && (presentTasks = this.taskSequenceDao.checkTaskExistence(user, taskReferenceSet)).size() != taskReferenceSet.size()) {
            Sets.SetView absentTasks = Sets.difference(taskReferenceSet, (Set)presentTasks);
            throw new TaskNotFoundException((Set)absentTasks);
        }
        if (id == null) {
            entity = config.makeNew(user);
        } else {
            TaskSequence taskSequence = (TaskSequence)this.findTaskSequenceById(user, id).orElseThrow(() -> new TaskSequenceNotFoundException(id));
            entity = config.update(taskSequence, now);
        }
        this.createTask(user, entity);
        return this.taskSequenceDao.saveSequence(entity);
    }

    public void deleteTaskSequence(JwtSecurityUser user, UUID id) {
        if (id == null) {
            throw new TaskSequenceNullIdException();
        }
        TaskSequence taskSequence = (TaskSequence)this.findTaskSequenceById(user, id).orElseThrow(() -> new TaskSequenceNotFoundException(id));
        this.taskSequenceDao.deleteSequence(taskSequence.getId());
        this.taskManagementService.deleteByTaskReference(user, new TaskReference(TaskReferencedEntityType.TASK_SEQUENCE_EXECUTION, id.toString()));
    }

    public UUID runSequence(JwtSecurityUser user, UUID id) {
        TaskReference reference = new TaskReference(TaskReferencedEntityType.TASK_SEQUENCE_EXECUTION, id.toString());
        Task task = (Task)this.taskService.findTaskByReferencedEntity(user, reference).orElseThrow(() -> new TaskNotFoundException(reference));
        TaskSequenceExecutionJob job = new TaskSequenceExecutionJob(id);
        return this.taskService.runExecution(user, task.getId(), (TaskJob)job, false);
    }

    private void createTask(JwtSecurityUser user, TaskSequence entity) {
        TaskReference reference = new TaskReference(TaskReferencedEntityType.TASK_SEQUENCE_EXECUTION, entity.getId().toString());
        TaskSequenceExecutionJob taskJob = new TaskSequenceExecutionJob(entity.getId());
        String taskName = "Task Sequence Execution: " + entity.getName();
        Consumer<TaskConfig> onAny = taskConfig -> {
            taskConfig.setEnabled(Boolean.valueOf(entity.isEnabled()));
            taskConfig.setSchedule(entity.getSchedule());
        };
        this.taskManagementService.createOrUpdateTask(user, reference, taskName, (TaskJob)taskJob, onAny);
    }
}

