/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskConfig;
import org.thingsboard.trendz.service.task.model.TaskReference;

@Service
public class TaskManagementService {
    private final TaskService taskService;

    @Autowired
    public TaskManagementService(TaskService taskService) {
        this.taskService = taskService;
    }

    public void deleteByTaskReference(JwtSecurityUser user, TaskReference taskReference) {
        this.taskService.findTaskByReferencedEntity(user, taskReference).ifPresent(task -> this.taskService.deleteTask(user, task.getId()));
    }

    public Task createOrUpdateTask(JwtSecurityUser user, TaskReference taskReference, String name, TaskJob onCreateTaskJob) {
        Consumer<TaskConfig> doNothing = taskConfig -> {};
        return this.createOrUpdateTask(user, taskReference, name, onCreateTaskJob, doNothing);
    }

    public Task createOrUpdateTask(JwtSecurityUser user, TaskReference taskReference, String name, TaskJob onCreateTaskJob, Consumer<TaskConfig> onAny) {
        Consumer<TaskConfig> doNothingConsumer = taskConfig -> {};
        BiConsumer<Task, TaskConfig> doNothingBiConsumer = (task, taskConfig) -> {};
        return this.createOrUpdateTask(user, taskReference, name, onCreateTaskJob, onAny, doNothingBiConsumer, doNothingConsumer);
    }

    public Task createOrUpdateTask(JwtSecurityUser user, TaskReference taskReference, String name, TaskJob onCreateTaskJob, Consumer<TaskConfig> onAny, BiConsumer<Task, TaskConfig> onUpdate, Consumer<TaskConfig> onCreate) {
        TaskConfig taskConfig = TaskConfig.builder().name(name).reference(taskReference).build();
        onAny.accept(taskConfig);
        return this.taskService.findTaskByReferencedEntity(user, taskReference).map(task -> {
            taskConfig.setId(task.getId());
            taskConfig.setJob(task.getJob());
            taskConfig.setSchedule(task.getSchedule());
            taskConfig.setRetryPolicy(task.getRetryPolicy());
            taskConfig.setTtlConfig(task.getTtlConfig());
            taskConfig.setStoreExecutionConfig(task.getStoreExecutionConfig());
            taskConfig.setTimeoutConfig(task.getTimeoutConfig());
            taskConfig.setEnabled(Boolean.valueOf(task.isEnabled()));
            onUpdate.accept((Task)task, taskConfig);
            return this.taskService.updateTask(user, taskConfig);
        }).orElseGet(() -> {
            taskConfig.setJob(onCreateTaskJob);
            onCreate.accept(taskConfig);
            return this.taskService.createTask(user, taskConfig);
        });
    }
}

