/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task;

import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.customprompt.CustomPromptService;
import org.thingsboard.trendz.service.customize.UserManagementService;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;
import org.thingsboard.trendz.service.provider.cache.CacheService;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.AlarmRequestJob;
import org.thingsboard.trendz.service.task.job.CustomPromptJob;
import org.thingsboard.trendz.service.task.job.FilterRequestJob;
import org.thingsboard.trendz.service.task.job.MigrationImportJob;
import org.thingsboard.trendz.service.task.job.TestCalculationFieldJob;
import org.thingsboard.trendz.service.task.job.TopologyDiscoveryJob;
import org.thingsboard.trendz.service.task.job.ViewAiSummaryJob;
import org.thingsboard.trendz.service.task.job.ViewReportBuildJob;
import org.thingsboard.trendz.service.task.job.metric.MetricDefinitionGenerateJob;
import org.thingsboard.trendz.service.task.job.metric.MetricDefinitionImplementationJob;
import org.thingsboard.trendz.service.task.model.TaskConfig;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.service.task.model.TaskStoreExecutionConfig;
import org.thingsboard.trendz.service.task.model.TaskTtlConfig;

@Service
public class TaskInitializationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskInitializationService.class);
    private final TaskService taskService;
    private final UserManagementService userManagementService;
    private final Cache initializationCache;
    private final CustomPromptService customPromptService;

    @Autowired
    public TaskInitializationService(TaskService taskService, UserManagementService userManagementService, CacheService cacheService, CustomPromptService customPromptService) {
        this.taskService = taskService;
        this.userManagementService = userManagementService;
        this.initializationCache = cacheService.getCache(CacheConfigurationName.userTaskInitializationCacheName);
        this.customPromptService = customPromptService;
    }

    public void proceedInitialization(JwtSecurityUser user) {
        this.initializationCache.get((Object)user, () -> {
            this.initializeMigrationImportTask(user);
            this.initializeTopologyDiscoveryTask(user);
            this.initializeAlarmTask(user);
            this.initializeUnsavedViewReportBuild(user);
            this.initializeUnsavedAiSummaryTask(user);
            this.initializeUnsavedFilterRequest(user);
            this.initializeUnsavedCalculationFieldTest(user);
            this.initializeSystemPromptExecutions(user);
            this.initializeTextPromptExecution(user);
            this.initializeMetricDefinitionGenerate(user);
            this.initializeMetricDefinitionImplement(user);
            return true;
        });
    }

    private void initializeTask(JwtSecurityUser user, TaskJob emptyTaskJob, TaskReference taskReference, String taskName) {
        this.initializeTask(user, emptyTaskJob, taskReference, taskName, taskConfig -> {});
    }

    private void initializeTask(JwtSecurityUser user, TaskJob emptyTaskJob, TaskReference taskReference, String taskName, Consumer<TaskConfig> taskConfigConsumer) {
        this.taskService.findTaskByReferencedEntity(user, taskReference, true).orElseGet(() -> {
            TaskConfig taskConfig = TaskConfig.builder().reference(taskReference).name(taskName).job(emptyTaskJob).build();
            taskConfigConsumer.accept(taskConfig);
            return this.taskService.createTask(user, taskConfig);
        });
    }

    private void initializeMigrationImportTask(JwtSecurityUser user) {
        String taskName = "Migration, import: " + this.getTenantTitle(user);
        MigrationImportJob emptyTaskJob = new MigrationImportJob();
        TaskReference taskReference = new TaskReference(TaskReferencedEntityType.MIGRATION_IMPORT, user.getTenantId().toString());
        Consumer<TaskConfig> taskConfigConsumer = taskConfig -> taskConfig.setStoreExecutionConfig(TaskStoreExecutionConfig.builder().enabled(true).count(1).build());
        this.initializeTask(user, (TaskJob)emptyTaskJob, taskReference, taskName, taskConfigConsumer);
    }

    private void initializeTopologyDiscoveryTask(JwtSecurityUser user) {
        String taskName = "Topology discovery: " + this.getTenantTitle(user);
        TopologyDiscoveryJob emptyTaskJob = new TopologyDiscoveryJob();
        TaskReference taskReference = new TaskReference(TaskReferencedEntityType.TOPOLOGY_DISCOVERY, user.getTenantId().toString());
        this.initializeTask(user, (TaskJob)emptyTaskJob, taskReference, taskName);
    }

    private void initializeAlarmTask(JwtSecurityUser user) {
        String taskName = "Alarm report: " + this.getUserTitle(user);
        AlarmRequestJob emptyTaskJob = new AlarmRequestJob();
        TaskReference taskReference = new TaskReference(TaskReferencedEntityType.ALARM_REQUEST, user.getTenantCustomerKey());
        this.initializeTask(user, (TaskJob)emptyTaskJob, taskReference, taskName);
    }

    private void initializeUnsavedViewReportBuild(JwtSecurityUser user) {
        String taskName = "Unsaved View Report Build Job: " + this.getUserTitle(user);
        ViewReportBuildJob emptyTaskJob = new ViewReportBuildJob();
        TaskReference taskReference = new TaskReference(TaskReferencedEntityType.VIEW_CONFIG_BUILD_VIEW, user.getTenantCustomerKey());
        this.initializeTask(user, (TaskJob)emptyTaskJob, taskReference, taskName);
    }

    private void initializeUnsavedAiSummaryTask(JwtSecurityUser user) {
        String taskName = "Unsaved View AI Summary Job: " + this.getUserTitle(user);
        ViewAiSummaryJob emptyTaskJob = new ViewAiSummaryJob();
        TaskReference taskReference = new TaskReference(TaskReferencedEntityType.VIEW_CONFIG_AI_SUMMARY_TASK, user.getTenantCustomerKey());
        this.initializeTask(user, (TaskJob)emptyTaskJob, taskReference, taskName);
    }

    private void initializeUnsavedFilterRequest(JwtSecurityUser user) {
        String taskName = "Unsaved Filter Request Job: " + this.getUserTitle(user);
        FilterRequestJob emptyTaskJob = new FilterRequestJob();
        TaskReference taskReference = new TaskReference(TaskReferencedEntityType.VIEW_CONFIG_FILTER_REQUEST, user.getTenantCustomerKey());
        Consumer<TaskConfig> taskConfigConsumer = taskConfig -> taskConfig.setTtlConfig(new TaskTtlConfig(true, 60000L));
        this.initializeTask(user, (TaskJob)emptyTaskJob, taskReference, taskName, taskConfigConsumer);
    }

    private void initializeUnsavedCalculationFieldTest(JwtSecurityUser user) {
        String taskName = "Unsaved Calculation Field Test Job: " + this.getUserTitle(user);
        TestCalculationFieldJob emptyTaskJob = new TestCalculationFieldJob();
        TaskReference taskReference = new TaskReference(TaskReferencedEntityType.CALCULATION_FIELD_TEST, user.getTenantCustomerKey());
        this.initializeTask(user, (TaskJob)emptyTaskJob, taskReference, taskName);
    }

    private void initializeMetricDefinitionGenerate(JwtSecurityUser user) {
        String taskName = "Metric Generation Job: " + this.getUserTitle(user);
        MetricDefinitionGenerateJob emptyTaskJob = new MetricDefinitionGenerateJob();
        TaskReference taskReference = new TaskReference(TaskReferencedEntityType.METRIC_DEFINITION_GENERATE, user.getTenantCustomerKey());
        this.initializeTask(user, (TaskJob)emptyTaskJob, taskReference, taskName);
    }

    private void initializeMetricDefinitionImplement(JwtSecurityUser user) {
        String taskName = "Metric Implementation Job: " + this.getUserTitle(user);
        MetricDefinitionImplementationJob emptyTaskJob = new MetricDefinitionImplementationJob();
        TaskReference taskReference = new TaskReference(TaskReferencedEntityType.METRIC_DEFINITION_IMPLEMENT, user.getTenantCustomerKey());
        this.initializeTask(user, (TaskJob)emptyTaskJob, taskReference, taskName);
    }

    private void initializeSystemPromptExecutions(JwtSecurityUser user) {
        this.customPromptService.getAllSystemCustomPromptLite().forEach(customPromptLite -> {
            String taskName = "%s Execution: %s".formatted(customPromptLite.getName(), this.getUserTitle(user));
            CustomPromptJob emptyTaskJob = new CustomPromptJob();
            TaskReference taskReference = new TaskReference(TaskReferencedEntityType.AI_PROMPT_EXECUTION_TASK, user.getTenantCustomerKey() + "/" + String.valueOf(customPromptLite.getId()));
            this.initializeTask(user, (TaskJob)emptyTaskJob, taskReference, taskName);
        });
    }

    private void initializeTextPromptExecution(JwtSecurityUser user) {
        String taskName = "Text AI prompt execution: %s".formatted(this.getUserTitle(user));
        CustomPromptJob emptyTaskJob = new CustomPromptJob();
        TaskReference taskReference = new TaskReference(TaskReferencedEntityType.AI_PROMPT_EXECUTION_TASK, user.getTenantCustomerKey() + "/" + String.valueOf(EntityId.NULL_UUID));
        this.initializeTask(user, (TaskJob)emptyTaskJob, taskReference, taskName);
    }

    private String getUserTitle(JwtSecurityUser user) {
        return user.isCustomerUser() ? this.userManagementService.getCustomerName(user) : this.userManagementService.getTenantName(user.getTenantId());
    }

    private String getTenantTitle(JwtSecurityUser user) {
        return this.userManagementService.getTenantName(user.getTenantId());
    }
}

