/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.service.task.TaskExecutionProgressContent;
import org.thingsboard.trendz.service.task.TaskExecutionProgressService;
import org.thingsboard.trendz.tools.DateTimeUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TaskExecutionProgressStepBuilder
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecutionProgressStepBuilder.class);
    private final TaskExecutionProgressService service;
    private final UUID taskId;
    private final UUID executionId;
    private final UUID id;
    private final UUID parentStepId;
    private final List<TaskExecutionProgressStepBuilder> childrenSteps;
    private final String name;
    private final TaskExecutionProgressContent mutableContent;
    private boolean closed;
    private long startTs;
    private long endTs;
    private final Object lock = new Object();

    private TaskExecutionProgressStepBuilder(TaskExecutionProgressService service, UUID taskId, UUID executionId, UUID id, UUID parentId, String name, TaskExecutionProgressContent mutableContent) {
        this.service = service;
        this.taskId = taskId;
        this.executionId = executionId;
        this.id = id;
        this.parentStepId = parentId;
        this.childrenSteps = Collections.synchronizedList(new LinkedList());
        this.closed = false;
        this.startTs = System.currentTimeMillis();
        this.endTs = 0L;
        this.name = name;
        this.mutableContent = mutableContent;
    }

    private void trigger() {
        this.service.trigger(this);
    }

    public static TaskExecutionProgressStepBuilder createRootStepBuilder(TaskExecutionProgressService service, UUID taskId, UUID executionId, TaskExecutionProgressContent mutableContent) {
        TaskExecutionProgressStepBuilder stepBuilder = new TaskExecutionProgressStepBuilder(service, taskId, executionId, TimeStampUUIDGenerator.generateId(), EntityId.NULL_UUID, "ROOT", mutableContent);
        stepBuilder.trigger();
        return stepBuilder;
    }

    public <T extends TaskExecutionProgressContent> T getStepContent(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Return type is required");
        }
        return (T)this.mutableContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskExecutionProgressStepBuilder makeStep(String name) {
        TaskExecutionProgressStepBuilder stepBuilder;
        if (name == null || name.isBlank()) {
            throw new IllegalArgumentException("Name is required");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("The progress step is already finished");
            }
            UUID childId = TimeStampUUIDGenerator.generateId();
            stepBuilder = new TaskExecutionProgressStepBuilder(this.service, this.taskId, this.executionId, childId, this.id, name, this.mutableContent);
            this.childrenSteps.add(stepBuilder);
        }
        log.info("Progress step started: {}", (Object)stepBuilder.name);
        this.trigger();
        return stepBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LinkedList children;
        Object object = this.lock;
        synchronized (object) {
            children = new LinkedList(this.childrenSteps);
        }
        for (TaskExecutionProgressStepBuilder child : children) {
            if (child.isClosed()) continue;
            child.close();
        }
        object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("The progress step is already finished: " + this.name);
            }
            this.closed = true;
            this.endTs = System.currentTimeMillis();
        }
        log.info("Progress step finished: {}", (Object)this.name);
        this.trigger();
    }

    public void makeStep(String name, Runnable action) {
        try (TaskExecutionProgressStepBuilder step = this.makeStep(name);){
            action.run();
        }
    }

    public <T> T makeStep(String name, Supplier<T> action) {
        try (TaskExecutionProgressStepBuilder step = this.makeStep(name);){
            T t = action.get();
            return t;
        }
    }

    public <T> Mono<T> makeStep(String name, Mono<T> publisher) {
        return Mono.defer(() -> {
            TaskExecutionProgressStepBuilder step = this.makeStep(name);
            return publisher.doOnSuccess(o -> step.close()).doOnError(t -> step.close());
        });
    }

    public <T> Flux<T> makeStep(String name, Flux<T> publisher) {
        return Flux.defer(() -> {
            TaskExecutionProgressStepBuilder step = this.makeStep(name);
            return publisher.doOnTerminate(() -> step.close());
        });
    }

    public void makeStep(String name, Consumer<TaskExecutionProgressStepBuilder> action) {
        if (action == null) {
            throw new IllegalArgumentException("Action is required");
        }
        try (TaskExecutionProgressStepBuilder step = this.makeStep(name);){
            action.accept(step);
        }
    }

    public <T> T makeStep(String name, Function<TaskExecutionProgressStepBuilder, T> action) {
        if (action == null) {
            throw new IllegalArgumentException("Action is required");
        }
        TaskExecutionProgressStepBuilder step = this.makeStep(name);
        T result = action.apply(step);
        if (result instanceof Mono) {
            return (T)((Mono)result).doOnSuccess(o -> step.close()).doOnError(t -> step.close());
        }
        if (result instanceof Flux) {
            Flux flux = (Flux)result;
            return (T)flux.doOnTerminate(() -> step.close());
        }
        step.close();
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.name).append("closed", this.closed).append("startTs", this.startTs == 0L ? "not set" : DateTimeUtils.fromTs((long)this.startTs)).append("endTs", this.endTs == 0L ? "not set" : DateTimeUtils.fromTs((long)this.endTs)).append("children", this.childrenSteps.size()).append("content", (Object)this.mutableContent.getClass().getName()).append("id", (Object)this.id).append("parentStepId", (Object)this.parentStepId).append("executionId", (Object)this.executionId).toString();
    }

    @Generated
    public TaskExecutionProgressService getService() {
        return this.service;
    }

    @Generated
    public UUID getTaskId() {
        return this.taskId;
    }

    @Generated
    public UUID getExecutionId() {
        return this.executionId;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public UUID getParentStepId() {
        return this.parentStepId;
    }

    @Generated
    public List<TaskExecutionProgressStepBuilder> getChildrenSteps() {
        return this.childrenSteps;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public TaskExecutionProgressContent getMutableContent() {
        return this.mutableContent;
    }

    @Generated
    public boolean isClosed() {
        return this.closed;
    }

    @Generated
    public long getStartTs() {
        return this.startTs;
    }

    @Generated
    public long getEndTs() {
        return this.endTs;
    }

    @Generated
    public Object getLock() {
        return this.lock;
    }

    @Generated
    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    @Generated
    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    @Generated
    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskExecutionProgressStepBuilder)) {
            return false;
        }
        TaskExecutionProgressStepBuilder other = (TaskExecutionProgressStepBuilder)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isClosed() != other.isClosed()) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        TaskExecutionProgressService this$service = this.getService();
        TaskExecutionProgressService other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        UUID this$taskId = this.getTaskId();
        UUID other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId)) {
            return false;
        }
        UUID this$executionId = this.getExecutionId();
        UUID other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !((Object)this$executionId).equals(other$executionId)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$parentStepId = this.getParentStepId();
        UUID other$parentStepId = other.getParentStepId();
        if (this$parentStepId == null ? other$parentStepId != null : !((Object)this$parentStepId).equals(other$parentStepId)) {
            return false;
        }
        List this$childrenSteps = this.getChildrenSteps();
        List other$childrenSteps = other.getChildrenSteps();
        if (this$childrenSteps == null ? other$childrenSteps != null : !((Object)this$childrenSteps).equals(other$childrenSteps)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        TaskExecutionProgressContent this$mutableContent = this.getMutableContent();
        TaskExecutionProgressContent other$mutableContent = other.getMutableContent();
        if (this$mutableContent == null ? other$mutableContent != null : !this$mutableContent.equals(other$mutableContent)) {
            return false;
        }
        Object this$lock = this.getLock();
        Object other$lock = other.getLock();
        return !(this$lock == null ? other$lock != null : !this$lock.equals(other$lock));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskExecutionProgressStepBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isClosed() ? 79 : 97);
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        TaskExecutionProgressService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        UUID $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        UUID $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : ((Object)$executionId).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $parentStepId = this.getParentStepId();
        result = result * 59 + ($parentStepId == null ? 43 : ((Object)$parentStepId).hashCode());
        List $childrenSteps = this.getChildrenSteps();
        result = result * 59 + ($childrenSteps == null ? 43 : ((Object)$childrenSteps).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        TaskExecutionProgressContent $mutableContent = this.getMutableContent();
        result = result * 59 + ($mutableContent == null ? 43 : $mutableContent.hashCode());
        Object $lock = this.getLock();
        result = result * 59 + ($lock == null ? 43 : $lock.hashCode());
        return result;
    }
}

