/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutorManager;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.service.task.model.TaskRetryPolicy;
import org.thingsboard.trendz.service.task.model.TaskRetryPolicyType;
import org.thingsboard.trendz.service.task.model.TaskSchedule;
import org.thingsboard.trendz.service.task.model.TaskScheduleType;
import org.thingsboard.trendz.service.task.model.TaskStoreExecutionConfig;
import org.thingsboard.trendz.service.task.model.TaskTimeoutConfig;
import org.thingsboard.trendz.service.task.model.TaskTtlConfig;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Service
public class TaskDeserializer
extends JsonDeserializer<Task> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskDeserializer.class);
    private final TaskJobExecutorManager executorManager;

    @Autowired
    public TaskDeserializer(TaskJobExecutorManager executorManager) {
        this.executorManager = executorManager;
        JsonUtils.registerDeserializer(Task.class, (JsonDeserializer)this);
    }

    public Task deserialize(JsonParser jsonParser, DeserializationContext ctxt) {
        String name = "null";
        try {
            Map map = (Map)jsonParser.readValueAs(HashMap.class);
            name = (String)map.get("name");
            Map jobMap = (Map)map.remove("job");
            String jobTypeStr = (String)map.get("jobType");
            TaskJobType jobType = TaskJobType.valueOf((String)jobTypeStr);
            Class jobClass = this.executorManager.getJobClassByType(jobType);
            TaskJob job = (TaskJob)JsonUtils.fromNodeToObject((JsonNode)JsonUtils.getObjectMapper().valueToTree((Object)jobMap), (Class)jobClass);
            return new Task(UUID.fromString((String)map.get("id")), this.jwtSecurityUser((Map)map.get("user")), ((Number)map.get("createdTs")).longValue(), ((Number)map.get("updatedTs")).longValue(), name, ((Boolean)map.get("enabled")).booleanValue(), this.schedule((Map)map.get("schedule")), this.taskTllConfig((Map)map.get("ttlConfig")), this.taskStoreExecutionConfig((Map)map.get("storeExecutionConfig")), this.taskTimeoutConfig((Map)map.get("timeoutConfig")), this.retryPolicy((Map)map.get("retryPolicy")), TaskJobType.valueOf((String)((String)map.get("jobType"))), job, this.taskReference((Map)map.get("reference")), List.of());
        }
        catch (Exception e) {
            String message = "The exception during task deserialization, task = '%s'".formatted(name);
            throw new TrendzException(message, (Throwable)e);
        }
    }

    private TaskReference taskReference(Map<String, String> map) {
        TaskReferencedEntityType type = TaskReferencedEntityType.valueOf((String)map.get("type"));
        return new TaskReference(type, map.get("key"));
    }

    private TaskTimeoutConfig taskTimeoutConfig(Map<String, Object> ttlConfig) {
        return new TaskTimeoutConfig(((Boolean)ttlConfig.get("enabled")).booleanValue(), ((Number)ttlConfig.get("duration")).longValue());
    }

    private TaskTtlConfig taskTllConfig(Map<String, Object> ttlConfig) {
        return new TaskTtlConfig(((Boolean)ttlConfig.get("enabled")).booleanValue(), ((Number)ttlConfig.get("duration")).longValue());
    }

    private TaskStoreExecutionConfig taskStoreExecutionConfig(Map<String, Object> storeSettings) {
        if (storeSettings == null) {
            return TaskStoreExecutionConfig.getDefault();
        }
        return new TaskStoreExecutionConfig(((Boolean)storeSettings.get("enabled")).booleanValue(), ((Number)storeSettings.get("count")).intValue());
    }

    private JwtSecurityUser jwtSecurityUser(Map<String, String> map) {
        return new JwtSecurityUser(UUID.fromString(map.get("tenantId")), UUID.fromString(map.get("customerId")), UUID.fromString(map.get("userId")));
    }

    private TaskSchedule schedule(Map<String, Object> map) {
        return new TaskSchedule(TaskScheduleType.valueOf((String)((String)map.get("type"))), ((Number)map.get("periodMs")).longValue(), ((Number)map.get("plannedTs")).longValue(), ChronoUnit.valueOf(map.get("schedulingUnit").toString()), ((Number)map.get("schedulingUnitCount")).intValue(), map.get("schedulingTimeZone").toString());
    }

    private TaskRetryPolicy retryPolicy(Map<String, String> retryPolicy) {
        return new TaskRetryPolicy(TaskRetryPolicyType.valueOf((String)retryPolicy.get("type")));
    }
}

