/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.startup;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.tb.configuration.TbConfiguration;
import org.thingsboard.trendz.domain.tb.widget.base.UploadTbResourceStatus;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.startup.TrendzPostReadyStartupService;
import org.thingsboard.trendz.service.tb.configuration.TbConfigurationStorage;
import org.thingsboard.trendz.service.tb.module.TbModuleService;
import org.thingsboard.trendz.service.tb.widget.NativeWidgetBundleServiceComposite;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Service
public class SystemInitializationService
implements TrendzPostReadyStartupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemInitializationService.class);
    private final TbConfigurationStorage tbConfigurationStorage;
    private final NativeWidgetBundleServiceComposite nativeWidgetBundleService;
    private final TbModuleService tbModuleService;
    private final TbRestDataSource tbRestDataSource;

    @Autowired
    public SystemInitializationService(TbConfigurationStorage tbConfigurationStorage, NativeWidgetBundleServiceComposite nativeWidgetBundleService, TbModuleService tbModuleService, TbRestDataSource tbRestDataSource) {
        this.tbConfigurationStorage = tbConfigurationStorage;
        this.nativeWidgetBundleService = nativeWidgetBundleService;
        this.tbModuleService = tbModuleService;
        this.tbRestDataSource = tbRestDataSource;
    }

    public void onPostReady(ApplicationContext context) {
        try {
            TbConfiguration configuration = this.tbConfigurationStorage.getTbConfiguration();
            log.info("TB Configuration: {}", configuration.isEnabled() ? "ENABLED, URL = " + configuration.getUrl() : "DISABLED");
            if (configuration.isEnabled()) {
                this.uploadResources();
            } else {
                DonReactive.block((Mono)this.tbRestDataSource.triggerThingsBoardSync());
                log.info("ThingsBoard sync was triggered during startup.");
            }
        }
        catch (RuntimeException e) {
            log.error("Error during startup initialization.", (Throwable)e);
        }
    }

    public int priority() {
        return 101;
    }

    public void uploadResources() {
        UploadTbResourceStatus bundleStatus = this.nativeWidgetBundleService.uploadNativeWidgetBundle(JwtSecurityUser.NOT_USER, null, null);
        UploadTbResourceStatus jsModuleStatus = this.tbModuleService.uploadModule(JwtSecurityUser.NOT_USER, null);
        log.info("Resource startup check: bundleStatus = {}, jsModuleStatus = {}", (Object)bundleStatus, (Object)jsModuleStatus);
    }
}

