/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.startup;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.ApplicationProperty;
import org.thingsboard.trendz.service.definition.ApplicationPropertyService;
import org.thingsboard.trendz.service.startup.TrendzStartupService;

@Service
public class StartupValidationService
implements TrendzStartupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StartupValidationService.class);
    private static final String currentTrendzVersion = "1.15.0";
    private final ApplicationPropertyService applicationPropertyService;

    @Autowired
    public StartupValidationService(ApplicationPropertyService applicationPropertyService) {
        this.applicationPropertyService = applicationPropertyService;
    }

    public void onStartup(ApplicationContext context) {
        try {
            String version = (String)this.applicationPropertyService.getProperty(ApplicationProperty.Key.DATABASE_VERSION).orElseThrow(() -> new Exception("The version of database is not defined in application properties."));
            if (!currentTrendzVersion.equals(version)) {
                throw new Exception("The version of database is NOT matching to Trendz version. Expected: [1.15.0], actual [" + version + "]");
            }
            log.info("The version of database is matching to Trendz version [{}]", (Object)version);
        }
        catch (Exception e) {
            log.error("The startup validation is not passes, the system will be closed", (Throwable)e);
            SpringApplication.exit((ApplicationContext)context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 1});
        }
    }

    public int priority() {
        return 10;
    }
}

