/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.sql.dialect;

import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.sql.RelationalDatabaseType;
import org.thingsboard.trendz.service.sql.dialect.SqlQueryDialectBuilder;
import org.thingsboard.trendz.service.sql.dialect.SqlQueryPostgresDialectBuilder;

@Component
public class SqlQueryPostgresDialectBuilder
implements SqlQueryDialectBuilder {
    public RelationalDatabaseType getType() {
        return RelationalDatabaseType.POSTGRESQL;
    }

    public String queryTemplate() {
        return "SELECT %s\nFROM %s\nWHERE %s\nGROUP BY %s;\n";
    }

    public String quote(String s) {
        return "\"" + s.replace("\"", "\"\"") + "\"";
    }

    public String getDateAggregation(String dateFieldName, String tzName, DateAggregationType fullAggregation) {
        String quotedDateFieldName = this.quote(dateFieldName);
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[fullAggregation.ordinal()]) {
            case 1 -> this.dateTrunc("MINUTE", quotedDateFieldName, tzName);
            case 2 -> this.dateTrunc("HOUR", quotedDateFieldName, tzName);
            case 3 -> this.dateTrunc("DAY", quotedDateFieldName, tzName);
            case 4 -> this.dateTrunc("WEEK", quotedDateFieldName, tzName);
            case 5 -> this.dateTrunc("MONTH", quotedDateFieldName, tzName);
            case 6 -> this.dateTrunc("QUARTER", quotedDateFieldName, tzName);
            case 7 -> this.dateTrunc("YEAR", quotedDateFieldName, tzName);
            default -> throw new IllegalArgumentException("Unsupported DateAggregationType: " + String.valueOf(fullAggregation));
        };
    }

    public String toSelectFieldPart(String aliasSourceName, FieldAggregation aggregation, String dateFieldName) {
        String fieldPartTemplate = switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$FieldAggregation[aggregation.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1, 2, 3, 4, 5 -> aggregation.name().toLowerCase() + "(%s) as %s";
            case 6, 7 -> "%s as %s";
            case 8 -> "(array_agg(%s order by " + this.quote(dateFieldName) + " desc))[1] AS %s";
        };
        String quotedAlias = this.makeAggregatedKeyAliasQuote(aliasSourceName, aggregation);
        return String.format(fieldPartTemplate, this.quote(aliasSourceName), quotedAlias);
    }

    public String selectAllTableNames() {
        return "SELECT table_name\nFROM information_schema.tables\nWHERE table_type = 'BASE TABLE'\n  AND table_schema = current_schema()\nORDER BY table_name;\n";
    }

    private String makeAggregatedKeyAliasQuote(String aliasSourceName, FieldAggregation type) {
        return this.quote(aliasSourceName + "_" + type.name().toLowerCase());
    }

    private String dateTrunc(String unit, String dateFieldName, String tzName) {
        return "date_trunc('%s', (to_timestamp(%s/1000) AT TIME ZONE '%s'))".formatted(unit, dateFieldName, tzName);
    }
}

