/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.sql.SqlDatasourceDao;
import org.thingsboard.trendz.domain.sql.SqlDatasource;
import org.thingsboard.trendz.domain.sql.SqlTableInfo;
import org.thingsboard.trendz.exception.sql.SqlDatasourceConnectionException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;
import org.thingsboard.trendz.service.sql.SqlDatasourceService;
import org.thingsboard.trendz.service.sql.SqlQueryBuilder;

@Service
public class SqlDatasourceService {
    private final SqlDatasourceDao sqlDatasourceDao;
    private final SqlQueryBuilder sqlQueryBuilder;

    @Autowired
    public SqlDatasourceService(SqlDatasourceDao sqlDatasourceDao, SqlQueryBuilder sqlQueryBuilder) {
        this.sqlDatasourceDao = sqlDatasourceDao;
        this.sqlQueryBuilder = sqlQueryBuilder;
    }

    public SqlDatasource getById(UUID tenantId, UUID datasourceId) {
        return this.sqlDatasourceDao.findById(tenantId, datasourceId);
    }

    public List<Map<String, Object>> executeQuery(String query, SqlDatasource sqlDatasource) {
        DriverManagerDataSource dataSource = this.mapToDriverManagedDataSource(sqlDatasource);
        JdbcTemplate template = new JdbcTemplate((DataSource)dataSource);
        return template.queryForList(query);
    }

    public List<SqlDatasource> findAll(JwtSecurityUser user) {
        return this.sqlDatasourceDao.findAll(user);
    }

    public SqlDatasource save(JwtSecurityUser user, SqlDatasource sqlDatasource) {
        this.testConnection(sqlDatasource);
        return this.sqlDatasourceDao.save(user, sqlDatasource);
    }

    public boolean delete(JwtSecurityUser user, UUID datasourceId) {
        return this.sqlDatasourceDao.delete(user, datasourceId);
    }

    public SqlTableInfo findTableNames(JwtSecurityUser user, UUID id) {
        SqlDatasource sqlDatasource = this.getById(user.getTenantId(), id);
        String query = this.sqlQueryBuilder.buildGetAllTablesQuery(sqlDatasource.getDbType());
        List result = this.executeQuery(query, sqlDatasource);
        List tables = result.stream().map(row -> new SqlTableInfo.Table(row.get("table_name").toString())).collect(Collectors.toList());
        return new SqlTableInfo(tables);
    }

    private DriverManagerDataSource mapToDriverManagedDataSource(SqlDatasource sqlDatasource) {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        String driverClassName = switch (1.$SwitchMap$org$thingsboard$trendz$domain$sql$RelationalDatabaseType[sqlDatasource.getDbType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> "org.postgresql.Driver";
            case 2 -> "com.mysql.cj.jdbc.Driver";
            case 3 -> "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            case 4 -> "oracle.jdbc.OracleDriver";
        };
        dataSource.setDriverClassName(driverClassName);
        dataSource.setUrl(sqlDatasource.getUrl());
        dataSource.setUsername(sqlDatasource.getLogin());
        dataSource.setPassword(sqlDatasource.getPassword());
        return dataSource;
    }

    private void testConnection(SqlDatasource sqlDatasource) {
        try (Connection connection = this.mapToDriverManagedDataSource(sqlDatasource).getConnection();){
            connection.isClosed();
        }
        catch (SQLException e) {
            throw new SqlDatasourceConnectionException(sqlDatasource, e);
        }
    }

    public List<SqlDatasource> saveAll(List<SqlDatasource> sqlDatasource, JwtSecurityUser user) {
        return this.sqlDatasourceDao.saveAll(sqlDatasource, user);
    }

    public ChangeEntityValidationInfo findDependedEntities(JwtSecurityUser user, SqlDatasource entity) {
        return this.sqlDatasourceDao.findDependedEntities(user, entity);
    }
}

