/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.simple;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.runtime.DataCell;
import org.thingsboard.trendz.domain.runtime.DataRow;
import org.thingsboard.trendz.domain.runtime.ViewReport;
import org.thingsboard.trendz.domain.simple.SimpleViewReport;
import org.thingsboard.trendz.domain.simple.ViewConfigReference;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.ViewConfigService;

@Service
public class SimpleDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimpleDataService.class);
    @Autowired
    private ViewConfigService viewConfigService;

    public ViewConfig getViewConfigByReference(ViewConfigReference reference, JwtSecurityUser user) {
        Set referenceFilterSet;
        Set configFilterSet;
        ViewConfig viewConfig = (ViewConfig)this.viewConfigService.findConfigById(user, reference.getViewConfigId()).orElseThrow(() -> new IllegalArgumentException("Invalid reference: View Config is not found by given ID: " + String.valueOf(reference.getViewConfigId())));
        if (reference.getRangeStartTs() == null ^ reference.getRangeEndTs() == null) {
            throw new IllegalArgumentException("Invalid reference: 'rangeStartTs' and 'rangeEndTs' must be present or absent together.");
        }
        if (reference.getRangeStartTs() != null && reference.getRangeEndTs() != null) {
            viewConfig.getDatePickerConfig().setSelectedType(null);
            viewConfig.getDatePickerConfig().setStartTs(reference.getRangeStartTs().longValue());
            viewConfig.getDatePickerConfig().setEndTs(reference.getRangeEndTs().longValue());
        }
        if (!(configFilterSet = viewConfig.getRuntimeFilters().stream().map(RuntimeFilterField::getName).collect(Collectors.toSet())).equals(referenceFilterSet = reference.getFilters().keySet())) {
            throw new IllegalArgumentException("Invalid reference: filter fields of reference do not correspond to view config filters.");
        }
        if (reference.getFilters() != null) {
            HashMap labelToFilter = new HashMap();
            viewConfig.getRuntimeFilters().forEach(filter -> labelToFilter.put(filter.getName(), filter));
            reference.getFilters().keySet().forEach(label -> {
                RuntimeFilterField filter = (RuntimeFilterField)labelToFilter.get(label);
                HashSet selectedItemNames = Sets.newHashSet((Iterable)((Iterable)reference.getFilters().get(label)));
                filter.setSelection((Set)selectedItemNames);
                filter.setOptions((Set)selectedItemNames);
            });
        }
        return viewConfig;
    }

    public SimpleViewReport getSimplifiedViewReport(ViewConfig viewConfig, ViewReport viewReport) {
        List allNotHiddenFields = viewConfig.getXAxis();
        allNotHiddenFields.addAll(viewConfig.getYAxis());
        allNotHiddenFields.addAll(viewConfig.getSeries());
        HashMap idToFieldLabel = new HashMap();
        allNotHiddenFields.forEach(field -> idToFieldLabel.put(field.getId(), field.getLabel()));
        ArrayList dataTable = new ArrayList();
        for (DataRow row : viewReport.getRows()) {
            HashMap<String, Object> simpleRow = new HashMap<String, Object>();
            for (DataCell cell : row.getCells()) {
                String key = (String)idToFieldLabel.get(cell.getViewFieldId());
                Object value = cell.getData();
                simpleRow.put(key, value);
            }
            dataTable.add(simpleRow);
        }
        return SimpleViewReport.builder().columnLabels((List)Lists.newArrayList(idToFieldLabel.values())).dataTable(dataTable).build();
    }
}

