/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.simple;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.simple.BuildViewByReferenceTask;
import org.thingsboard.trendz.domain.simple.SimpleApiTask;
import org.thingsboard.trendz.domain.simple.SimpleViewReport;
import org.thingsboard.trendz.domain.simple.ViewConfigReference;
import org.thingsboard.trendz.exception.BadConfiguredTaskException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.simple.SimpleApiService;

@Service
public class SimpleApiServiceRateLimiter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimpleApiServiceRateLimiter.class);
    private final ListeningExecutorService listeningExecutorService;
    private final SimpleApiService simpleApiService;

    @Autowired
    public SimpleApiServiceRateLimiter(ExecutorManagementService executorManagementService, SimpleApiService simpleApiService) {
        this.listeningExecutorService = MoreExecutors.listeningDecorator((ExecutorService)executorManagementService.getExecutorByName(ExecutorName.SIMPLE_API_THROTTLING));
        this.simpleApiService = simpleApiService;
    }

    public ListenableFuture<SimpleApiTask> submitTask(SimpleApiTask task) {
        ListenableFuture future = this.listeningExecutorService.submit(() -> {
            try {
                log.info("The task has been started {}", task.getClass());
                if (task instanceof BuildViewByReferenceTask) {
                    return this.processBuildViewTask((BuildViewByReferenceTask)task);
                }
                throw new IllegalArgumentException("Task type is not supported: " + String.valueOf(task));
            }
            catch (IllegalArgumentException e) {
                throw new BadConfiguredTaskException("Not valid data are provided: ", (Throwable)e);
            }
            catch (Exception e) {
                throw new Exception("Error during task processing: " + e.getMessage(), e);
            }
        });
        log.info("The task has been submitted {}", task.getClass());
        return future;
    }

    private BuildViewByReferenceTask processBuildViewTask(BuildViewByReferenceTask buildTask) {
        ViewConfigReference reference = buildTask.getReference();
        JwtSecurityUser user = buildTask.getSecurityUser();
        SimpleViewReport report = this.simpleApiService.buildViewByReference(reference, user);
        buildTask.setResult(report);
        return buildTask;
    }
}

